/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.module.GeneralModuleType;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.GotItTooltip;
import com.intellij.ui.ScrollPaneFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GeneralModuleTypeForIdea
extends GeneralModuleType {
    @NotNull
    public ModuleBuilder createModuleBuilder() {
        return new GeneralModuleType.GeneralModuleBuilder(){

            @NotNull
            public List<Class<? extends ModuleWizardStep>> getIgnoredSteps() {
                List<Class<? extends ModuleWizardStep>> list2 = List.of(ProjectSettingsStep.class);
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @NotNull
            public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
                ProjectSettingsStep step = new ProjectSettingsStep(context);
                step.getExpertPlaceholder().removeAll();
                JTextPane textPane = new JTextPane();
                textPane.setText(this.getDescription());
                step.getExpertPlaceholder().setMinimumSize(new Dimension(0, 100));
                step.getExpertPlaceholder().add(ScrollPaneFactory.createScrollPane((Component)textPane));
                ProjectSettingsStep projectSettingsStep = step;
                if (projectSettingsStep == null) {
                    1.$$$reportNull$$$0(1);
                }
                return projectSettingsStep;
            }

            public boolean isAvailable() {
                return false;
            }

            public ModuleType<?> getModuleType() {
                return GeneralModuleTypeForIdea.this;
            }

            @Nullable
            public List<Module> commit(@NotNull Project project2, ModifiableModuleModel model, ModulesProvider modulesProvider) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                List modules = super.commit(project2, model, modulesProvider);
                1.scheduleTooltip(project2);
                return modules;
            }

            private static void scheduleTooltip(final @NotNull Project project2) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                StartupManager.getInstance((Project)project2).runAfterOpened(() -> {
                    if (ProjectView.getInstance((Project)project2).getCurrentProjectViewPane() != null) {
                        1.showTooltip(project2);
                        return;
                    }
                    project2.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

                        public void toolWindowShown(@NotNull ToolWindow toolWindow) {
                            if (toolWindow == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (!"Project".equals(toolWindow.getId())) {
                                return;
                            }
                            1.showTooltip(project2);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWindow", "com/intellij/ide/projectWizard/GeneralModuleTypeForIdea$1$1", "toolWindowShown"));
                        }
                    });
                });
            }

            private static void showTooltip(Project project2) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    JTree tree = ProjectView.getInstance((Project)project2).getCurrentProjectViewPane().getTree();
                    if (tree == null) {
                        return;
                    }
                    String shortcutText = KeymapUtil.getShortcutText((String)"NewElement");
                    final GotItTooltip tooltip = new GotItTooltip("empty.project.create.file", IdeBundle.message((String)"to.create.new.file.tooltip", (Object[])new Object[]{shortcutText}), (Disposable)JavaPluginDisposable.getInstance((Project)project2)).withPosition(Balloon.Position.atRight);
                    ApplicationManager.getApplication().getMessageBus().connect((Disposable)tooltip).subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

                        public void afterActionPerformed(@NotNull AnAction action, @NotNull AnActionEvent event, @NotNull AnActionResult result) {
                            if (action == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            if (event == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            if (result == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            tooltip.gotIt();
                            Disposer.dispose((Disposable)tooltip);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "action";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "result";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/ide/projectWizard/GeneralModuleTypeForIdea$1$2";
                            objectArray[2] = "afterActionPerformed";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    tooltip.show((JComponent)tree, (component, balloon) -> 1.getPoint(tree));
                });
            }

            private static Point getPoint(JTree tree) {
                TreePath path = tree.getSelectionPath();
                Rectangle bounds = tree.getPathBounds(path);
                int x = tree.getVisibleRect().width + 5;
                return bounds == null ? new Point(x, 10) : new Point(x, (int)bounds.getCenterY());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/projectWizard/GeneralModuleTypeForIdea$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIgnoredSteps";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCustomOptionsStep";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/projectWizard/GeneralModuleTypeForIdea$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "commit";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "scheduleTooltip";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 2, 3 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDescription() {
        String string = IdeBundle.message((String)"general.module.type.description", (Object[])new Object[0]);
        if (string == null) {
            GeneralModuleTypeForIdea.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectWizard/GeneralModuleTypeForIdea", "getDescription"));
    }
}

