/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.jdkDownloader.JdkItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JdkVersionDetector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u0005H\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u000fJ\u0012\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/projectWizard/JdkComboBoxCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "JDK_REGISTERED", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "", "NO_JDK_SELECTED", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "JDK_DOWNLOADED", "getGroup", "jdkRegistered", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "jdkDownloaded", "item", "Lcom/intellij/openapi/projectRoots/impl/jdkDownloader/JdkItem;", "noJdkSelected", "findSdkVersion", "sdkVersionString", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nJdkComboBoxCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdkComboBoxCollector.kt\ncom/intellij/ide/projectWizard/JdkComboBoxCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n296#2,2:59\n*S KotlinDebug\n*F\n+ 1 JdkComboBoxCollector.kt\ncom/intellij/ide/projectWizard/JdkComboBoxCollector\n*L\n31#1:59,2\n*E\n"})
public final class JdkComboBoxCollector
extends CounterUsagesCollector {
    @NotNull
    public static final JdkComboBoxCollector INSTANCE = new JdkComboBoxCollector();
    @NotNull
    private static final EventLogGroup GROUP = new EventLogGroup("npw.jdk.combo", 5, null, 4, null);
    @NotNull
    private static final EventId2<String, Integer> JDK_REGISTERED;
    @NotNull
    private static final EventId NO_JDK_SELECTED;
    @NotNull
    private static final EventId2<String, Integer> JDK_DOWNLOADED;

    private JdkComboBoxCollector() {
    }

    @NotNull
    public EventLogGroup getGroup() {
        return GROUP;
    }

    public final void jdkRegistered(@NotNull Sdk sdk) {
        String string;
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        String sdkVersionString = sdk.getVersionString();
        if (sdkVersionString == null) {
            string = JdkVersionDetector.Variant.Unknown.displayName;
        } else {
            Object v3;
            block4: {
                List list2 = JdkVersionDetector.VENDORS;
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"VENDORS");
                Iterable $this$firstOrNull$iv = list2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    CharSequence charSequence = sdkVersionString;
                    Intrinsics.checkNotNull((Object)it);
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    v3 = element$iv;
                    break block4;
                }
                v3 = null;
            }
            if ((string = (String)v3) == null) {
                String string2 = JdkVersionDetector.Variant.Unknown.displayName;
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"displayName");
            }
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String variant = string3;
        int version = this.findSdkVersion(sdkVersionString);
        JDK_REGISTERED.log((Object)variant, (Object)version);
    }

    public final void jdkDownloaded(@NotNull JdkItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        JdkVersionDetector.Variant variant = item.detectVariant();
        String string = variant.displayName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"displayName");
        JDK_DOWNLOADED.log((Object)string, (Object)this.findSdkVersion(item.getPresentableMajorVersionString()));
    }

    public final void noJdkSelected() {
        NO_JDK_SELECTED.log();
    }

    private final int findSdkVersion(String sdkVersionString) {
        MatchResult matchResult;
        Object object;
        return sdkVersionString == null ? -1 : ((object = (matchResult = StringsKt.contains$default((CharSequence)sdkVersionString, (CharSequence)"GraalVM", (boolean)false, (int)2, null) ? Regex.find$default((Regex)new Regex("Java ([0-9]+)"), (CharSequence)sdkVersionString, (int)0, (int)2, null) : Regex.find$default((Regex)new Regex("([0-9]+)"), (CharSequence)sdkVersionString, (int)0, (int)2, null))) != null && (object = object.getGroups()) != null && (object = object.get(1)) != null && (object = object.getValue()) != null ? Integer.parseInt((String)object) : -1);
    }

    static {
        List list2 = JdkVersionDetector.VENDORS;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"VENDORS");
        JDK_REGISTERED = GROUP.registerEvent("jdk.registered", (EventField)EventFields.String((String)"vendor", (List)list2), (EventField)EventFields.Int((String)"version"));
        NO_JDK_SELECTED = GROUP.registerEvent("no.jdk.selected");
        List list3 = JdkVersionDetector.VENDORS;
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"VENDORS");
        JDK_DOWNLOADED = GROUP.registerEvent("jdk.downloaded", (EventField)EventFields.String((String)"vendor", (List)list3), (EventField)EventFields.Int((String)"version"));
    }
}

