/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.shared;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.shared.FormUiUtilKt;
import com.intellij.ide.starters.shared.TextValidationFunction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Row;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0007\u001aR\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0006\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u001a$\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u000b\u001a\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u000bH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\bH\u0002\u001a\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000fH\u0003\u001a&\u0010!\u001a\u00020\u001a2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001a0%H\u0007\u001a\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0007\u001a$\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0006*\u00020+2\b\b\u0001\u0010,\u001a\u00020\u001e2\b\b\u0001\u0010-\u001a\u00020\u001e\u00a8\u0006."}, d2={"gridConstraint", "Ljava/awt/GridBagConstraints;", "col", "", "row", "withValidation", "Lcom/intellij/ui/dsl/builder/Cell;", "T", "Ljavax/swing/JComponent;", "builder", "errorChecks", "", "Lcom/intellij/ide/starters/shared/TextValidationFunction;", "warningChecks", "validatedTextComponents", "", "Ljavax/swing/JTextField;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "validateFormFields", "", "formParent", "contentPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "validatedComponents", "revalidateAllAndHighlight", "", "getJTextField", "component", "getWarningsMessage", "", "warnings", "Lcom/intellij/openapi/ui/ValidationInfo;", "walkCheckedTree", "root", "Lcom/intellij/ui/CheckedTreeNode;", "visitor", "Lkotlin/Function1;", "enableEnterKeyHandling", "list", "Lcom/intellij/ui/CheckboxTreeBase;", "hyperLink", "Lcom/intellij/ui/HyperlinkLabel;", "Lcom/intellij/ui/dsl/builder/Row;", "title", "url", "intellij.java.ui"})
public final class FormUiUtilKt {
    @ApiStatus.Internal
    @NotNull
    public static final GridBagConstraints gridConstraint(int col, int row) {
        GridBagConstraints gridBagConstraints;
        GridBagConstraints $this$gridConstraint_u24lambda_u240 = gridBagConstraints = new GridBagConstraints();
        boolean bl = false;
        $this$gridConstraint_u24lambda_u240.fill = 1;
        $this$gridConstraint_u24lambda_u240.gridx = col;
        $this$gridConstraint_u24lambda_u240.gridy = row;
        $this$gridConstraint_u24lambda_u240.weightx = 1.0;
        $this$gridConstraint_u24lambda_u240.weighty = 1.0;
        return gridBagConstraints;
    }

    @NotNull
    public static final <T extends JComponent> Cell<T> withValidation(@NotNull Cell<? extends T> builder, @NotNull List<? extends TextValidationFunction> errorChecks, @Nullable TextValidationFunction warningChecks, @NotNull List<JTextField> validatedTextComponents, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Intrinsics.checkNotNullParameter(errorChecks, (String)"errorChecks");
        Intrinsics.checkNotNullParameter(validatedTextComponents, (String)"validatedTextComponents");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        if (errorChecks.isEmpty()) {
            return builder;
        }
        JTextField textField = FormUiUtilKt.getJTextField(builder.getComponent());
        Supplier<ValidationInfo> validationFunc = () -> FormUiUtilKt.withValidation$lambda$0(textField, errorChecks, warningChecks);
        new ComponentValidator(parentDisposable).withValidator(validationFunc).installOn((JComponent)textField);
        textField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(textField){
            final /* synthetic */ JTextField $textField;
            {
                this.$textField = $textField;
            }

            protected void textChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ComponentValidator.getInstance((JComponent)this.$textField).ifPresent(arg_0 -> withValidation.1.textChanged$lambda$1(withValidation.1::textChanged$lambda$0, arg_0));
            }

            private static final Unit textChanged$lambda$0(ComponentValidator v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                v.updateInfo(null);
                return Unit.INSTANCE;
            }

            private static final void textChanged$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        });
        textField.addFocusListener(new FocusListener(validatedTextComponents){
            final /* synthetic */ List<JTextField> $validatedTextComponents;
            {
                this.$validatedTextComponents = $validatedTextComponents;
            }

            public void focusGained(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void focusLost(FocusEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FormUiUtilKt.access$revalidateAllAndHighlight(this.$validatedTextComponents);
            }
        });
        validatedTextComponents.add(textField);
        return builder;
    }

    public static final boolean validateFormFields(@NotNull JComponent formParent, @NotNull DialogPanel contentPanel, @NotNull List<? extends JComponent> validatedComponents) {
        String string;
        int n;
        Intrinsics.checkNotNullParameter((Object)formParent, (String)"formParent");
        Intrinsics.checkNotNullParameter((Object)contentPanel, (String)"contentPanel");
        Intrinsics.checkNotNullParameter(validatedComponents, (String)"validatedComponents");
        Ref.ObjectRef firstInvalidComponent = new Ref.ObjectRef();
        for (JComponent jComponent : validatedComponents) {
            ComponentValidator.getInstance((JComponent)jComponent).ifPresent(arg_0 -> FormUiUtilKt.validateFormFields$lambda$1(arg_0 -> FormUiUtilKt.validateFormFields$lambda$0(firstInvalidComponent, jComponent, arg_0), arg_0));
        }
        if (firstInvalidComponent.element != null) {
            contentPanel.setPreferredFocusedComponent((JComponent)firstInvalidComponent.element);
            return false;
        }
        List warnings = new ArrayList();
        for (JComponent jComponent : validatedComponents) {
            ComponentValidator.getInstance((JComponent)jComponent).ifPresent(arg_0 -> FormUiUtilKt.validateFormFields$lambda$3(arg_0 -> FormUiUtilKt.validateFormFields$lambda$2(warnings, arg_0), arg_0));
        }
        return !(!((Collection)warnings).isEmpty()) || (n = Messages.showOkCancelDialog((Component)formParent, (String)(string = FormUiUtilKt.getWarningsMessage(warnings)), (String)IdeBundle.message((String)"title.warning", (Object[])new Object[0]), (String)Messages.getYesButton(), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon())) == 0;
    }

    private static final void revalidateAllAndHighlight(List<? extends JComponent> validatedComponents) {
        for (JComponent jComponent : validatedComponents) {
            ComponentValidator.getInstance((JComponent)jComponent).ifPresent(arg_0 -> FormUiUtilKt.revalidateAllAndHighlight$lambda$1(FormUiUtilKt::revalidateAllAndHighlight$lambda$0, arg_0));
        }
    }

    private static final JTextField getJTextField(JComponent component) {
        JTextField jTextField;
        JComponent jComponent = component;
        if (jComponent instanceof TextFieldWithBrowseButton) {
            JTextField jTextField2 = ((TextFieldWithBrowseButton)component).getTextField();
            jTextField = jTextField2;
            Intrinsics.checkNotNullExpressionValue((Object)jTextField2, (String)"getTextField(...)");
        } else if (jComponent instanceof JTextField) {
            jTextField = (JTextField)component;
        } else {
            throw new IllegalArgumentException();
        }
        return jTextField;
    }

    @NlsSafe
    private static final String getWarningsMessage(List<ValidationInfo> warnings) {
        StringBuilder message = new StringBuilder();
        if (warnings.size() > 1) {
            message.append(JavaStartersBundle.message("project.settings.warnings.group", new Object[0]));
            for (ValidationInfo warning : warnings) {
                message.append("\n- ").append(warning.message);
            }
        } else if (!((Collection)warnings).isEmpty()) {
            message.append(((ValidationInfo)CollectionsKt.first(warnings)).message);
        }
        message.append("\n\n").append(JavaStartersBundle.message("project.settings.warnings.ignore", new Object[0]));
        String string = message.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @ApiStatus.Internal
    public static final void walkCheckedTree(@Nullable CheckedTreeNode root, @NotNull Function1<? super CheckedTreeNode, Unit> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        if (root == null) {
            return;
        }
        FormUiUtilKt.walkCheckedTree$walkTreeNode((TreeNode)root, visitor);
    }

    @ApiStatus.Internal
    public static final void enableEnterKeyHandling(@NotNull CheckboxTreeBase list2) {
        Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
        list2.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "pick-node");
        list2.getActionMap().put("pick-node", new AbstractAction(list2){
            final /* synthetic */ CheckboxTreeBase $list;
            {
                this.$list = $list;
            }

            public void actionPerformed(ActionEvent e) {
                TreePath selection = this.$list.getSelectionPath();
                if (selection != null) {
                    if (selection.getLastPathComponent() instanceof CheckedTreeNode) {
                        Object object = selection.getLastPathComponent();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ui.CheckedTreeNode");
                        CheckedTreeNode node = (CheckedTreeNode)object;
                        this.$list.setNodeState(node, !node.isChecked());
                    } else if (selection.getLastPathComponent() instanceof DefaultMutableTreeNode) {
                        if (this.$list.isExpanded(selection)) {
                            this.$list.collapsePath(selection);
                        } else {
                            this.$list.expandPath(selection);
                        }
                    }
                }
            }
        });
    }

    @NotNull
    public static final Cell<HyperlinkLabel> hyperLink(@NotNull Row $this$hyperLink, @Nls @NotNull String title, @NlsSafe @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)$this$hyperLink, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HyperlinkLabel hyperlinkLabel = new HyperlinkLabel(title);
        hyperlinkLabel.setHyperlinkTarget(url);
        hyperlinkLabel.setToolTipText(url);
        return $this$hyperLink.cell((JComponent)hyperlinkLabel);
    }

    private static final ValidationInfo withValidation$lambda$0(JTextField $textField, List $errorChecks, TextValidationFunction $warningChecks) {
        String warningMessage;
        String text = $textField.getText();
        for (TextValidationFunction validationUnit : $errorChecks) {
            String errorMessage = validationUnit.checkText(text);
            if (errorMessage == null) continue;
            return new ValidationInfo(errorMessage, (JComponent)$textField);
        }
        if ($warningChecks != null && (warningMessage = $warningChecks.checkText(text)) != null) {
            return new ValidationInfo(warningMessage, (JComponent)$textField).asWarning().withOKEnabled();
        }
        return null;
    }

    private static final Unit validateFormFields$lambda$0(Ref.ObjectRef $firstInvalidComponent, JComponent $component, ComponentValidator validator2) {
        Intrinsics.checkNotNullParameter((Object)validator2, (String)"validator");
        validator2.revalidate();
        ValidationInfo validationInfo = validator2.getValidationInfo();
        if (validationInfo != null && !validationInfo.warning && $firstInvalidComponent.element == null) {
            $firstInvalidComponent.element = $component;
        }
        return Unit.INSTANCE;
    }

    private static final void validateFormFields$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit validateFormFields$lambda$2(List $warnings, ComponentValidator validator2) {
        Intrinsics.checkNotNullParameter((Object)validator2, (String)"validator");
        ValidationInfo validationInfo = validator2.getValidationInfo();
        if (validationInfo != null && validationInfo.warning) {
            $warnings.add(validationInfo);
        }
        return Unit.INSTANCE;
    }

    private static final void validateFormFields$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit revalidateAllAndHighlight$lambda$0(ComponentValidator validator2) {
        Intrinsics.checkNotNullParameter((Object)validator2, (String)"validator");
        validator2.revalidate();
        return Unit.INSTANCE;
    }

    private static final void revalidateAllAndHighlight$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void walkCheckedTree$walkTreeNode(TreeNode root, Function1<? super CheckedTreeNode, Unit> visitor) {
        if (root instanceof CheckedTreeNode) {
            visitor.invoke((Object)root);
        }
        Enumeration<? extends TreeNode> enumeration = root.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            TreeNode child = (TreeNode)iterator.next();
            Intrinsics.checkNotNull((Object)child);
            FormUiUtilKt.walkCheckedTree$walkTreeNode(child, visitor);
        }
    }

    public static final /* synthetic */ void access$revalidateAllAndHighlight(List validatedComponents) {
        FormUiUtilKt.revalidateAllAndHighlight(validatedComponents);
    }
}

