/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.shared.ui;

import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.ui.JBColor;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/starters/shared/ui/LibrariesSearchTextField;", "Lcom/intellij/ui/SearchTextField;", "<init>", "()V", "list", "Ljavax/swing/JComponent;", "getList", "()Ljavax/swing/JComponent;", "setList", "(Ljavax/swing/JComponent;)V", "preprocessEventForTextField", "", "event", "Ljava/awt/event/KeyEvent;", "handleListEvents", "getPreferredSize", "Ljava/awt/Dimension;", "toClearTextOnEscape", "intellij.java.ui"})
@ApiStatus.Internal
public final class LibrariesSearchTextField
extends SearchTextField {
    @Nullable
    private JComponent list;

    public LibrariesSearchTextField() {
        this.getTextEditor().putClientProperty((Object)"JTextField.Search.Gap", (Object)JBUIScale.scale((int)6));
        this.getTextEditor().putClientProperty((Object)"JTextField.Search.GapEmptyText", (Object)JBUIScale.scale((int)-1));
        this.getTextEditor().setBorder((Border)JBUI.Borders.empty());
        this.getTextEditor().getEmptyText().setText(JavaStartersBundle.message("hint.library.search", new Object[0]));
        this.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)1, (int)0, (int)1));
    }

    @Nullable
    public final JComponent getList() {
        return this.list;
    }

    public final void setList(@Nullable JComponent jComponent) {
        this.list = jComponent;
    }

    protected boolean preprocessEventForTextField(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        int keyCode = event.getKeyCode();
        int id = event.getID();
        if ((keyCode == 40 || keyCode == 38 || keyCode == 10) && id == 401 && this.handleListEvents(event)) {
            return true;
        }
        return super.preprocessEventForTextField(event);
    }

    private final boolean handleListEvents(KeyEvent event) {
        JComponent selectionTracker = this.list;
        if (selectionTracker != null) {
            selectionTracker.dispatchEvent(event);
            return true;
        }
        return false;
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        size.height = JBUIScale.scale((int)30);
        Intrinsics.checkNotNull((Object)size);
        return size;
    }

    protected boolean toClearTextOnEscape() {
        new AnAction(this){
            final /* synthetic */ LibrariesSearchTextField this$0;
            {
                this.this$0 = $receiver;
                this.setEnabledInModalContext(true);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                String string = this.this$0.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                presentation.setEnabled(((CharSequence)string).length() > 0);
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.setText("");
            }
        }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, (JComponent)((Object)this));
        return false;
    }
}

