/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.facet.impl.DefaultFacetsProvider;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModelImpl;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil;
import com.intellij.ide.util.newProjectWizard.AddSupportForFrameworksPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AddFrameworkSupportDialog
extends DialogWrapper {
    private final AddSupportForFrameworksPanel myAddSupportPanel;
    private final Module myModule;

    private AddFrameworkSupportDialog(@NotNull Module module, @NotNull String contentRootPath, List<FrameworkSupportInModuleProvider> providers) {
        if (module == null) {
            AddFrameworkSupportDialog.$$$reportNull$$$0(0);
        }
        if (contentRootPath == null) {
            AddFrameworkSupportDialog.$$$reportNull$$$0(1);
        }
        super(module.getProject(), true);
        this.setTitle(JavaUiBundle.message("dialog.title.add.frameworks.support", new Object[0]));
        this.myModule = module;
        LibrariesContainer container = LibrariesContainerFactory.createContainer(module.getProject());
        FrameworkSupportModelImpl model = new FrameworkSupportModelImpl(module.getProject(), contentRootPath, container);
        this.myAddSupportPanel = new AddSupportForFrameworksPanel(providers, model, false, null){

            @Override
            protected void onFrameworkStateChanged() {
                AddFrameworkSupportDialog.this.setOKActionEnabled(AddFrameworkSupportDialog.this.isOKActionEnabled());
            }
        };
        this.setOKActionEnabled(this.isOKActionEnabled());
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myAddSupportPanel);
        this.init();
    }

    @Nullable
    public static AddFrameworkSupportDialog createDialog(@NotNull Module module) {
        VirtualFile[] roots;
        if (module == null) {
            AddFrameworkSupportDialog.$$$reportNull$$$0(2);
        }
        if ((roots = ModuleRootManager.getInstance((Module)module).getContentRoots()).length == 0) {
            return null;
        }
        List<FrameworkSupportInModuleProvider> providers = FrameworkSupportUtil.getProviders(module, DefaultFacetsProvider.INSTANCE);
        if (providers.isEmpty()) {
            return null;
        }
        return new AddFrameworkSupportDialog(module, roots[0].getPath(), providers);
    }

    public static boolean isAvailable(@NotNull Module module) {
        VirtualFile[] roots;
        if (module == null) {
            AddFrameworkSupportDialog.$$$reportNull$$$0(3);
        }
        return (roots = ModuleRootManager.getInstance((Module)module).getContentRoots()).length != 0 && FrameworkSupportUtil.hasProviders(module, DefaultFacetsProvider.INSTANCE);
    }

    public boolean isOKActionEnabled() {
        return this.myAddSupportPanel.hasSelectedFrameworks();
    }

    protected void doOKAction() {
        if (this.myAddSupportPanel.hasSelectedFrameworks()) {
            if (!this.myAddSupportPanel.validate()) {
                return;
            }
            if (!this.myAddSupportPanel.downloadLibraries(this.myAddSupportPanel.getMainPanel())) {
                return;
            }
            WriteAction.run(() -> {
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
                this.myAddSupportPanel.addSupport(this.myModule, model);
                model.commit();
            });
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.ide.util.frameworkSupport.AddFrameworkSupportDialog";
    }

    protected String getHelpId() {
        return "reference.frameworks.support.dialog";
    }

    protected JComponent createCenterPanel() {
        return this.myAddSupportPanel.getMainPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myAddSupportPanel.getFrameworksTree();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/frameworkSupport/AddFrameworkSupportDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

