/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JavaModuleInsight
extends ModuleInsight {
    private static final Logger LOG = Logger.getInstance(JavaModuleInsight.class);
    private final Lexer myLexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);

    public JavaModuleInsight(@Nullable ProgressIndicator progress, Set<String> existingModuleNames, Set<String> existingProjectLibraryNames) {
        super(progress, existingModuleNames, existingProjectLibraryNames);
    }

    @Override
    public void scanModules() {
        this.scanModuleInfoFiles();
        super.scanModules();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanModuleInfoFiles() {
        List<DetectedSourceRoot> allRoots = super.getSourceRootsToScan();
        List moduleInfoRoots = ((StreamEx)((StreamEx)StreamEx.of(allRoots).select(JavaModuleSourceRoot.class).filter(JavaModuleSourceRoot::isWithModuleInfoFile)).filter(root -> !this.isIgnoredName(root.getDirectory()))).toList();
        if (moduleInfoRoots.isEmpty()) {
            return;
        }
        this.myProgress.setIndeterminate(true);
        this.myProgress.pushState();
        try {
            HashMap<String, ModuleInfo> moduleInfos = new HashMap<String, ModuleInfo>();
            for (JavaModuleSourceRoot moduleInfoRoot : moduleInfoRoots) {
                File sourceRoot = moduleInfoRoot.getDirectory();
                this.myProgress.setText(JavaUiBundle.message("module.insight.scan.progress.text.scanning", sourceRoot.getPath()));
                ModuleInfo moduleInfo = this.scanModuleInfoFile(sourceRoot);
                if (moduleInfo == null) continue;
                moduleInfo.descriptor = this.createModuleDescriptor(moduleInfo.directory, Collections.singletonList(moduleInfoRoot));
                moduleInfos.put(moduleInfo.name, moduleInfo);
                this.addExportedPackages(sourceRoot, moduleInfo.exportsPackages);
            }
            this.myProgress.setText(JavaUiBundle.message("module.insight.scan.progress.text.building.modules.layout", new Object[0]));
            for (ModuleInfo moduleInfo : moduleInfos.values()) {
                for (String requiresModule : moduleInfo.requiresModules) {
                    ModuleInfo requiredModuleInfo = (ModuleInfo)moduleInfos.get(requiresModule);
                    if (requiredModuleInfo == null) continue;
                    moduleInfo.descriptor.addDependencyOn(requiredModuleInfo.descriptor);
                }
            }
            this.addModules(ContainerUtil.map(moduleInfos.values(), info -> info.descriptor));
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            this.myProgress.popState();
        }
    }

    @Override
    @NotNull
    protected @Unmodifiable List<DetectedSourceRoot> getSourceRootsToScan() {
        List<DetectedSourceRoot> allRoots = super.getSourceRootsToScan();
        List list2 = ContainerUtil.filter(allRoots, r -> !(r instanceof JavaModuleSourceRoot) || !((JavaModuleSourceRoot)r).isWithModuleInfoFile());
        if (list2 == null) {
            JavaModuleInsight.$$$reportNull$$$0(0);
        }
        return list2;
    }

    private ModuleInfo scanModuleInfoFile(@NotNull File directory) {
        if (directory == null) {
            JavaModuleInsight.$$$reportNull$$$0(1);
        }
        File file = new File(directory, "module-info.java");
        @NlsSafe String name = file.getName();
        this.myProgress.setText2(name);
        try {
            File parent;
            String text = FileUtil.loadFile((File)file);
            PsiFileFactory factory = PsiFileFactory.getInstance((Project)ProjectManager.getInstance().getDefaultProject());
            ModuleInfo moduleInfo = (ModuleInfo)ReadAction.compute(() -> {
                PsiJavaModule javaModule;
                PsiFile psiFile = factory.createFileFromText("module-info.java", (FileType)JavaFileType.INSTANCE, (CharSequence)text);
                PsiJavaModule psiJavaModule = javaModule = psiFile instanceof PsiJavaFile ? ((PsiJavaFile)psiFile).getModuleDeclaration() : null;
                if (javaModule == null) {
                    throw new IncorrectOperationException("Incorrect module declaration '" + file.getPath() + "'");
                }
                ModuleInfo info = new ModuleInfo(javaModule.getName());
                javaModule.accept((PsiElementVisitor)new ModuleInfoVisitor(info));
                return info;
            });
            File moduleDirectory = directory;
            while (!this.isEntryPointRoot(moduleDirectory) && !moduleInfo.name.equals(moduleDirectory.getName()) && (parent = moduleDirectory.getParentFile()) != null) {
                moduleDirectory = parent;
            }
            moduleInfo.directory = moduleDirectory;
            return moduleInfo;
        }
        catch (IncorrectOperationException | IOException e) {
            LOG.info(e);
            return null;
        }
    }

    @Override
    protected boolean isSourceFile(File file) {
        return StringUtil.endsWithIgnoreCase((String)file.getName(), (String)".java");
    }

    @Override
    protected boolean isLibraryFile(String fileName) {
        return StringUtil.endsWithIgnoreCase((String)fileName, (String)".jar") || StringUtil.endsWithIgnoreCase((String)fileName, (String)".zip");
    }

    @Override
    protected void scanSourceFileForImportedPackages(CharSequence chars, Consumer<? super String> result) {
        this.myLexer.start(chars);
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(this.myLexer);
        if (this.myLexer.getTokenType() == JavaTokenType.PACKAGE_KEYWORD) {
            JavaModuleInsight.advanceLexer(this.myLexer);
            if (JavaModuleInsight.readPackageName(chars, this.myLexer) == null) {
                return;
            }
        }
        while (true) {
            String packageName;
            if (this.myLexer.getTokenType() == JavaTokenType.SEMICOLON) {
                JavaModuleInsight.advanceLexer(this.myLexer);
            }
            if (this.myLexer.getTokenType() != JavaTokenType.IMPORT_KEYWORD) {
                return;
            }
            JavaModuleInsight.advanceLexer(this.myLexer);
            boolean isStaticImport = false;
            if (this.myLexer.getTokenType() == JavaTokenType.STATIC_KEYWORD) {
                isStaticImport = true;
                JavaModuleInsight.advanceLexer(this.myLexer);
            }
            if ((packageName = JavaModuleInsight.readPackageName(chars, this.myLexer)) == null) {
                return;
            }
            if (packageName.endsWith(".*")) {
                result.consume((Object)packageName.substring(0, packageName.length() - ".*".length()));
                continue;
            }
            int lastDot = packageName.lastIndexOf(46);
            if (lastDot <= 0) continue;
            String _packageName = packageName.substring(0, lastDot);
            if (isStaticImport) {
                lastDot = _packageName.lastIndexOf(46);
                if (lastDot <= 0) continue;
                result.consume((Object)_packageName.substring(0, lastDot));
                continue;
            }
            result.consume((Object)_packageName);
        }
    }

    @Nullable
    private static String readPackageName(CharSequence text, Lexer lexer) {
        StringBuilder buffer = new StringBuilder();
        while (lexer.getTokenType() == JavaTokenType.IDENTIFIER || lexer.getTokenType() == JavaTokenType.ASTERISK) {
            buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
            JavaModuleInsight.advanceLexer(lexer);
            if (lexer.getTokenType() != JavaTokenType.DOT) break;
            buffer.append('.');
            JavaModuleInsight.advanceLexer(lexer);
        }
        String packageName = buffer.toString();
        if (packageName.isEmpty() || StringUtil.endsWithChar((CharSequence)packageName, (char)'.') || StringUtil.startsWithChar((CharSequence)packageName, (char)'*')) {
            return null;
        }
        return packageName;
    }

    private static void advanceLexer(Lexer lexer) {
        lexer.advance();
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
    }

    @Override
    protected void scanLibraryForDeclaredPackages(File file, Consumer<? super String> result) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                int index;
                String entryName = entries.nextElement().getName();
                if (!StringUtil.endsWithIgnoreCase((String)entryName, (String)".class") || (index = entryName.lastIndexOf(47)) <= 0) continue;
                String packageName = entryName.substring(0, index).replace('/', '.');
                result.consume((Object)packageName);
            }
        }
    }

    @Override
    protected ModuleDescriptor createModuleDescriptor(File moduleContentRoot, Collection<DetectedSourceRoot> sourceRoots) {
        return new ModuleDescriptor(moduleContentRoot, JavaModuleType.getModuleType(), sourceRoots);
    }

    @Override
    public boolean isApplicableRoot(DetectedProjectRoot root) {
        return root instanceof JavaModuleSourceRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/importProject/JavaModuleInsight";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootsToScan";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/importProject/JavaModuleInsight";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scanModuleInfoFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static final class ModuleInfo {
        final String name;
        final Set<String> requiresModules;
        final Set<String> exportsPackages;
        File directory;
        ModuleDescriptor descriptor;

        private ModuleInfo(@NotNull String name) {
            if (name == null) {
                ModuleInfo.$$$reportNull$$$0(0);
            }
            this.requiresModules = new HashSet<String>();
            this.exportsPackages = new HashSet<String>();
            this.name = name;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ide/util/importProject/JavaModuleInsight$ModuleInfo", "<init>"));
        }
    }

    private static class ModuleInfoVisitor
    extends JavaRecursiveElementVisitor {
        private final ModuleInfo myInfo;

        ModuleInfoVisitor(ModuleInfo info) {
            this.myInfo = info;
        }

        public void visitRequiresStatement(@NotNull PsiRequiresStatement statement) {
            if (statement == null) {
                ModuleInfoVisitor.$$$reportNull$$$0(0);
            }
            super.visitRequiresStatement(statement);
            String referenceText = statement.getModuleName();
            if (referenceText != null) {
                this.myInfo.requiresModules.add(referenceText);
            }
        }

        public void visitPackageAccessibilityStatement(@NotNull PsiPackageAccessibilityStatement statement) {
            String qualifiedName;
            PsiJavaCodeReferenceElement reference;
            if (statement == null) {
                ModuleInfoVisitor.$$$reportNull$$$0(1);
            }
            super.visitPackageAccessibilityStatement(statement);
            if (statement.getRole() == PsiPackageAccessibilityStatement.Role.EXPORTS && (reference = statement.getPackageReference()) != null && (qualifiedName = reference.getQualifiedName()) != null) {
                this.myInfo.exportsPackages.add(qualifiedName);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "statement";
            objectArray2[1] = "com/intellij/ide/util/importProject/JavaModuleInsight$ModuleInfoVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRequiresStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPackageAccessibilityStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

