/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.importProject.Dependency;
import com.intellij.ide.util.importProject.FileDescriptor;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ProjectLayoutPanel;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

class LibrariesLayoutPanel
extends ProjectLayoutPanel<LibraryDescriptor> {
    LibrariesLayoutPanel(ModuleInsight insight) {
        super(insight);
    }

    @Override
    protected String getElementName(LibraryDescriptor entry) {
        return entry.getName();
    }

    @Override
    protected void setElementName(LibraryDescriptor entry, String name) {
        entry.setName(name);
    }

    @Override
    protected @Unmodifiable List<LibraryDescriptor> getEntries() {
        List<LibraryDescriptor> libs = this.getInsight().getSuggestedLibraries();
        return libs != null ? libs : Collections.emptyList();
    }

    @Override
    protected @Unmodifiable Collection<? extends Dependency> getDependencies(LibraryDescriptor entry) {
        return ContainerUtil.map(entry.getJars(), FileDescriptor::new);
    }

    @Override
    protected LibraryDescriptor merge(List<? extends LibraryDescriptor> entries) {
        ModuleInsight insight = this.getInsight();
        LibraryDescriptor mainLib = null;
        for (LibraryDescriptor libraryDescriptor : entries) {
            if (mainLib == null) {
                mainLib = libraryDescriptor;
                continue;
            }
            Collection<File> files = libraryDescriptor.getJars();
            insight.moveJarsToLibrary(libraryDescriptor, files, mainLib);
        }
        return mainLib;
    }

    @Override
    protected LibraryDescriptor split(LibraryDescriptor entry, String newEntryName, Collection<? extends File> extractedData) {
        return this.getInsight().splitLibrary(entry, newEntryName, extractedData);
    }

    @Override
    protected Collection<File> getContent(LibraryDescriptor entry) {
        return entry.getJars();
    }

    @Override
    protected String getEntriesChooserTitle() {
        return JavaUiBundle.message("title.libraries", new Object[0]);
    }

    @Override
    @NlsContexts.BorderTitle
    protected String getDependenciesTitle() {
        return JavaUiBundle.message("title.library.contents", new Object[0]);
    }

    @Override
    @NotNull
    protected Set<String> getExistingNames() {
        Set<String> set = this.getInsight().getExistingProjectLibraryNames();
        if (set == null) {
            LibrariesLayoutPanel.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    protected String getElementTypeNamePlural() {
        return JavaUiBundle.message("title.libraries", new Object[0]);
    }

    @Override
    protected ProjectLayoutPanel.ElementType getElementType() {
        return ProjectLayoutPanel.ElementType.LIBRARY;
    }

    @Override
    protected String getSplitDialogChooseFilesPrompt() {
        return JavaUiBundle.message("label.select.jars.to.extract.to.new.library", new Object[0]);
    }

    @Override
    protected String getNameAlreadyUsedMessage(String name) {
        return JavaUiBundle.message("error.library.with.name.already.exists", name);
    }

    @Override
    protected String getStepDescriptionText() {
        return JavaUiBundle.message("libraries.layout.step.description", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/LibrariesLayoutPanel", "getExistingNames"));
    }
}

