/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ObjectUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectWizardUtil {
    private ProjectWizardUtil() {
    }

    public static String findNonExistingFileName(String searchDirectory, String preferredName, String extension) {
        int idx = 0;
        String fileName;
        while (Files.exists(Paths.get(searchDirectory, fileName = (String)(idx > 0 ? preferredName + idx : preferredName) + extension), new LinkOption[0])) {
            ++idx;
        }
        return fileName;
    }

    public static boolean createDirectoryIfNotExists(String promptPrefix, String directoryPath, boolean promptUser) {
        Path dir = Paths.get(directoryPath, new String[0]);
        if (!Files.exists(dir, new LinkOption[0])) {
            if (promptUser) {
                String ide = ApplicationNamesInfo.getInstance().getFullProductName();
                String message = JavaUiBundle.message("prompt.project.wizard.directory.does.not.exist", promptPrefix, dir, ide);
                int answer = Messages.showOkCancelDialog((String)message, (String)JavaUiBundle.message("title.directory.does.not.exist", new Object[0]), (String)IdeBundle.message((String)"button.create", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (answer != 0) {
                    return false;
                }
            }
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                Logger.getInstance(ProjectWizardUtil.class).warn((Throwable)e);
                Messages.showErrorDialog((String)IdeBundle.message((String)"error.failed.to.create.directory", (Object[])new Object[]{dir}), (String)CommonBundle.getErrorTitle());
                return false;
            }
        }
        if (!ProjectWizardUtil.isWritable(dir)) {
            Messages.showErrorDialog((String)JavaUiBundle.message("error.directory.read.only", dir), (String)CommonBundle.getErrorTitle());
            return false;
        }
        return true;
    }

    private static boolean isWritable(Path dir) {
        if (SystemInfo.isWindows) {
            try {
                Files.deleteIfExists(Files.createTempFile(dir, "probe_", ".txt", new FileAttribute[0]));
                return true;
            }
            catch (IOException e) {
                Logger.getInstance(ProjectWizardUtil.class).debug((Throwable)e);
                return false;
            }
        }
        return Files.isWritable(dir);
    }

    public static void preselectJdkForNewModule(@Nullable Project project2, @Nullable String lastUsedSdk, @NotNull JdkComboBox jdkComboBox, @NotNull Condition<? super SdkTypeId> sdkTypeFilter) {
        if (jdkComboBox == null) {
            ProjectWizardUtil.$$$reportNull$$$0(0);
        }
        if (sdkTypeFilter == null) {
            ProjectWizardUtil.$$$reportNull$$$0(1);
        }
        ProjectWizardUtil.preselectJdkForNewModule(project2, lastUsedSdk, jdkComboBox, null, sdkTypeFilter);
    }

    private static Condition<? super SdkTypeId> getSdkTypeFilter(@Nullable ModuleBuilder moduleBuilder, @NotNull Condition<? super SdkTypeId> defaultSdkTypeFilter) {
        if (defaultSdkTypeFilter == null) {
            ProjectWizardUtil.$$$reportNull$$$0(2);
        }
        return (Condition)ObjectUtils.chooseNotNull((Object)((Condition)ObjectUtils.doIfNotNull((Object)moduleBuilder, it -> arg_0 -> ((ModuleBuilder)it).isSuitableSdkType(arg_0))), defaultSdkTypeFilter);
    }

    public static void preselectJdkForNewModule(@Nullable Project project2, @Nullable String lastUsedSdk, @NotNull JdkComboBox jdkComboBox, @Nullable ModuleBuilder moduleBuilder, @NotNull Condition<? super SdkTypeId> sdkFilter) {
        Sdk sdk;
        Sdk sdk2;
        if (jdkComboBox == null) {
            ProjectWizardUtil.$$$reportNull$$$0(3);
        }
        if (sdkFilter == null) {
            ProjectWizardUtil.$$$reportNull$$$0(4);
        }
        Condition<? super SdkTypeId> sdkTypeFilter = ProjectWizardUtil.getSdkTypeFilter(moduleBuilder, sdkFilter);
        jdkComboBox.reloadModel();
        if (project2 != null && (sdk2 = ProjectRootManager.getInstance((Project)project2).getProjectSdk()) != null && sdkTypeFilter.value((Object)sdk2.getSdkType())) {
            jdkComboBox.setSelectedItem(jdkComboBox.showProjectSdkItem());
            return;
        }
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        Sdk selected = ProjectRootManager.getInstance((Project)defaultProject).getProjectSdk();
        if (selected != null && sdkFilter.value((Object)selected.getSdkType())) {
            jdkComboBox.setSelectedJdk(selected);
            return;
        }
        if (lastUsedSdk != null && (sdk = ProjectJdkTable.getInstance().findJdk(lastUsedSdk)) != null && sdkTypeFilter.value((Object)sdk.getSdkType())) {
            jdkComboBox.setSelectedJdk(sdk);
            return;
        }
        Sdk best = null;
        ComboBoxModel model = jdkComboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            JdkComboBox.ActualJdkComboBoxItem item;
            Sdk jdk;
            SdkTypeId jdkType;
            Object e = model.getElementAt(i);
            if (!(e instanceof JdkComboBox.ActualJdkComboBoxItem) || !sdkFilter.value((Object)(jdkType = (jdk = (item = (JdkComboBox.ActualJdkComboBoxItem)e).getJdk()).getSdkType()))) continue;
            if (best == null) {
                best = jdk;
                continue;
            }
            SdkTypeId bestType = best.getSdkType();
            if (bestType != jdkType || bestType.versionComparator().compare(best, jdk) >= 0) continue;
            best = jdk;
        }
        if (best != null) {
            jdkComboBox.setSelectedJdk(best);
        } else {
            jdkComboBox.setSelectedItem(jdkComboBox.showNoneSdkItem());
        }
    }

    @NotNull
    public static String getPreselectedJdkPropertyName(@Nullable ModuleType<?> moduleType) {
        String string = "jdk.selected." + (moduleType == null ? "" : moduleType.getId());
        if (string == null) {
            ProjectWizardUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkComboBox";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeFilter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSdkTypeFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkFilter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/ProjectWizardUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/ProjectWizardUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreselectedJdkPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "preselectJdkForNewModule";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSdkTypeFilter";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

