/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkSettingsStep
extends ModuleWizardStep {
    protected final JdkComboBox myJdkComboBox;
    protected final WizardContext myWizardContext;
    protected final ProjectSdksModel myModel;
    private final ModuleBuilder myModuleBuilder;
    private final JPanel myJdkPanel;

    public SdkSettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<? super SdkTypeId> sdkTypeIdFilter) {
        if (settingsStep == null) {
            SdkSettingsStep.$$$reportNull$$$0(0);
        }
        if (moduleBuilder == null) {
            SdkSettingsStep.$$$reportNull$$$0(1);
        }
        if (sdkTypeIdFilter == null) {
            SdkSettingsStep.$$$reportNull$$$0(2);
        }
        this(settingsStep, moduleBuilder, sdkTypeIdFilter, null);
    }

    public SdkSettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<? super SdkTypeId> sdkTypeIdFilter, @Nullable Condition<? super Sdk> sdkFilter) {
        if (settingsStep == null) {
            SdkSettingsStep.$$$reportNull$$$0(3);
        }
        if (moduleBuilder == null) {
            SdkSettingsStep.$$$reportNull$$$0(4);
        }
        if (sdkTypeIdFilter == null) {
            SdkSettingsStep.$$$reportNull$$$0(5);
        }
        this(settingsStep.getContext(), moduleBuilder, sdkTypeIdFilter, sdkFilter);
        if (!this.isEmpty()) {
            settingsStep.addSettingsField(this.getSdkFieldLabel(settingsStep.getContext().getProject()), (JComponent)this.myJdkPanel);
        }
    }

    public SdkSettingsStep(@NotNull WizardContext context, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<? super SdkTypeId> sdkTypeIdFilter, @Nullable Condition<? super Sdk> sdkFilter) {
        if (context == null) {
            SdkSettingsStep.$$$reportNull$$$0(6);
        }
        if (moduleBuilder == null) {
            SdkSettingsStep.$$$reportNull$$$0(7);
        }
        if (sdkTypeIdFilter == null) {
            SdkSettingsStep.$$$reportNull$$$0(8);
        }
        this.myModuleBuilder = moduleBuilder;
        this.myWizardContext = context;
        this.myModel = new ProjectSdksModel();
        Project project2 = this.myWizardContext.getProject();
        this.myModel.reset(project2);
        Disposable disposable = context.getDisposable();
        if (disposable != null) {
            Disposable stepDisposable = () -> this.myModel.disposeUIResources();
            Disposer.register((Disposable)disposable, (Disposable)stepDisposable);
        }
        if (sdkFilter == null) {
            sdkFilter = JdkComboBox.getSdkFilter(sdkTypeIdFilter);
        }
        this.myJdkComboBox = new JdkComboBox(this.myWizardContext.getProject(), this.myModel, sdkTypeIdFilter, sdkFilter, sdkTypeIdFilter, null);
        this.myJdkPanel = new JPanel(new GridBagLayout());
        this.myJdkPanel.setFocusable(false);
        this.myJdkComboBox.getAccessibleContext().setAccessibleName(this.myJdkPanel.getAccessibleContext().getAccessibleName());
        final PropertiesComponent component = project2 == null ? PropertiesComponent.getInstance() : PropertiesComponent.getInstance((Project)project2);
        ModuleType moduleType = moduleBuilder.getModuleType();
        final String selectedJdkProperty = ProjectWizardUtil.getPreselectedJdkPropertyName(moduleType);
        this.myJdkComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Sdk jdk = SdkSettingsStep.this.myJdkComboBox.getSelectedJdk();
                if (jdk != null) {
                    component.setValue(selectedJdkProperty, jdk.getName());
                }
                SdkSettingsStep.this.onSdkSelected(jdk);
            }
        });
        this.preselectSdk(project2, component.getValue(selectedJdkProperty), sdkTypeIdFilter);
        this.myJdkPanel.add((Component)((Object)this.myJdkComboBox), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
    }

    private void preselectSdk(Project project2, String lastUsedSdk, Condition<? super SdkTypeId> sdkFilter) {
        ProjectWizardUtil.preselectJdkForNewModule(project2, lastUsedSdk, this.myJdkComboBox, this.myModuleBuilder, sdkFilter);
    }

    protected void onSdkSelected(Sdk sdk) {
    }

    public boolean isEmpty() {
        return this.myJdkPanel.getComponentCount() == 0;
    }

    @NlsContexts.Label
    @NotNull
    protected String getSdkFieldLabel(@Nullable Project project2) {
        String string = JavaUiBundle.message("sdk.setting.step.label", project2 == null ? 0 : 1);
        if (string == null) {
            SdkSettingsStep.$$$reportNull$$$0(9);
        }
        return string;
    }

    public JComponent getComponent() {
        return this.myJdkPanel;
    }

    public void updateDataModel() {
        Project project2 = this.myWizardContext.getProject();
        Sdk jdk = this.myJdkComboBox.getSelectedJdk();
        if (project2 == null) {
            this.myWizardContext.setProjectJdk(jdk);
        } else {
            this.myModuleBuilder.setModuleJdk(jdk);
        }
    }

    public boolean validate() throws ConfigurationException {
        block3: {
            if (this.myJdkComboBox.getSelectedJdk() == null && !this.myJdkComboBox.isProjectJdkSelected() && Messages.showDialog((String)this.getNoSdkMessage(), (String)JavaUiBundle.message("title.no.jdk.specified", new Object[0]), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) != 0) {
                return false;
            }
            try {
                this.myModel.apply(null, true);
            }
            catch (ConfigurationException e) {
                if (Messages.showDialog((String)JavaUiBundle.message("dialog.message.0.do.you.want.to.proceed", e.getMessage()), (String)e.getTitle(), (String[])new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()}, (int)1, (Icon)Messages.getWarningIcon()) == 0) break block3;
                return false;
            }
        }
        return true;
    }

    @NlsContexts.DialogMessage
    protected String getNoSdkMessage() {
        return JavaUiBundle.message("prompt.confirm.project.no.jdk", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleBuilder";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkTypeIdFilter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/SdkSettingsStep";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/SdkSettingsStep";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkFieldLabel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

