/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.importProject.RootDetectionProcessor;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetector;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.lang.java.JavaParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaSourceRootDetectionUtil {
    private static final TokenSet JAVA_FILE_FIRST_TOKEN_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{ElementType.MODIFIER_BIT_SET, ElementType.CLASS_KEYWORD_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.AT, JavaTokenType.IMPORT_KEYWORD})});

    private JavaSourceRootDetectionUtil() {
    }

    @NotNull
    public static Collection<JavaModuleSourceRoot> suggestRoots(@NotNull File dir) {
        if (dir == null) {
            JavaSourceRootDetectionUtil.$$$reportNull$$$0(0);
        }
        List detectors = ContainerUtil.findAll((Object[])((ProjectStructureDetector[])ProjectStructureDetector.EP_NAME.getExtensions()), JavaSourceRootDetector.class);
        RootDetectionProcessor processor = new RootDetectionProcessor(dir, detectors.toArray(new JavaSourceRootDetector[0]));
        Map<ProjectStructureDetector, List<DetectedProjectRoot>> rootsMap = processor.runDetectors();
        HashMap<File, JavaModuleSourceRoot> result = new HashMap<File, JavaModuleSourceRoot>();
        for (List<DetectedProjectRoot> roots : rootsMap.values()) {
            for (DetectedProjectRoot root : roots) {
                if (!(root instanceof JavaModuleSourceRoot)) continue;
                JavaModuleSourceRoot sourceRoot = (JavaModuleSourceRoot)root;
                File directory = sourceRoot.getDirectory();
                JavaModuleSourceRoot oldRoot = (JavaModuleSourceRoot)result.remove(directory);
                if (oldRoot != null) {
                    result.put(directory, oldRoot.combineWith(sourceRoot));
                    continue;
                }
                result.put(directory, sourceRoot);
            }
        }
        Collection<JavaModuleSourceRoot> collection = result.values();
        if (collection == null) {
            JavaSourceRootDetectionUtil.$$$reportNull$$$0(1);
        }
        return collection;
    }

    @Nullable
    public static String getPackageName(CharSequence text) {
        Lexer lexer = JavaParserDefinition.createLexer((LanguageLevel)LanguageLevel.JDK_1_5);
        lexer.start(text);
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        JavaSourceRootDetectionUtil.skipAnnotations(lexer);
        IElementType firstToken = lexer.getTokenType();
        if (firstToken != JavaTokenType.PACKAGE_KEYWORD) {
            if (JAVA_FILE_FIRST_TOKEN_SET.contains(firstToken)) {
                return "";
            }
            return null;
        }
        lexer.advance();
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        StringBuilder buffer = new StringBuilder();
        while (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            buffer.append(text, lexer.getTokenStart(), lexer.getTokenEnd());
            lexer.advance();
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
            if (lexer.getTokenType() != JavaTokenType.DOT) break;
            buffer.append('.');
            lexer.advance();
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        }
        String packageName = buffer.toString();
        if (packageName.isEmpty() || StringUtil.endsWithChar((CharSequence)packageName, (char)'.')) {
            return null;
        }
        return packageName;
    }

    public static void skipWhiteSpaceAndComments(Lexer lexer) {
        while (ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(lexer.getTokenType())) {
            lexer.advance();
        }
    }

    private static void skipAnnotations(Lexer lexer) {
        while (lexer.getTokenType() == JavaTokenType.AT) {
            lexer.advance();
            JavaSourceRootDetectionUtil.skipQualifiedIdentifier(lexer);
            JavaSourceRootDetectionUtil.skipArguments(lexer);
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        }
    }

    private static void skipQualifiedIdentifier(Lexer lexer) {
        if (lexer.getTokenType() == JavaTokenType.IDENTIFIER) {
            lexer.advance();
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
            while (lexer.getTokenType() == JavaTokenType.DOT) {
                lexer.advance();
                JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
                if (lexer.getTokenType() != JavaTokenType.IDENTIFIER) break;
                lexer.advance();
                JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
            }
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        }
    }

    private static void skipArguments(Lexer lexer) {
        JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        if (lexer.getTokenType() == JavaTokenType.LPARENTH) {
            lexer.advance();
            int depth = 1;
            while (depth > 0) {
                IElementType tokenType = lexer.getTokenType();
                if (tokenType == JavaTokenType.LPARENTH) {
                    ++depth;
                } else if (tokenType == JavaTokenType.RPARENTH) {
                    --depth;
                } else if (tokenType == null) break;
                lexer.advance();
            }
            JavaSourceRootDetectionUtil.skipWhiteSpaceAndComments(lexer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetectionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/projectWizard/importSources/JavaSourceRootDetectionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestRoots";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

