/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarFinder;

import com.intellij.codeInsight.AttachSourcesProvider;
import com.intellij.ide.JavaUiBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAttachSourceProvider
implements AttachSourcesProvider {
    private static final Logger LOG = Logger.getInstance(AbstractAttachSourceProvider.class);

    @Nullable
    protected static VirtualFile getJarByPsiFile(@NotNull PsiFile psiFile) {
        VirtualFileSystem fs;
        VirtualFile entry;
        if (psiFile == null) {
            AbstractAttachSourceProvider.$$$reportNull$$$0(0);
        }
        if ((entry = psiFile.getVirtualFile()) != null && (fs = entry.getFileSystem()) instanceof JarFileSystem) {
            return ((JarFileSystem)fs).getLocalByEntry(entry);
        }
        return null;
    }

    @Nullable
    protected static Library getLibraryFromOrderEntriesList(@NotNull List<? extends LibraryOrderEntry> orderEntries) {
        if (orderEntries == null) {
            AbstractAttachSourceProvider.$$$reportNull$$$0(1);
        }
        if (orderEntries.isEmpty()) {
            return null;
        }
        Library library = orderEntries.get(0).getLibrary();
        if (library == null) {
            return null;
        }
        for (int i = 1; i < orderEntries.size(); ++i) {
            if (library.equals((Object)orderEntries.get(i).getLibrary())) continue;
            return null;
        }
        return library;
    }

    protected void addSourceFile(@Nullable VirtualFile jarRoot, @NotNull Library library) {
        if (library == null) {
            AbstractAttachSourceProvider.$$$reportNull$$$0(2);
        }
        if (jarRoot != null && !Arrays.asList(library.getFiles(OrderRootType.SOURCES)).contains(jarRoot)) {
            Library.ModifiableModel model = library.getModifiableModel();
            model.addRoot(jarRoot, OrderRootType.SOURCES);
            model.commit();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntries";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jarFinder/AbstractAttachSourceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getJarByPsiFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryFromOrderEntriesList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSourceFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static abstract class DownloadSourcesAction
    implements AttachSourcesProvider.AttachSourcesAction {
        protected final Project myProject;
        protected final String myUrl;
        protected final String myMessageGroupId;

        public DownloadSourcesAction(Project project2, String messageGroupId, String url) {
            this.myProject = project2;
            this.myUrl = url;
            this.myMessageGroupId = messageGroupId;
        }

        public String getName() {
            return JavaUiBundle.message("attach.source.provider.download.sources.action.name", new Object[0]);
        }

        public String getBusyText() {
            return JavaUiBundle.message("attach.source.provider.download.sources.action.busy.text", new Object[0]);
        }

        protected abstract void storeFile(byte[] var1);

        @NotNull
        public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
            if (orderEntriesContainingFile == null) {
                DownloadSourcesAction.$$$reportNull$$$0(0);
            }
            final ActionCallback callback = new ActionCallback();
            Task.Backgroundable task2 = new Task.Backgroundable(this.myProject, JavaUiBundle.message("progress.title.downloading.sources", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    byte[] bytes;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        LOG.info("Downloading sources JAR: " + myUrl);
                        indicator.checkCanceled();
                        bytes = HttpRequests.request((String)myUrl).readBytes(indicator);
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            String message = JavaUiBundle.message("error.message.failed.to.download.sources.0", myUrl);
                            new Notification(myMessageGroupId, JavaUiBundle.message("notification.title.downloading.failed", new Object[0]), message, NotificationType.ERROR).notify(this.getProject());
                            callback.setDone();
                        });
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            WriteAction.run(() -> this.storeFile(bytes));
                        }
                        finally {
                            callback.setDone();
                        }
                    });
                }

                public void onCancel() {
                    callback.setRejected();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarFinder/AbstractAttachSourceProvider$DownloadSourcesAction$1", "run"));
                }
            };
            task2.queue();
            ActionCallback actionCallback = callback;
            if (actionCallback == null) {
                DownloadSourcesAction.$$$reportNull$$$0(1);
            }
            return actionCallback;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntriesContainingFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jarFinder/AbstractAttachSourceProvider$DownloadSourcesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jarFinder/AbstractAttachSourceProvider$DownloadSourcesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    protected class AttachExistingSourceAction
    implements AttachSourcesProvider.AttachSourcesAction {
        @Nls(capitalization=Nls.Capitalization.Title)
        private final String myName;
        private final VirtualFile mySrcFile;
        private final Library myLibrary;

        public AttachExistingSourceAction(VirtualFile srcFile, @Nls(capitalization=Nls.Capitalization.Title) Library library, String actionName) {
            this.mySrcFile = srcFile;
            this.myLibrary = library;
            this.myName = actionName;
        }

        public String getName() {
            return this.myName;
        }

        public String getBusyText() {
            return this.getName();
        }

        @NotNull
        public ActionCallback perform(@NotNull List<? extends LibraryOrderEntry> orderEntriesContainingFile) {
            if (orderEntriesContainingFile == null) {
                AttachExistingSourceAction.$$$reportNull$$$0(0);
            }
            ThreadingAssertions.assertEventDispatchThread();
            ActionCallback callback = new ActionCallback();
            callback.setDone();
            if (!this.mySrcFile.isValid()) {
                ActionCallback actionCallback = callback;
                if (actionCallback == null) {
                    AttachExistingSourceAction.$$$reportNull$$$0(1);
                }
                return actionCallback;
            }
            if (this.myLibrary != AbstractAttachSourceProvider.getLibraryFromOrderEntriesList(orderEntriesContainingFile)) {
                ActionCallback actionCallback = callback;
                if (actionCallback == null) {
                    AttachExistingSourceAction.$$$reportNull$$$0(2);
                }
                return actionCallback;
            }
            WriteAction.run(() -> AbstractAttachSourceProvider.this.addSourceFile(this.mySrcFile, this.myLibrary));
            ActionCallback actionCallback = callback;
            if (actionCallback == null) {
                AttachExistingSourceAction.$$$reportNull$$$0(3);
            }
            return actionCallback;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderEntriesContainingFile";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jarFinder/AbstractAttachSourceProvider$AttachExistingSourceAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jarFinder/AbstractAttachSourceProvider$AttachExistingSourceAction";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

