/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.LibraryIdSynchronizationQueue;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.workspace.jps.entities.LibraryDependency;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.platform.workspace.jps.entities.ModuleDependencyItem;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jarRepository/ChangedRepositoryLibraryIdSynchronizer;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "queue", "Lcom/intellij/jarRepository/LibraryIdSynchronizationQueue;", "<init>", "(Lcom/intellij/jarRepository/LibraryIdSynchronizationQueue;)V", "beforeCalled", "", "beforeChanged", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "changed", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nrepositoryLibraryIdSynchronizers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 repositoryLibraryIdSynchronizers.kt\ncom/intellij/jarRepository/ChangedRepositoryLibraryIdSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n822#2,2:133\n1915#2,2:135\n1915#2,2:137\n822#2,2:139\n1915#2,2:141\n1915#2,2:143\n*S KotlinDebug\n*F\n+ 1 repositoryLibraryIdSynchronizers.kt\ncom/intellij/jarRepository/ChangedRepositoryLibraryIdSynchronizer\n*L\n84#1:133,2\n85#1:135,2\n91#1:137,2\n118#1:139,2\n119#1:141,2\n127#1:143,2\n*E\n"})
public final class ChangedRepositoryLibraryIdSynchronizer
implements WorkspaceModelChangeListener {
    @NotNull
    private final LibraryIdSynchronizationQueue queue;
    private boolean beforeCalled;

    public ChangedRepositoryLibraryIdSynchronizer(@NotNull LibraryIdSynchronizationQueue queue) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        this.queue = queue;
    }

    /*
     * WARNING - void declaration
     */
    public void beforeChanged(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.beforeCalled = true;
        List libraryIdsToRevoke = new ArrayList();
        for (EntityChange change : event.getChanges(LibraryEntity.class)) {
            EntityChange.Removed removed;
            if ((change instanceof EntityChange.Removed ? (EntityChange.Removed)change : null) == null) continue;
            removed = removed;
            libraryIdsToRevoke.add(((LibraryEntity)removed.getOldEntity()).getSymbolicId());
        }
        for (EntityChange change : event.getChanges(ModuleEntity.class)) {
            void $this$filterIsInstanceTo$iv;
            Pair pair;
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Added) continue;
            if (entityChange instanceof EntityChange.Removed) {
                pair = TuplesKt.to((Object)((ModuleEntity)((EntityChange.Removed)change).getOldEntity()).getDependencies(), (Object)CollectionsKt.emptyList());
            } else if (entityChange instanceof EntityChange.Replaced) {
                pair = TuplesKt.to((Object)((ModuleEntity)((EntityChange.Replaced)change).getOldEntity()).getDependencies(), (Object)((ModuleEntity)((EntityChange.Replaced)change).getNewEntity()).getDependencies());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair2 = pair;
            List oldLModuleDeps = (List)pair2.component1();
            List newModuleDeps = (List)pair2.component2();
            Iterable iterable = newModuleDeps;
            Collection destination$iv = new HashSet();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv : $this$filterIsInstanceTo$iv) {
                if (!(element$iv instanceof LibraryDependency)) continue;
                destination$iv.add(element$iv);
            }
            HashSet newLibDeps = (HashSet)destination$iv;
            Iterable $this$forEach$iv = oldLModuleDeps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleDependencyItem oldDependency = (ModuleDependencyItem)element$iv;
                boolean bl = false;
                if (!(oldDependency instanceof LibraryDependency) || newLibDeps.contains(oldDependency)) continue;
                libraryIdsToRevoke.add(((LibraryDependency)oldDependency).getLibrary());
            }
        }
        Iterable $this$forEach$iv = libraryIdsToRevoke;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryId it = (LibraryId)element$iv;
            boolean bl = false;
            this.queue.revokeSynchronization(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void changed(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.beforeCalled) {
            return;
        }
        this.beforeCalled = false;
        boolean libraryReloadRequested = false;
        List libraryIdsToSync = new ArrayList();
        for (EntityChange change : event.getChanges(LibraryEntity.class)) {
            LibraryEntity libraryEntity;
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Added) {
                libraryEntity = (LibraryEntity)((EntityChange.Added)change).getNewEntity();
            } else if (entityChange instanceof EntityChange.Replaced) {
                libraryEntity = (LibraryEntity)((EntityChange.Replaced)change).getNewEntity();
            } else if (entityChange instanceof EntityChange.Removed) {
                libraryEntity = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (libraryEntity == null) continue;
            LibraryEntity entity = libraryEntity;
            libraryIdsToSync.add(entity.getSymbolicId());
            libraryReloadRequested = true;
        }
        for (EntityChange change : event.getChanges(ModuleEntity.class)) {
            void $this$filterIsInstanceTo$iv;
            Pair pair;
            EntityChange entityChange = change;
            if (entityChange instanceof EntityChange.Removed) continue;
            if (entityChange instanceof EntityChange.Added) {
                pair = TuplesKt.to((Object)CollectionsKt.emptyList(), (Object)((ModuleEntity)((EntityChange.Added)change).getNewEntity()).getDependencies());
            } else if (entityChange instanceof EntityChange.Replaced) {
                pair = TuplesKt.to((Object)((ModuleEntity)((EntityChange.Replaced)change).getOldEntity()).getDependencies(), (Object)((ModuleEntity)((EntityChange.Replaced)change).getNewEntity()).getDependencies());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Pair pair2 = pair;
            List oldLModuleDeps = (List)pair2.component1();
            List newModuleDeps = (List)pair2.component2();
            Iterable iterable = oldLModuleDeps;
            Collection destination$iv = new HashSet();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv : $this$filterIsInstanceTo$iv) {
                if (!(element$iv instanceof LibraryDependency)) continue;
                destination$iv.add(element$iv);
            }
            HashSet oldLibDeps = (HashSet)destination$iv;
            Iterable $this$forEach$iv = newModuleDeps;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleDependencyItem newDependency = (ModuleDependencyItem)element$iv;
                boolean bl = false;
                if (!(newDependency instanceof LibraryDependency) || oldLibDeps.contains(newDependency)) continue;
                libraryIdsToSync.add(((LibraryDependency)newDependency).getLibrary());
                libraryReloadRequested = true;
            }
        }
        Iterable $this$forEach$iv = libraryIdsToSync;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryId it = (LibraryId)element$iv;
            boolean bl = false;
            this.queue.requestSynchronization(it);
        }
        if (libraryReloadRequested) {
            this.queue.flush();
        }
    }
}

