/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.DisableCompilationDependenciesResolutionTask;
import com.intellij.jarRepository.LibraryIdSynchronizationQueue;
import com.intellij.jarRepository.LibraryIdSynchronizationQueueKt;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.platform.backend.workspace.WorkspaceModelKt;
import com.intellij.platform.workspace.jps.entities.LibraryPropertiesEntity;
import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/jarRepository/CompilationDependenciesResolutionTask;", "Lcom/intellij/openapi/compiler/CompileTask;", "<init>", "()V", "execute", "", "context", "Lcom/intellij/openapi/compiler/CompileContext;", "ResolutionTask", "Companion", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nCompilationDependenciesResolutionTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilationDependenciesResolutionTask.kt\ncom/intellij/jarRepository/CompilationDependenciesResolutionTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n1807#2,3:120\n1276#3,2:123\n23#4:125\n23#4:126\n*S KotlinDebug\n*F\n+ 1 CompilationDependenciesResolutionTask.kt\ncom/intellij/jarRepository/CompilationDependenciesResolutionTask\n*L\n38#1:120,3\n45#1:123,2\n86#1:125\n100#1:126\n*E\n"})
public final class CompilationDependenciesResolutionTask
implements CompileTask {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger log;

    /*
     * WARNING - void declaration
     */
    public boolean execute(@NotNull CompileContext context) {
        void var9_15;
        boolean hasRepositoryLibraries;
        block11: {
            boolean bl;
            boolean bl2;
            block10: {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Iterable $this$any$iv = DisableCompilationDependenciesResolutionTask.Companion.getEP_NAME().getExtensionList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DisableCompilationDependenciesResolutionTask it = (DisableCompilationDependenciesResolutionTask)element$iv;
                        boolean bl3 = false;
                        Project project2 = context.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        if (!it.shouldDisable(project2)) continue;
                        bl2 = true;
                        break block10;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                log.info("Compilation dependencies resolution task is disabled for the project " + context.getProject().getName());
                return true;
            }
            Project project3 = context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
            ImmutableEntityStorage workspaceModelSnapshot = WorkspaceModelKt.getWorkspaceModel((Project)project3).getCurrentSnapshot();
            Sequence $this$any$iv = workspaceModelSnapshot.entities(LibraryPropertiesEntity.class);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                LibraryPropertiesEntity it = (LibraryPropertiesEntity)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getLibrary().getTypeId(), (Object)RepositoryLibraryType.LIBRARY_TYPE_ID)) continue;
                bl = true;
                break block11;
            }
            bl = hasRepositoryLibraries = false;
        }
        if (!hasRepositoryLibraries) {
            log.debug("Skip compilation dependencies resolution task for the project " + context.getProject().getName() + " because there are no 'repository' libraries");
            return true;
        }
        Project project4 = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
        LibraryIdSynchronizationQueue queue = LibraryIdSynchronizationQueue.Companion.getInstance(project4);
        Map missingLibrariesResolutionTasks = new LinkedHashMap();
        Application application = ApplicationManager.getApplication();
        Module[] affectedModules = (Module[])application.runReadAction(() -> CompilationDependenciesResolutionTask.execute$lambda$2(context));
        Intrinsics.checkNotNull((Object)affectedModules);
        Module[] moduleArray = affectedModules;
        boolean entry = false;
        int n = moduleArray.length;
        while (var9_15 < n) {
            Module module = moduleArray[var9_15];
            OrderEnumerator.orderEntries((Module)module).recursively().exportedOnly().compileOnly().withoutSdk().forEachLibrary(arg_0 -> CompilationDependenciesResolutionTask.execute$lambda$4(arg_0 -> CompilationDependenciesResolutionTask.execute$lambda$3(missingLibrariesResolutionTasks, queue, module, context, arg_0), arg_0));
            ++var9_15;
        }
        for (Map.Entry entry2 : missingLibrariesResolutionTasks.entrySet()) {
            LibraryEx library = (LibraryEx)entry2.getKey();
            ResolutionTask task2 = (ResolutionTask)entry2.getValue();
            try {
                Object[] objectArray = new Object[]{library.getPresentableName()};
                context.addMessage(CompilerMessageCategory.INFORMATION, JavaUiBundle.message("precompile.library.resolution.start", objectArray), null, -1, -1, null, (Collection)CollectionsKt.listOf((Object)task2.getModule().getName()));
                task2.join();
            }
            catch (Exception e) {
                CompilationDependenciesResolutionTask $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(CompilationDependenciesResolutionTask.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
                Object[] objectArray = new Object[]{library.getPresentableName(), e.getMessage()};
                context.addMessage(CompilerMessageCategory.ERROR, JavaUiBundle.message("precompile.library.resolution.failure", objectArray), null, -1, -1, null, (Collection)CollectionsKt.listOf((Object)task2.getModule().getName()));
                return false;
            }
        }
        return true;
    }

    private static final Module[] execute$lambda$2(CompileContext $context) {
        return $context.getCompileScope().getAffectedModules();
    }

    private static final boolean execute$lambda$3(Map $missingLibrariesResolutionTasks, LibraryIdSynchronizationQueue $queue, Module $module, CompileContext $context, Library library) {
        if (library instanceof LibraryEx && !$missingLibrariesResolutionTasks.containsKey(library) && LibraryIdSynchronizationQueueKt.needToReload((LibraryEx)library)) {
            $queue.revokeSynchronization(((LibraryBridge)library).getLibraryId());
            Map map = $missingLibrariesResolutionTasks;
            Library library2 = library;
            LibraryEx libraryEx = (LibraryEx)library;
            Project project2 = $context.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            ResolutionTask resolutionTask = new ResolutionTask(libraryEx, $module, project2);
            map.put(library2, resolutionTask);
        }
        return true;
    }

    private static final boolean execute$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jarRepository/CompilationDependenciesResolutionTask$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.java.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/jarRepository/CompilationDependenciesResolutionTask$ResolutionTask;", "", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/project/Project;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "promise", "Lorg/jetbrains/concurrency/Promise;", "getPromise", "()Lorg/jetbrains/concurrency/Promise;", "join", "", "intellij.java.ui"})
    private static final class ResolutionTask {
        @NotNull
        private final Module module;
        @NotNull
        private final Promise<?> promise;

        public ResolutionTask(@NotNull LibraryEx library, @NotNull Module module, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)library, (String)"library");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.module = module;
            Promise<?> promise2 = RepositoryUtils.reloadDependencies(project2, library);
            Intrinsics.checkNotNullExpressionValue(promise2, (String)"reloadDependencies(...)");
            this.promise = promise2;
        }

        @NotNull
        public final Module getModule() {
            return this.module;
        }

        @NotNull
        public final Promise<?> getPromise() {
            return this.promise;
        }

        public final void join() {
            ProjectTaskManagerImpl.waitForPromise(this.promise);
        }
    }
}

