/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.codeInsight.ExternalAnnotationsArtifactsResolver;
import com.intellij.codeInsight.externalAnnotation.location.AnnotationsLocation;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntityBuilder;
import com.intellij.platform.workspace.jps.entities.LibraryEntityModifications;
import com.intellij.platform.workspace.jps.entities.LibraryRoot;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.platform.workspace.storage.MutableEntityStorage;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.platform.workspace.storage.url.VirtualFileUrlManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J \u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tH\u0003J$\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jarRepository/ExternalAnnotationsRepositoryResolver;", "Lcom/intellij/codeInsight/ExternalAnnotationsArtifactsResolver;", "<init>", "()V", "resolve", "", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "mavenId", "", "location", "Lcom/intellij/codeInsight/externalAnnotation/location/AnnotationsLocation;", "diff", "Lcom/intellij/platform/workspace/storage/MutableEntityStorage;", "resolveNewOrderRoots", "", "Lcom/intellij/openapi/roots/libraries/ui/OrderRoot;", "resolveAsync", "Lorg/jetbrains/concurrency/Promise;", "updateLibrary", "", "roots", "extractDescriptor", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "patched", "patchArtifactId", "Companion", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nExternalAnnotationsRepositoryResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalAnnotationsRepositoryResolver.kt\ncom/intellij/jarRepository/ExternalAnnotationsRepositoryResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1586#2:222\n1661#2,3:223\n777#2:226\n873#2,2:227\n1915#2,2:229\n1596#2:231\n1629#2,4:232\n1586#2:236\n1661#2,3:237\n777#2:242\n873#2,2:243\n1586#2:246\n1661#2,3:247\n14060#3,2:240\n1#4:245\n*S KotlinDebug\n*F\n+ 1 ExternalAnnotationsRepositoryResolver.kt\ncom/intellij/jarRepository/ExternalAnnotationsRepositoryResolver\n*L\n96#1:222\n96#1:223,3\n101#1:226\n101#1:227,2\n102#1:229,2\n124#1:231\n124#1:232,4\n180#1:236\n180#1:237,3\n189#1:242\n189#1:243,2\n114#1:246\n114#1:247,3\n181#1:240,2\n*E\n"})
public final class ExternalAnnotationsRepositoryResolver
implements ExternalAnnotationsArtifactsResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public boolean resolve(@NotNull Project project2, @NotNull Library library, @Nullable String mavenId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.extractDescriptor(mavenId, library, false);
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return false;
        }
        JpsMavenRepositoryLibraryDescriptor mavenLibDescriptor = jpsMavenRepositoryLibraryDescriptor;
        Ref.ObjectRef roots = new Ref.ObjectRef();
        roots.element = TypeIntrinsics.asMutableList(JarRepositoryManager.loadDependenciesSync(project2, mavenLibDescriptor, SetsKt.setOf((Object)ArtifactKind.ANNOTATIONS), null, null));
        Collection collection = (Collection)roots.element;
        if (collection == null || collection.isEmpty()) {
            JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor2 = this.extractDescriptor(mavenId, library, true);
            if (jpsMavenRepositoryLibraryDescriptor2 == null) {
                return false;
            }
            mavenLibDescriptor = jpsMavenRepositoryLibraryDescriptor2;
            roots.element = TypeIntrinsics.asMutableList(JarRepositoryManager.loadDependenciesSync(project2, mavenLibDescriptor, SetsKt.setOf((Object)ArtifactKind.ANNOTATIONS), null, null));
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ExternalAnnotationsRepositoryResolver.resolve$lambda$0(this, roots, library));
        collection = (Collection)roots.element;
        return !(collection == null || collection.isEmpty());
    }

    public boolean resolve(@NotNull Project project2, @NotNull Library library, @NotNull AnnotationsLocation location) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        List<OrderRoot> roots = this.resolveNewOrderRoots(location, project2);
        Collection collection = roots;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> ExternalAnnotationsRepositoryResolver.resolve$lambda$1(this, roots, library));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean resolve(@NotNull Project project2, @NotNull Library library, @NotNull AnnotationsLocation location, @NotNull MutableEntityStorage diff) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        if (!(library instanceof LibraryBridge) || ((LibraryBridge)library).isDisposed()) {
            return true;
        }
        List<OrderRoot> newRoots = this.resolveNewOrderRoots(location, project2);
        Collection collection = newRoots;
        if (collection == null || collection.isEmpty()) {
            return false;
        }
        LOG.debug("Found " + newRoots.size() + " external annotations for " + ((LibraryBridge)library).getName());
        LibraryEntity libraryEntity = ProjectLibraryTableBridgeImpl.Companion.findLibraryEntity((EntityStorage)diff, (LibraryBridge)library);
        if (libraryEntity == null) {
            return true;
        }
        LibraryEntity libraryEntity2 = libraryEntity;
        VirtualFileUrlManager vfUrlManager = WorkspaceModel.Companion.getInstance(project2).getVirtualFileUrlManager();
        Iterable $this$map$iv = newRoots;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Iterator it;
            OrderRoot orderRoot = (OrderRoot)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = it.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            collection2.add(VirtualFileUrls.toVirtualFileUrl((VirtualFile)virtualFile, (VirtualFileUrlManager)vfUrlManager));
        }
        HashSet newUrls = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        List toRemove = new ArrayList();
        LibraryRootTypeId annotationsRootType = new LibraryRootTypeId("ANNOTATIONS");
        $this$mapTo$iv$iv = libraryEntity2.getRoots();
        boolean $i$f$filter = false;
        void $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LibraryRoot it = (LibraryRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)annotationsRootType)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryRoot it = (LibraryRoot)element$iv;
            boolean bl = false;
            boolean bl2 = !newUrls.contains(it.getUrl()) ? toRemove.add(it) : newUrls.remove(it.getUrl());
        }
        if (!toRemove.isEmpty() || !newUrls.isEmpty()) {
            LibraryEntityModifications.modifyLibraryEntity((MutableEntityStorage)diff, (LibraryEntity)libraryEntity2, arg_0 -> ExternalAnnotationsRepositoryResolver.resolve$lambda$5(toRemove, newUrls, annotationsRootType, arg_0));
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<OrderRoot> resolveNewOrderRoots(AnnotationsLocation location, Project project2) {
        List list2;
        JpsMavenRepositoryLibraryDescriptor descriptor = new JpsMavenRepositoryLibraryDescriptor(location.getGroupId(), location.getArtifactId(), location.getVersion(), false);
        Collection collection = location.getRepositoryUrls();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRepositoryUrls(...)");
        if (!collection.isEmpty()) {
            void $this$mapIndexedTo$iv$iv;
            Collection collection2 = location.getRepositoryUrls();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getRepositoryUrls(...)");
            Iterable $this$mapIndexed$iv = collection2;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void url;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv;
                int n2 = n;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                String someUniqueId = "id_" + url.hashCode() + "_" + (int)index;
                collection3.add(new RemoteRepositoryDescription(someUniqueId, "name", (String)url));
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        List repos = list2;
        List<OrderRoot> newRoots = JarRepositoryManager.loadDependenciesSync(project2, descriptor, SetsKt.setOf((Object)ArtifactKind.ANNOTATIONS), repos, null);
        Collection collection4 = newRoots;
        if (collection4 == null || collection4.isEmpty()) {
            LOG.info("No annotations found for [" + descriptor + "]");
        }
        return newRoots;
    }

    @NotNull
    public Promise<Library> resolveAsync(@NotNull Project project2, @NotNull Library library, @Nullable String mavenId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.extractDescriptor(mavenId, library, false);
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return Promises.resolvedPromise((Object)library);
        }
        JpsMavenRepositoryLibraryDescriptor mavenLibDescriptor = jpsMavenRepositoryLibraryDescriptor;
        Promise promise2 = JarRepositoryManager.loadDependenciesAsync(project2, mavenLibDescriptor, SetsKt.setOf((Object)ArtifactKind.ANNOTATIONS), null, null).thenAsync(arg_0 -> ExternalAnnotationsRepositoryResolver.resolveAsync$lambda$1(arg_0 -> ExternalAnnotationsRepositoryResolver.resolveAsync$lambda$0(this, mavenId, library, project2, arg_0), arg_0)).thenAsync(arg_0 -> ExternalAnnotationsRepositoryResolver.resolveAsync$lambda$3(arg_0 -> ExternalAnnotationsRepositoryResolver.resolveAsync$lambda$2(this, library, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"thenAsync(...)");
        return promise2;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    private final void updateLibrary(List<OrderRoot> roots, Library library) {
        if (!(library instanceof LibraryEx) || ((LibraryEx)library).isDisposed()) {
            return;
        }
        Collection collection = roots;
        if (!(collection == null || collection.isEmpty())) {
            OrderRoot it;
            boolean bl;
            Object object;
            void $this$mapTo$iv$iv22;
            LOG.debug("Found " + roots.size() + " external annotations for " + ((LibraryEx)library).getName());
            ExistingLibraryEditor editor = new ExistingLibraryEditor(library, null);
            OrderRootType type = AnnotationOrderRootType.getInstance();
            Iterable iterable = roots;
            boolean $i$f$map = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv22) {
                OrderRoot orderRoot = (OrderRoot)item$iv$iv;
                object = destination$iv$iv;
                bl = false;
                object.add(it.getFile().getUrl());
            }
            HashSet newUrls = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            String[] stringArray = editor.getUrls(type);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(...)");
            Object[] objectArray = stringArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : objectArray) {
                String it2 = (String)element$iv;
                boolean bl2 = false;
                if (!newUrls.contains(it2)) {
                    editor.removeRoot(it2, type);
                    continue;
                }
                newUrls.remove(it2);
            }
            if (!newUrls.isEmpty()) {
                void $this$filterTo$iv$iv;
                Iterable iterable3 = roots;
                object = editor;
                boolean $i$f$filter = false;
                Iterable $this$mapTo$iv$iv22 = iterable3;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (OrderRoot)element$iv$iv;
                    bl = false;
                    if (!newUrls.contains(it.getFile().getUrl())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                ((LibraryEditorBase)object).addRoots((List)destination$iv$iv);
                WriteAction.run(() -> ExternalAnnotationsRepositoryResolver.updateLibrary$lambda$3(editor));
            } else {
                Disposer.dispose((Disposable)editor);
            }
        }
    }

    private final JpsMavenRepositoryLibraryDescriptor extractDescriptor(String mavenId, Library library, boolean patched) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor;
        if (mavenId != null) {
            jpsMavenRepositoryLibraryDescriptor = new JpsMavenRepositoryLibraryDescriptor(patched ? this.patchArtifactId(mavenId) : mavenId, false, CollectionsKt.emptyList());
        } else if (library instanceof LibraryEx) {
            RepositoryLibraryProperties repositoryLibraryProperties;
            LibraryProperties libraryProperties = ((LibraryEx)library).getProperties();
            RepositoryLibraryProperties repositoryLibraryProperties2 = repositoryLibraryProperties = libraryProperties instanceof RepositoryLibraryProperties ? (RepositoryLibraryProperties)libraryProperties : null;
            if (repositoryLibraryProperties != null) {
                RepositoryLibraryProperties $this$extractDescriptor_u24lambda_u240 = repositoryLibraryProperties;
                boolean bl = false;
                jpsMavenRepositoryLibraryDescriptor = new JpsMavenRepositoryLibraryDescriptor($this$extractDescriptor_u24lambda_u240.getGroupId(), (String)(patched ? $this$extractDescriptor_u24lambda_u240.getArtifactId() + "-annotations" : $this$extractDescriptor_u24lambda_u240.getArtifactId()), $this$extractDescriptor_u24lambda_u240.getVersion());
            } else {
                jpsMavenRepositoryLibraryDescriptor = null;
            }
        } else {
            jpsMavenRepositoryLibraryDescriptor = null;
        }
        return jpsMavenRepositoryLibraryDescriptor;
    }

    private final String patchArtifactId(String mavenId) {
        char[] cArray = new char[]{':'};
        List components = StringsKt.split$default((CharSequence)mavenId, (char[])cArray, (boolean)false, (int)3, (int)2, null);
        if (components.size() < 3) {
            return mavenId;
        }
        return components.get(0) + ":" + components.get(1) + "-annotations:" + components.get(2);
    }

    private static final void resolve$lambda$0(ExternalAnnotationsRepositoryResolver this$0, Ref.ObjectRef $roots, Library $library) {
        this$0.updateLibrary((List)$roots.element, $library);
    }

    private static final void resolve$lambda$1(ExternalAnnotationsRepositoryResolver this$0, List $roots, Library $library) {
        this$0.updateLibrary($roots, $library);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit resolve$lambda$5(List $toRemove, HashSet $newUrls, LibraryRootTypeId $annotationsRootType, LibraryEntityBuilder $this$modifyLibraryEntity) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$modifyLibraryEntity, (String)"$this$modifyLibraryEntity");
        $this$modifyLibraryEntity.getRoots().removeAll($toRemove);
        Iterable iterable = $newUrls;
        List list2 = $this$modifyLibraryEntity.getRoots();
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFileUrl virtualFileUrl = (VirtualFileUrl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LibraryRoot((VirtualFileUrl)it, $annotationsRootType, null, 4, null));
        }
        list2.addAll((List)destination$iv$iv);
        return Unit.INSTANCE;
    }

    private static final void resolveAsync$lambda$2$0(ExternalAnnotationsRepositoryResolver this$0, List $roots, Library $library, AsyncPromise $promise) {
        this$0.updateLibrary($roots, $library);
        $promise.setResult((Object)$library);
    }

    private static final Promise resolveAsync$lambda$0(ExternalAnnotationsRepositoryResolver this$0, String $mavenId, Library $library, Project $project, List roots) {
        Promise<List<OrderRoot>> promise2;
        Promise<List<OrderRoot>> resolvedRoots = Promises.resolvedPromise((Object)roots);
        List list2 = roots;
        boolean bl = list2 != null ? !list2.isEmpty() : false;
        if (bl) {
            promise2 = resolvedRoots;
        } else {
            JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this$0.extractDescriptor($mavenId, $library, true);
            if (jpsMavenRepositoryLibraryDescriptor == null) {
                return resolvedRoots;
            }
            JpsMavenRepositoryLibraryDescriptor patchedDescriptor = jpsMavenRepositoryLibraryDescriptor;
            promise2 = JarRepositoryManager.loadDependenciesAsync($project, patchedDescriptor, SetsKt.setOf((Object)ArtifactKind.ANNOTATIONS), null, null);
        }
        return promise2;
    }

    private static final Promise resolveAsync$lambda$1(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final Promise resolveAsync$lambda$2(ExternalAnnotationsRepositoryResolver this$0, Library $library, List roots) {
        AsyncPromise promise2 = new AsyncPromise();
        ApplicationManager.getApplication().invokeLater(() -> ExternalAnnotationsRepositoryResolver.resolveAsync$lambda$2$0(this$0, roots, $library, promise2));
        return (Promise)promise2;
    }

    private static final Promise resolveAsync$lambda$3(Function1 $tmp0, Object p0) {
        return (Promise)$tmp0.invoke(p0);
    }

    private static final void updateLibrary$lambda$3(ExistingLibraryEditor $editor) {
        $editor.commit();
    }

    static {
        Logger logger = Logger.getInstance(ExternalAnnotationsRepositoryResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jarRepository/ExternalAnnotationsRepositoryResolver$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.java.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

