/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.jarRepository.LibraryIdSynchronizationQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/jarRepository/GlobalChangedRepositoryLibraryIdSynchronizer;", "Lcom/intellij/openapi/roots/libraries/LibraryTable$Listener;", "Lcom/intellij/openapi/roots/RootProvider$RootSetChangedListener;", "queue", "Lcom/intellij/jarRepository/LibraryIdSynchronizationQueue;", "disposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/jarRepository/LibraryIdSynchronizationQueue;Lcom/intellij/openapi/Disposable;)V", "beforeLibraryRemoved", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "afterLibraryAdded", "rootSetChanged", "wrapper", "Lcom/intellij/openapi/roots/RootProvider;", "intellij.java.ui"})
public final class GlobalChangedRepositoryLibraryIdSynchronizer
implements LibraryTable.Listener,
RootProvider.RootSetChangedListener {
    @NotNull
    private final LibraryIdSynchronizationQueue queue;
    @NotNull
    private final Disposable disposable;

    public GlobalChangedRepositoryLibraryIdSynchronizer(@NotNull LibraryIdSynchronizationQueue queue, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.queue = queue;
        this.disposable = disposable;
    }

    public void beforeLibraryRemoved(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library instanceof LibraryBridge) {
            ((LibraryBridge)library).getRootProvider().removeRootSetChangedListener((RootProvider.RootSetChangedListener)this);
            this.queue.revokeSynchronization(((LibraryBridge)library).getLibraryId());
        }
    }

    public void afterLibraryAdded(@NotNull Library library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        if (library instanceof LibraryBridge) {
            ((LibraryBridge)library).getRootProvider().addRootSetChangedListener((RootProvider.RootSetChangedListener)this, this.disposable);
            this.queue.requestSynchronization(((LibraryBridge)library).getLibraryId());
        }
    }

    public void rootSetChanged(@NotNull RootProvider wrapper) {
        Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
        Library[] libraryArray = LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries();
        Intrinsics.checkNotNullExpressionValue((Object)libraryArray, (String)"getLibraries(...)");
        for (Library library : libraryArray) {
            if (!Intrinsics.areEqual((Object)library.getRootProvider(), (Object)wrapper)) continue;
            if (!(library instanceof LibraryBridge)) break;
            this.queue.requestSynchronization(((LibraryBridge)library).getLibraryId());
            break;
        }
    }
}

