/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.IdeaModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibrarySupport;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryAddLibraryAction
extends IntentionAndQuickFixAction {
    private final Module module;
    @NotNull
    private final RepositoryLibraryDescription libraryDescription;

    public RepositoryAddLibraryAction(Module module, @NotNull RepositoryLibraryDescription libraryDescription) {
        if (libraryDescription == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(0);
        }
        this.module = module;
        this.libraryDescription = libraryDescription;
    }

    @NotNull
    public String getName() {
        String string = JavaUiBundle.message("intention.text.add.0.library.to.module.dependencies", this.libraryDescription.getDisplayName());
        if (string == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaUiBundle.message("intention.family.maven.libraries", new Object[0]);
        if (string == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project2, PsiFile psiFile, @Nullable Editor editor) {
        if (project2 == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(3);
        }
        RepositoryAddLibraryAction.addLibraryToModule(this.libraryDescription, this.module);
    }

    public static Promise<Void> addLibraryToModule(@NotNull RepositoryLibraryDescription libraryDescription, @NotNull Module module, @NotNull String defaultVersion, @Nullable DependencyScope scope, boolean downloadSources, boolean downloadJavaDocs) {
        RepositoryLibraryPropertiesDialog dialog;
        if (libraryDescription == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(4);
        }
        if (module == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(5);
        }
        if (defaultVersion == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(6);
        }
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel(defaultVersion, downloadSources, downloadJavaDocs);
        if (!ApplicationManager.getApplication().isUnitTestMode() && !(dialog = new RepositoryLibraryPropertiesDialog(module.getProject(), model, libraryDescription, false, true, false)).showAndGet()) {
            return Promises.rejectedPromise();
        }
        IdeaModifiableModelsProvider modifiableModelsProvider = new IdeaModifiableModelsProvider();
        ModifiableRootModel modifiableModel = modifiableModelsProvider.getModuleModifiableModel(module);
        RepositoryLibrarySupport librarySupport = new RepositoryLibrarySupport(module.getProject(), libraryDescription, model);
        assert (modifiableModel != null);
        librarySupport.addSupport(module, modifiableModel, modifiableModelsProvider, scope);
        ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
        return Promises.resolvedPromise(null);
    }

    public static Promise<Void> addLibraryToModule(@NotNull RepositoryLibraryDescription libraryDescription, @NotNull Module module) {
        if (libraryDescription == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(7);
        }
        if (module == null) {
            RepositoryAddLibraryAction.$$$reportNull$$$0(8);
        }
        return RepositoryAddLibraryAction.addLibraryToModule(libraryDescription, module, "RELEASE", null, false, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/RepositoryAddLibraryAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/RepositoryAddLibraryAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryToModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

