/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryLibraryRootsComponentDescriptor;
import com.intellij.jarRepository.RepositoryLibraryWithDescriptionEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.jps.entities.LibraryTypeId;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public class RepositoryLibraryType
extends LibraryType<RepositoryLibraryProperties> {
    public static final LibraryTypeId LIBRARY_TYPE_ID = new LibraryTypeId("repository");
    public static final PersistentLibraryKind<RepositoryLibraryProperties> REPOSITORY_LIBRARY_KIND = new PersistentLibraryKind<RepositoryLibraryProperties>(LIBRARY_TYPE_ID.getName()){

        @NotNull
        public RepositoryLibraryProperties createDefaultProperties() {
            return new RepositoryLibraryProperties();
        }
    };

    protected RepositoryLibraryType() {
        super(REPOSITORY_LIBRARY_KIND);
    }

    public static RepositoryLibraryType getInstance() {
        return (RepositoryLibraryType)((Object)EP_NAME.findExtension(RepositoryLibraryType.class));
    }

    @NlsContexts.Label
    @Nullable
    public String getCreateActionName() {
        return JavaUiBundle.message("repository.library.type.action.name.label", new Object[0]);
    }

    public NewLibraryConfiguration createNewLibrary(@NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, @NotNull Project project2) {
        if (parentComponent == null) {
            RepositoryLibraryType.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            RepositoryLibraryType.$$$reportNull$$$0(1);
        }
        return JarRepositoryManager.chooseLibraryAndDownload(project2, null, parentComponent);
    }

    public LibraryPropertiesEditor createPropertiesEditor(@NotNull LibraryEditorComponent<RepositoryLibraryProperties> component) {
        if (component == null) {
            RepositoryLibraryType.$$$reportNull$$$0(2);
        }
        return new RepositoryLibraryWithDescriptionEditor(component);
    }

    @Nullable
    public Icon getIcon(@Nullable RepositoryLibraryProperties properties) {
        if (properties == null || properties.getGroupId() == null || properties.getArtifactId() == null) {
            return RepositoryLibraryDescription.DEFAULT_ICON;
        }
        return RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)properties).getIcon();
    }

    @NotNull
    public String getDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            RepositoryLibraryType.$$$reportNull$$$0(3);
        }
        RepositoryLibraryDescription description = RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)properties);
        String name = description.getDisplayName(properties.getVersion());
        String string = JavaUiBundle.message("repository.library.type.maven.description", name);
        if (string == null) {
            RepositoryLibraryType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public LibraryRootsComponentDescriptor createLibraryRootsComponentDescriptor() {
        return new RepositoryLibraryRootsComponentDescriptor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/RepositoryLibraryType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/RepositoryLibraryType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNewLibrary";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createPropertiesEditor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDescription";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

