/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.RepositoryLibraryUtils;
import com.intellij.jarRepository.settings.RepositoryLibraryPropertiesDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryPropertiesEditorBase;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.idea.maven.utils.library.propertiesEditor.RepositoryLibraryPropertiesModel;

public class RepositoryLibraryWithDescriptionEditor
extends LibraryPropertiesEditorBase<RepositoryLibraryProperties, RepositoryLibraryType> {
    public RepositoryLibraryWithDescriptionEditor(LibraryEditorComponent<RepositoryLibraryProperties> editorComponent) {
        super(editorComponent, RepositoryLibraryType.getInstance(), null);
        this.setupReloadButton();
    }

    public void apply() {
    }

    @Override
    protected void edit() {
        RepositoryLibraryPropertiesDialog dialog;
        ExistingLibraryEditor libraryEditor;
        Library library;
        @NotNull RepositoryLibraryProperties properties = (RepositoryLibraryProperties)this.myEditorComponent.getProperties();
        boolean wasGeneratedName = RepositoryLibraryType.getInstance().getDescription(properties).equals(this.myEditorComponent.getLibraryEditor().getName());
        EnumSet artifactKinds = ArtifactKind.kindsOf((boolean)RepositoryUtils.libraryHasSources(this.myEditorComponent.getLibraryEditor()), (boolean)RepositoryUtils.libraryHasJavaDocs(this.myEditorComponent.getLibraryEditor()), (String[])new String[]{properties.getPackaging()});
        if (RepositoryUtils.libraryHasExternalAnnotations(this.myEditorComponent.getLibraryEditor())) {
            artifactKinds.add(ArtifactKind.ANNOTATIONS);
        }
        Project project2 = this.myEditorComponent.getProject();
        assert (project2 != null) : "EditorComponent's project must not be null in order to be used with RepositoryLibraryWithDescriptionEditor";
        RepositoryLibraryPropertiesModel model = new RepositoryLibraryPropertiesModel(properties.getVersion(), artifactKinds, properties.isIncludeTransitiveDependencies(), properties.getExcludedDependencies(), RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories(), properties.getJarRepositoryId());
        boolean isGlobalLibrary = false;
        LibraryEditor editor = this.myEditorComponent.getLibraryEditor();
        if (editor instanceof ExistingLibraryEditor && (library = (libraryEditor = (ExistingLibraryEditor)editor).getLibrary()) instanceof LibraryEx) {
            LibraryEx libraryEx = (LibraryEx)library;
            LibraryTable table = libraryEx.getTable();
            boolean bl = isGlobalLibrary = table != null && "application".equals(table.getTableLevel());
        }
        if (!(dialog = new RepositoryLibraryPropertiesDialog(project2, model, RepositoryLibraryDescription.findDescription((RepositoryLibraryProperties)properties), true, true, isGlobalLibrary)).showAndGet()) {
            return;
        }
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).changeVersion(model.getVersion());
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setIncludeTransitiveDependencies(model.isIncludeTransitiveDependencies());
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setExcludedDependencies(model.getExcludedDependencies());
        ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setJarRepositoryId(model.getRemoteRepositoryId());
        if (wasGeneratedName) {
            this.myEditorComponent.renameLibrary(RepositoryLibraryType.getInstance().getDescription(properties));
        }
        LibraryEditor libraryEditor2 = this.myEditorComponent.getLibraryEditor();
        String copyTo = RepositoryUtils.getStorageRoot(project2, this.myEditorComponent.getLibraryEditor().getUrls(OrderRootType.CLASSES));
        Collection<OrderRoot> roots = JarRepositoryManager.loadDependenciesModal(project2, properties.getRepositoryLibraryDescriptor(), model.getArtifactKinds(), null, copyTo);
        if (roots == null || RepositoryLibraryUtils.isVerifiableRootsChanged(libraryEditor2, roots)) {
            ((RepositoryLibraryProperties)this.myEditorComponent.getProperties()).setArtifactsVerification(Collections.emptyList());
        }
        libraryEditor2.removeAllRoots();
        if (roots != null) {
            libraryEditor2.addRoots(roots);
        }
        this.myEditorComponent.updateRootsTree();
        this.updateDescription();
    }

    private void setupReloadButton() {
        Project project2 = this.myEditorComponent.getProject();
        VirtualFile directory = this.myEditorComponent.getExistingRootDirectory();
        if (this.myEditorComponent.isNewLibrary() || project2 == null || directory == null) {
            return;
        }
        LibraryEditor editor = this.myEditorComponent.getLibraryEditor();
        if (!(editor instanceof ExistingLibraryEditor)) {
            return;
        }
        Library library = ((ExistingLibraryEditor)editor).getLibrary();
        if (!(library instanceof LibraryEx)) {
            return;
        }
        String toolTipText = JavaUiBundle.message("button.reload.description", directory.getPath());
        this.myReloadButton.setVisible(true);
        this.myReloadButton.setToolTipText(toolTipText);
        this.myReloadButton.addActionListener(e -> this.reloadLibraryDirectory(project2, (LibraryEx)library));
    }

    private void reloadLibraryDirectory(Project project2, LibraryEx library) {
        try {
            RepositoryUtils.deleteAndReloadDependencies(project2, library).onError(e -> this.showBalloon(JavaUiBundle.message("popup.reload.failed.result", library.getName()), MessageType.ERROR)).onSuccess(roots -> this.showBalloon(JavaUiBundle.message("popup.reload.success.result", library.getName()), MessageType.INFO));
        }
        catch (IOException | UnsupportedOperationException e2) {
            String error = e2.getLocalizedMessage();
            this.showBalloon(error, MessageType.ERROR);
        }
    }

    private void showBalloon(@NlsSafe String text, MessageType type) {
        JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(text, type, null).setHideOnClickOutside(true).createBalloon().show(RelativePoint.getSouthWestOf((JComponent)this.myReloadButton.getRootPane()), Balloon.Position.atRight);
    }
}

