/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository.settings;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;

class DependencyExclusionEditor {
    private static final SimpleTextAttributes STRIKEOUT_ATTRIBUTES = new SimpleTextAttributes(4, null);
    private static final SimpleTextAttributes STRIKEOUT_GRAYED_ATTRIBUTES = new SimpleTextAttributes(4, NamedColorUtil.getInactiveTextColor());
    private final CheckboxTree myDependenciesTree;
    private final CheckedTreeNode myRootNode;
    private final JPanel myMainPanel;

    DependencyExclusionEditor(ArtifactDependencyNode root, JPanel parentComponent) {
        this.myMainPanel = parentComponent;
        this.myRootNode = DependencyExclusionEditor.createDependencyTreeNode(root);
        CheckboxTreeBase.CheckPolicy policy = new CheckboxTreeBase.CheckPolicy(false, true, true, false);
        this.myDependenciesTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){
            {
                this.myIgnoreInheritance = true;
            }

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value instanceof CheckedTreeNode)) {
                    return;
                }
                Object userObject = ((CheckedTreeNode)value).getUserObject();
                if (!(userObject instanceof ArtifactDependencyNode)) {
                    return;
                }
                ArtifactDependencyNode node = (ArtifactDependencyNode)userObject;
                Artifact artifact = node.getArtifact();
                boolean rejected = node.isRejected();
                @NlsSafe String groupArtifactFragment = artifact.getGroupId() + ":" + artifact.getArtifactId();
                this.getTextRenderer().append(groupArtifactFragment, !rejected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : STRIKEOUT_ATTRIBUTES, true);
                @NlsSafe String versionFragment = ":" + artifact.getVersion();
                this.getTextRenderer().append(versionFragment, !rejected ? SimpleTextAttributes.GRAYED_ATTRIBUTES : STRIKEOUT_GRAYED_ATTRIBUTES, true);
                this.setToolTipText(rejected ? JavaUiBundle.message("tooltip.text.dependency.was.rejected", new Object[0]) : null);
            }
        }, this.myRootNode, policy){

            protected void installSpeedSearch() {
                TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)false, treePath -> {
                    Object node = treePath.getLastPathComponent();
                    if (!(node instanceof CheckedTreeNode)) {
                        return "";
                    }
                    Object data = ((CheckedTreeNode)node).getUserObject();
                    if (!(data instanceof ArtifactDependencyNode)) {
                        return "";
                    }
                    Artifact artifact = ((ArtifactDependencyNode)data).getArtifact();
                    return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
                });
            }
        };
        this.myDependenciesTree.setRootVisible(false);
        this.myDependenciesTree.addCheckboxTreeListener(new CheckboxTreeListener(){
            private boolean myProcessingNodes;

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (this.myProcessingNodes) {
                    return;
                }
                this.myProcessingNodes = true;
                try {
                    if (!node.isChecked()) {
                        String groupAndArtifact = DependencyExclusionEditor.getGroupAndArtifactId(node);
                        TreeUtil.treeNodeTraverser((TreeNode)DependencyExclusionEditor.this.myRootNode).filter(CheckedTreeNode.class).forEach(treeNode -> {
                            if (DependencyExclusionEditor.getGroupAndArtifactId(treeNode).equals(groupAndArtifact)) {
                                DependencyExclusionEditor.this.myDependenciesTree.setNodeState(treeNode, false);
                            }
                        });
                    }
                }
                finally {
                    this.myProcessingNodes = false;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/jarRepository/settings/DependencyExclusionEditor$3", "nodeStateChanged"));
            }
        });
    }

    @Nullable
    public Set<String> selectExcludedDependencies(List<String> excludedDependencies) {
        DependencyExclusionEditor.uncheckExcludedNodes(this.myRootNode, new HashSet<String>(excludedDependencies), false);
        TreeUtil.expandAll((JTree)this.myDependenciesTree);
        DialogBuilder dialogBuilder = new DialogBuilder((Component)this.myMainPanel).title(JavaUiBundle.message("dialog.title.include.transitive.dependencies", new Object[0])).centerPanel((JComponent)new JBScrollPane((Component)this.myDependenciesTree));
        dialogBuilder.setPreferredFocusComponent((JComponent)this.myDependenciesTree);
        if (dialogBuilder.showAndGet()) {
            return DependencyExclusionEditor.collectUncheckedNodes(this.myRootNode, new LinkedHashSet<String>());
        }
        return null;
    }

    private static void uncheckExcludedNodes(CheckedTreeNode node, Set<String> excluded, boolean parentIsExcluded) {
        boolean isExcluded = parentIsExcluded || excluded.contains(DependencyExclusionEditor.getGroupAndArtifactId(node));
        node.setChecked(!isExcluded);
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            Object child = children.nextElement();
            DependencyExclusionEditor.uncheckExcludedNodes((CheckedTreeNode)child, excluded, isExcluded);
        }
    }

    private static Set<String> collectUncheckedNodes(CheckedTreeNode node, Set<String> result) {
        if (node.isChecked()) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                Object child = children.nextElement();
                DependencyExclusionEditor.collectUncheckedNodes((CheckedTreeNode)child, result);
            }
        } else {
            result.add(DependencyExclusionEditor.getGroupAndArtifactId(node));
        }
        return result;
    }

    @NotNull
    private static String getGroupAndArtifactId(CheckedTreeNode node) {
        Artifact artifact = ((ArtifactDependencyNode)node.getUserObject()).getArtifact();
        String string = artifact.getGroupId() + ":" + artifact.getArtifactId();
        if (string == null) {
            DependencyExclusionEditor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static CheckedTreeNode createDependencyTreeNode(ArtifactDependencyNode node) {
        CheckedTreeNode treeNode = new CheckedTreeNode((Object)node);
        for (ArtifactDependencyNode dependency : node.getDependencies()) {
            treeNode.add((MutableTreeNode)DependencyExclusionEditor.createDependencyTreeNode(dependency));
        }
        CheckedTreeNode checkedTreeNode = treeNode;
        if (checkedTreeNode == null) {
            DependencyExclusionEditor.$$$reportNull$$$0(1);
        }
        return checkedTreeNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/jarRepository/settings/DependencyExclusionEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupAndArtifactId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDependencyTreeNode";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

