/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.awt.RelativePoint;
import java.util.Comparator;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class ConfigurationError
implements Comparable<ConfigurationError> {
    private final String myPlainTextTitle;
    private final HtmlChunk myDescription;
    private boolean myIgnored;

    protected ConfigurationError(String plainTextTitle, @NotNull HtmlChunk description) {
        if (description == null) {
            ConfigurationError.$$$reportNull$$$0(0);
        }
        this(plainTextTitle, description, false);
    }

    protected ConfigurationError(String plainTextTitle, @NotNull HtmlChunk description, boolean ignored) {
        if (description == null) {
            ConfigurationError.$$$reportNull$$$0(1);
        }
        this.myPlainTextTitle = plainTextTitle;
        this.myDescription = description;
        this.myIgnored = ignored;
    }

    @NotNull
    public String getPlainTextTitle() {
        String string = this.myPlainTextTitle;
        if (string == null) {
            ConfigurationError.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public HtmlChunk getDescription() {
        HtmlChunk htmlChunk = this.myDescription;
        if (htmlChunk == null) {
            ConfigurationError.$$$reportNull$$$0(3);
        }
        return htmlChunk;
    }

    public void ignore(boolean b) {
        if (b != this.myIgnored) {
            this.myIgnored = b;
        }
    }

    public boolean isIgnored() {
        return this.myIgnored;
    }

    public void fix(JComponent contextComponent, RelativePoint relativePoint) {
    }

    public boolean canBeFixed() {
        return true;
    }

    public abstract void navigate();

    @Override
    public int compareTo(ConfigurationError o) {
        if (this.myIgnored != o.isIgnored()) {
            return -1;
        }
        int titleResult = this.getPlainTextTitle().compareTo(o.getPlainTextTitle());
        if (titleResult != 0) {
            return titleResult;
        }
        int descriptionResult = Comparator.comparing(e -> this.getDescription().toString()).compare(this, o);
        if (descriptionResult != 0) {
            return descriptionResult;
        }
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/ConfigurationError";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ConfigurationError";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainTextTitle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

