/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.compiler.ModuleCompilerUtil;
import com.intellij.compiler.ModuleSourceSet;
import com.intellij.compiler.server.impl.BuildProcessCustomPluginsConfiguration;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructure;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.PlaceInProjectStructureBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemType;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolder;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.UsageInProjectSettings;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.UsagesInUnloadedModules;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Chunk;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GeneralProjectSettingsElement
extends ProjectStructureElement {
    public GeneralProjectSettingsElement(@NotNull StructureConfigurableContext context) {
        if (context == null) {
            GeneralProjectSettingsElement.$$$reportNull$$$0(0);
        }
        super(context);
    }

    @Override
    @NotNull
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getPresentableText() {
        String string = IdeBundle.message((String)"title.project", (Object[])new Object[0]);
        if (string == null) {
            GeneralProjectSettingsElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public String getPresentableName() {
        return this.myContext.getModulesConfigurator().getProjectStructureConfigurable().getProjectConfig().getProjectName();
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String getTypeName() {
        return IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    }

    @Override
    public void check(ProjectStructureProblemsHolder problemsHolder) {
        Object place;
        ProjectSdksModel model;
        Sdk sdk;
        Project project2 = this.myContext.getProject();
        ProjectStructureConfigurable projectStructureConfigurable = this.myContext.getModulesConfigurator().getProjectStructureConfigurable();
        if (this.containsModuleWithInheritedSdk() && (sdk = (model = projectStructureConfigurable.getProjectJdksModel()).getProjectSdk()) == null) {
            place = new PlaceInProjectStructureBase(project2, projectStructureConfigurable.createProjectConfigurablePlace(), this);
            problemsHolder.registerProblem(JavaUiBundle.message("project.roots.project.jdk.problem.message", new Object[0]), null, ProjectStructureProblemType.error("project-sdk-not-defined"), (PlaceInProjectStructure)place, null);
        }
        List sourceSetCycles = ModuleCompilerUtil.computeSourceSetCycles((ModulesProvider)this.myContext.getModulesConfigurator());
        ArrayList<@Nls String> cycles = new ArrayList<String>();
        for (Chunk chunk : sourceSetCycles) {
            Set sourceSets = chunk.getNodes();
            ArrayList<@Nls String> names = new ArrayList<String>();
            for (ModuleSourceSet sourceSet : sourceSets) {
                String name = sourceSet.getDisplayName();
                names.add(names.isEmpty() ? name : StringUtil.decapitalize((String)name));
            }
            cycles.add(StringUtil.join(names, (String)", "));
        }
        if (!cycles.isEmpty()) {
            HtmlChunk description;
            String message;
            place = new PlaceInProjectStructureBase(project2, projectStructureConfigurable.createModulesPlace(), this);
            if (cycles.size() > 1) {
                message = JavaUiBundle.message("circular.dependencies.message", new Object[0]);
                String header = JavaUiBundle.message("module.circular.dependency.warning.description", new Object[0]);
                HtmlChunk[] liTags = (HtmlChunk[])cycles.stream().map(c -> HtmlChunk.tag((String)"li").addText(c)).toArray(HtmlChunk[]::new);
                HtmlChunk.Element ol = HtmlChunk.tag((String)"ol").style("padding-left: 30pt;").children(liTags);
                description = new HtmlBuilder().append((HtmlChunk)HtmlChunk.tag((String)"b").addText(header)).append((HtmlChunk)ol).toFragment();
            } else {
                message = JavaUiBundle.message("module.circular.dependency.warning.short", StringUtil.decapitalize((String)((String)cycles.get(0))));
                description = HtmlChunk.empty();
            }
            problemsHolder.registerProblem(new ProjectStructureProblemDescription(message, description, (PlaceInProjectStructure)place, ProjectStructureProblemType.warning("module-circular-dependency"), Collections.emptyList()));
        }
    }

    private boolean containsModuleWithInheritedSdk() {
        for (Module module : this.myContext.getModules()) {
            ModuleRootModel rootModel = this.myContext.getModulesConfigurator().getRootModel(module);
            if (!rootModel.isSdkInherited()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ProjectStructureElementUsage> getUsagesInElement() {
        ArrayList<ProjectStructureElementUsage> usages = new ArrayList<ProjectStructureElementUsage>();
        Collection unloadedModules = ModuleManager.getInstance((Project)this.myContext.getProject()).getUnloadedModuleDescriptions();
        if (!unloadedModules.isEmpty()) {
            MultiMap dependenciesInUnloadedModules = new MultiMap();
            for (UnloadedModuleDescription unloaded : unloadedModules) {
                for (String moduleName : unloaded.getDependencyModuleNames()) {
                    Module depModule = this.myContext.getModulesConfigurator().getModuleModel().findModuleByName(moduleName);
                    if (depModule == null) continue;
                    dependenciesInUnloadedModules.putValue((Object)depModule, (Object)unloaded);
                }
            }
            for (Map.Entry entry : dependenciesInUnloadedModules.entrySet()) {
                usages.add(new UsagesInUnloadedModules(this.myContext, this, new ModuleProjectStructureElement(this.myContext, (Module)entry.getKey()), (Collection)entry.getValue()));
            }
            for (Library library : this.myContext.getProjectLibrariesProvider().getModifiableModel().getLibraries()) {
                usages.add(new UsagesInUnloadedModules(this.myContext, this, new LibraryProjectStructureElement(this.myContext, library), unloadedModules));
            }
        }
        for (String libraryName : BuildProcessCustomPluginsConfiguration.getInstance((Project)this.myContext.getProject()).getProjectLibraries()) {
            Library library = this.myContext.getProjectLibrariesProvider().getModifiableModel().getLibraryByName(libraryName);
            if (library == null) continue;
            usages.add(new UsageInProjectSettings(this.myContext, new LibraryProjectStructureElement(this.myContext, library), JavaUiBundle.message("label.build.process.configuration", new Object[0])));
        }
        return usages;
    }

    @Override
    public String getId() {
        return "project:general";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GeneralProjectSettingsElement;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/GeneralProjectSettingsElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

