/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.CommonBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.ui.configuration.JavadocEditorUi;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.TableItem;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ItemRemovable;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class JavadocEditor
extends ModuleElementsEditor {
    private JTable myTable;

    public JavadocEditor(ModuleConfigurationState state) {
        super(state);
    }

    public String getHelpTopic() {
        return "projectStructure.modules.paths";
    }

    @NlsContexts.ConfigurableName
    public String getDisplayName() {
        return JavadocEditor.getName();
    }

    public void saveData() {
        TableUtil.stopEditing((JTable)this.myTable);
        int count = this.myTable.getRowCount();
        String[] urls = ArrayUtil.newStringArray((int)count);
        for (int row = 0; row < count; ++row) {
            TableItem item = ((MyTableModel)this.myTable.getModel()).getTableItemAt(row);
            urls[row] = item.getUrl();
        }
        ((JavaModuleExternalPaths)this.getModel().getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(urls);
        this.fireConfigurationChanged();
    }

    public JComponent createComponentImpl() {
        DefaultTableModel tableModel = this.createModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myTable.setIntercellSpacing(new Dimension(0, 0));
        this.myTable.setDefaultRenderer(TableItem.class, (TableCellRenderer)((Object)new MyRenderer()));
        this.myTable.setShowGrid(false);
        this.myTable.setDragEnabled(false);
        this.myTable.setShowHorizontalLines(false);
        this.myTable.setShowVerticalLines(false);
        this.myTable.getSelectionModel().setSelectionMode(2);
        JPanel tablePanel = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                FileChooserDescriptor myDescriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
                myDescriptor.setTitle(JavaUiBundle.message("module.javadoc.add.path.title", new Object[0]));
                myDescriptor.setDescription(JavaUiBundle.message("module.javadoc.add.path.prompt", new Object[0]));
                VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)myDescriptor, (Component)JavadocEditor.this.myTable, (Project)JavadocEditor.this.getProject(), null);
                MyTableModel tableModel = (MyTableModel)JavadocEditor.this.myTable.getModel();
                boolean changes = false;
                for (VirtualFile file : files) {
                    if (file == null) continue;
                    tableModel.addTableItem(new TableItem(file));
                    changes = true;
                }
                if (changes) {
                    JavadocEditor.this.saveData();
                    TableUtil.selectRows((JTable)JavadocEditor.this.myTable, (int[])new int[]{tableModel.getRowCount() - 1});
                }
            }
        }).addExtraAction((AnAction)new DumbAwareAction(JavaUiBundle.messagePointer("module.javadoc.add.url.button", new Object[0]), IconUtil.getAddLinkIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                VirtualFile[] files = new VirtualFile[]{Util.showSpecifyJavadocUrlDialog((JComponent)JavadocEditor.this.myTable)};
                MyTableModel tableModel = (MyTableModel)JavadocEditor.this.myTable.getModel();
                boolean changes = false;
                for (VirtualFile file : files) {
                    if (file == null) continue;
                    tableModel.addTableItem(new TableItem(file));
                    changes = true;
                }
                if (changes) {
                    JavadocEditor.this.saveData();
                    TableUtil.selectRows((JTable)JavadocEditor.this.myTable, (int[])new int[]{tableModel.getRowCount() - 1});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/JavadocEditor$2", "actionPerformed"));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List removedItems = TableUtil.removeSelectedItems((JTable)JavadocEditor.this.myTable);
                if (!removedItems.isEmpty()) {
                    JavadocEditor.this.saveData();
                }
            }
        }).setButtonComparator(new String[]{CommonBundle.message((String)"button.add", (Object[])new Object[0]), JavaUiBundle.message("module.javadoc.add.url.button", new Object[0]), CommonBundle.message((String)"button.remove", (Object[])new Object[0])}).createPanel();
        return new JavadocEditorUi().createPanel(tablePanel);
    }

    @NotNull
    private Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            JavadocEditor.$$$reportNull$$$0(0);
        }
        return project2;
    }

    protected DefaultTableModel createModel() {
        String[] javadocUrls;
        MyTableModel tableModel = new MyTableModel();
        for (String javadocUrl : javadocUrls = ((JavaModuleExternalPaths)this.getModel().getModuleExtension(JavaModuleExternalPaths.class)).getJavadocUrls()) {
            tableModel.addTableItem(new TableItem(javadocUrl));
        }
        return tableModel;
    }

    public void moduleStateChanged() {
        if (this.myTable != null) {
            DefaultTableModel tableModel = this.createModel();
            this.myTable.setModel(tableModel);
        }
    }

    @NlsContexts.ConfigurableName
    private static String getName() {
        return JavaUiBundle.message("module.javadoc.title", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/JavadocEditor", "getProject"));
    }

    private static class MyTableModel
    extends DefaultTableModel
    implements ItemRemovable {
        private MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return null;
        }

        public Class<TableItem> getColumnClass(int columnIndex) {
            return TableItem.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public TableItem getTableItemAt(int row) {
            return (TableItem)this.getValueAt(row, 0);
        }

        public void addTableItem(TableItem item) {
            this.addRow(new Object[]{item});
        }
    }

    private static class MyRenderer
    extends ColoredTableCellRenderer {
        private static final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private MyRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(NO_FOCUS_BORDER);
            TableItem tableItem = (TableItem)value;
            if (tableItem != null) {
                tableItem.getCellAppearance().customize((SimpleColoredComponent)this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/roots/ui/configuration/JavadocEditor$MyRenderer", "customizeCellRenderer"));
        }
    }
}

