/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsDetector;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.libraries.ui.impl.LibraryRootsDetectorImpl;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class LibrarySourceRootDetectorUtil {
    public static final ExtensionPointName<RootDetector> JAVA_SOURCE_ROOT_DETECTOR = ExtensionPointName.create((String)"com.intellij.library.javaSourceRootDetector");

    private LibrarySourceRootDetectorUtil() {
    }

    public static VirtualFile[] scanAndSelectDetectedJavaSourceRoots(Component parentComponent, VirtualFile[] rootCandidates) {
        List orderRoots = RootDetectionUtil.detectRoots(Arrays.asList(rootCandidates), (Component)parentComponent, null, (LibraryRootsDetector)new LibraryRootsDetectorImpl(JAVA_SOURCE_ROOT_DETECTOR.getExtensionList()), (OrderRootType[])new OrderRootType[]{OrderRootType.SOURCES});
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (OrderRoot root : orderRoots) {
            result.add(root.getFile());
        }
        return VfsUtilCore.toVirtualFileArray(result);
    }
}

