/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.JdkComboBox;
import com.intellij.openapi.roots.ui.configuration.ModuleJdkConfigurableUi;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.WslSdkFilter;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleJdkConfigurable
implements Disposable {
    private JdkComboBox myCbModuleJdk;
    private JPanel myJdkPanel;
    private ClasspathEditor myModuleEditor;
    private final ProjectSdksModel myJdksModel;
    private final ProjectStructureConfigurable myProjectStructureConfigurable;
    private boolean myFreeze = false;
    private final SdkModel.Listener myListener = new SdkModel.Listener(){

        public void sdkAdded(@NotNull Sdk sdk) {
            if (sdk == null) {
                1.$$$reportNull$$$0(0);
            }
            ModuleJdkConfigurable.this.reloadModel();
        }

        public void beforeSdkRemove(@NotNull Sdk sdk) {
            if (sdk == null) {
                1.$$$reportNull$$$0(1);
            }
            ModuleJdkConfigurable.this.reloadModel();
        }

        public void sdkChanged(@NotNull Sdk sdk, String previousName) {
            if (sdk == null) {
                1.$$$reportNull$$$0(2);
            }
            ModuleJdkConfigurable.this.reloadModel();
        }

        public void sdkHomeSelected(@NotNull Sdk sdk, @NotNull String newSdkHome) {
            if (sdk == null) {
                1.$$$reportNull$$$0(3);
            }
            if (newSdkHome == null) {
                1.$$$reportNull$$$0(4);
            }
            ModuleJdkConfigurable.this.reloadModel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSdkHome";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ModuleJdkConfigurable$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeSdkRemove";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkChanged";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "sdkHomeSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public ModuleJdkConfigurable(ClasspathEditor moduleEditor, ProjectStructureConfigurable projectStructureConfigurable) {
        this.myModuleEditor = moduleEditor;
        this.myJdksModel = projectStructureConfigurable.getProjectJdksModel();
        this.myProjectStructureConfigurable = projectStructureConfigurable;
        this.myJdksModel.addListener(this.myListener);
        this.init();
    }

    public JComponent createComponent() {
        return this.myJdkPanel;
    }

    private void reloadModel() {
        this.myFreeze = true;
        this.myCbModuleJdk.reloadModel();
        this.reset();
        this.myFreeze = false;
    }

    protected abstract ModifiableRootModel getRootModel();

    private void init() {
        Project project2 = this.getRootModel().getModule().getProject();
        Predicate predicate = SimpleJavaSdkType.notSimpleJavaSdkType();
        this.myCbModuleJdk = new JdkComboBox(project2, this.myJdksModel, (Condition<? super SdkTypeId>)((Condition)predicate::test), WslSdkFilter.filterSdkByWsl(project2), WslSdkFilter.filterSdkSuggestionByWsl(project2), null, (Consumer<? super Sdk>)((Consumer)jdk -> {
            int res;
            Sdk projectJdk = this.myJdksModel.getProjectSdk();
            if (projectJdk == null && (res = Messages.showYesNoDialog((Component)this.myJdkPanel, (String)JavaUiBundle.message("project.roots.no.jdk.on.project.message", new Object[0]), (String)JavaUiBundle.message("project.roots.no.jdk.on.project.title", new Object[0]), (Icon)Messages.getInformationIcon())) == 0) {
                this.myJdksModel.setProjectSdk(jdk);
            }
        }));
        this.myCbModuleJdk.showProjectSdkItem();
        this.myCbModuleJdk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModuleJdkConfigurable.this.myFreeze) {
                    return;
                }
                Sdk newJdk = ModuleJdkConfigurable.this.myCbModuleJdk.getSelectedJdk();
                ModuleJdkConfigurable.this.myModuleEditor.setSdk(newJdk);
                ModuleJdkConfigurable.this.clearCaches();
            }
        });
        JButton editButton = new JButton(ApplicationBundle.message((String)"button.edit", (Object[])new Object[0]));
        this.myCbModuleJdk.setEditButton(editButton, this.getRootModel().getModule().getProject(), () -> this.getRootModel().getSdk());
        this.myJdkPanel = new ModuleJdkConfigurableUi(this.myCbModuleJdk, editButton).getPanel();
    }

    private void clearCaches() {
        Module module = this.getRootModel().getModule();
        StructureConfigurableContext context = this.myProjectStructureConfigurable.getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, module));
    }

    public void reset() {
        this.myFreeze = true;
        String jdkName = this.getRootModel().getSdkName();
        if (jdkName != null && !this.getRootModel().isSdkInherited()) {
            Sdk selectedModuleJdk = this.myJdksModel.findSdk(jdkName);
            if (selectedModuleJdk != null) {
                this.myCbModuleJdk.setSelectedJdk(selectedModuleJdk);
            } else {
                this.myCbModuleJdk.setInvalidJdk(jdkName);
                this.clearCaches();
            }
        } else {
            this.myCbModuleJdk.setSelectedJdk(null);
        }
        this.myFreeze = false;
    }

    public void dispose() {
        this.myModuleEditor = null;
        this.myCbModuleJdk = null;
        this.myJdkPanel = null;
        this.myJdksModel.removeListener(this.myListener);
    }
}

