/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.SdkListItem;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import org.jetbrains.annotations.NotNull;

public final class WslSdkFilter {
    public static Condition<? super Sdk> filterSdkByWsl(@NotNull Project project2) {
        String path;
        if (project2 == null) {
            WslSdkFilter.$$$reportNull$$$0(0);
        }
        if ((path = project2.getBasePath()) == null || !WSLUtil.isSystemCompatible()) {
            return Conditions.alwaysTrue();
        }
        WSLDistribution distribution = WslPath.getDistributionByWindowsUncPath((String)path);
        boolean projectOnLocalFs = distribution == null;
        return sdk -> {
            if (projectOnLocalFs && sdk.getSdkType().allowWslSdkForLocalProject()) {
                return true;
            }
            String sdkHomePath = sdk.getHomePath();
            return sdkHomePath == null || WslPath.getDistributionByWindowsUncPath((String)sdkHomePath) == distribution;
        };
    }

    public static Condition<? super SdkListItem.SuggestedItem> filterSdkSuggestionByWsl(@NotNull Project project2) {
        String path;
        if (project2 == null) {
            WslSdkFilter.$$$reportNull$$$0(1);
        }
        if ((path = project2.getBasePath()) == null || !WSLUtil.isSystemCompatible()) {
            return Conditions.alwaysTrue();
        }
        WSLDistribution distribution = WslPath.getDistributionByWindowsUncPath((String)path);
        return suggestedItem -> WslPath.getDistributionByWindowsUncPath((String)suggestedItem.homePath) == distribution;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/WslSdkFilter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "filterSdkByWsl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "filterSdkSuggestionByWsl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

