/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class InlineArtifactAction
extends DumbAwareAction {
    private final ArtifactEditorEx myEditor;

    public InlineArtifactAction(ArtifactEditorEx editor) {
        super(JavaUiBundle.message("action.name.inline.artifact", new Object[0]));
        this.myEditor = editor;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            InlineArtifactAction.$$$reportNull$$$0(0);
        }
        LayoutTreeSelection selection = this.myEditor.getLayoutTreeComponent().getSelection();
        PackagingElementNode<?> node = selection.getNodeIfSingle();
        PackagingElement<?> element = selection.getElementIfSingle();
        e.getPresentation().setEnabled(element instanceof ArtifactPackagingElement && node != null && node.getParentElement(element) != null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            InlineArtifactAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            InlineArtifactAction.$$$reportNull$$$0(2);
        }
        LayoutTreeComponent treeComponent = this.myEditor.getLayoutTreeComponent();
        LayoutTreeSelection selection = treeComponent.getSelection();
        PackagingElement<?> element = selection.getElementIfSingle();
        PackagingElementNode<?> node = selection.getNodeIfSingle();
        if (node == null || !(element instanceof ArtifactPackagingElement)) {
            return;
        }
        CompositePackagingElement<?> parent = node.getParentElement(element);
        CompositePackagingElementNode parentNode = node.getParentNode();
        if (parent == null || parentNode == null) {
            return;
        }
        if (!treeComponent.checkCanModifyChildren((PackagingElement<?>)parent, parentNode, (Collection<? extends PackagingElementNode<?>>)Collections.singletonList(node))) {
            return;
        }
        treeComponent.editLayout(() -> {
            parent.removeChild(element);
            ArtifactEditorContext context = this.myEditor.getContext();
            Artifact artifact = ((ArtifactPackagingElement)element).findArtifact((PackagingElementResolvingContext)context);
            if (artifact != null) {
                CompositePackagingElement rootElement = artifact.getRootElement();
                if (rootElement instanceof ArtifactRootElement) {
                    for (PackagingElement child : rootElement.getChildren()) {
                        parent.addOrFindChild(ArtifactUtil.copyWithChildren((PackagingElement)child, (Project)context.getProject()));
                    }
                } else {
                    parent.addOrFindChild(ArtifactUtil.copyWithChildren((PackagingElement)rootElement, (Project)context.getProject()));
                }
            }
        });
        treeComponent.rebuildTree();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/actions/InlineArtifactAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/actions/InlineArtifactAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

