/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleGroupItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleSourceItemGroup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ModuleElementTypeBase;
import com.intellij.packaging.impl.elements.ModulePackagingElementBase;
import com.intellij.packaging.impl.elements.PackagingElementFactoryImpl;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.packaging.ui.PackagingSourceItemsProvider;
import com.intellij.util.containers.ContainerUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ModulesAndLibrariesSourceItemsProvider
extends PackagingSourceItemsProvider {
    @NotNull
    public Collection<? extends PackagingSourceItem> getSourceItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, PackagingSourceItem parent) {
        if (editorContext == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(1);
        }
        PackagingSourceItem packagingSourceItem = parent;
        int n = 0;
        Collection<Object> collection = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleGroupItem.class, ModuleSourceItemGroup.class}, (Object)packagingSourceItem, n)) {
            case -1 -> ModulesAndLibrariesSourceItemsProvider.createModuleItems(editorContext, Collections.emptyList());
            case 0 -> {
                ModuleGroupItem item = (ModuleGroupItem)packagingSourceItem;
                yield ModulesAndLibrariesSourceItemsProvider.createModuleItems(editorContext, item.getPath());
            }
            case 1 -> {
                ModuleSourceItemGroup group = (ModuleSourceItemGroup)packagingSourceItem;
                yield ModulesAndLibrariesSourceItemsProvider.createAvailableItems(editorContext, artifact, group.getModule());
            }
            default -> Collections.emptyList();
        };
        if (collection == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    private static Collection<? extends PackagingSourceItem> createAvailableItems(@NotNull ArtifactEditorContext editorContext, @NotNull Artifact artifact, @NotNull Module module) {
        if (editorContext == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(3);
        }
        if (artifact == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(4);
        }
        if (module == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(5);
        }
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        for (Module toAdd : ModulesAndLibrariesSourceItemsProvider.getAvailableModules(editorContext, artifact, ProductionModuleOutputElementType.ELEMENT_TYPE, new Module[]{module})) {
            items.add(new ModuleOutputSourceItem(toAdd));
        }
        ArrayList<Library> libraries = new ArrayList<Library>();
        ModuleRootModel rootModel = editorContext.getModulesProvider().getRootModel(module);
        for (OrderEntry orderEntry : rootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry)) continue;
            LibraryOrderEntry libraryEntry = (LibraryOrderEntry)orderEntry;
            Library library = libraryEntry.getLibrary();
            DependencyScope scope = libraryEntry.getScope();
            if (library == null || !scope.isForProductionRuntime()) continue;
            libraries.add(library);
        }
        for (Library library : ModulesAndLibrariesSourceItemsProvider.getNotAddedLibraries(editorContext, artifact, libraries)) {
            items.add(new LibrarySourceItem(library));
        }
        ArrayList<PackagingSourceItem> arrayList = items;
        if (arrayList == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<? extends PackagingSourceItem> createModuleItems(@NotNull ArtifactEditorContext editorContext, @NotNull List<String> groupPath) {
        if (editorContext == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(7);
        }
        if (groupPath == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(8);
        }
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        ModuleGrouper grouper = ModuleGrouper.instanceFor((Project)editorContext.getProject(), (ModifiableModuleModel)editorContext.getModifiableModuleModel());
        HashSet<String> groups = new HashSet<String>();
        for (Module module : grouper.getAllModules()) {
            List path = grouper.getGroupPath(module);
            if (Comparing.equal((Object)path, groupPath)) {
                items.add(new ModuleSourceItemGroup(module));
                continue;
            }
            if (!ContainerUtil.startsWith((List)path, groupPath)) continue;
            groups.add((String)path.get(groupPath.size()));
        }
        for (String group : groups) {
            items.add(0, new ModuleGroupItem(ContainerUtil.append(groupPath, (Object[])new String[]{group})));
        }
        ArrayList<PackagingSourceItem> arrayList = items;
        if (arrayList == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static <E extends ModulePackagingElementBase> List<? extends Module> getAvailableModules(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull ModuleElementTypeBase<E> elementType, Module ... allModules) {
        if (context == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(10);
        }
        if (artifact == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(11);
        }
        if (elementType == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(12);
        }
        HashSet<Module> modules = new HashSet<Module>();
        for (Module module : allModules) {
            if (!elementType.isSuitableModule(context.getModulesProvider(), module)) continue;
            modules.add(module);
        }
        ArtifactUtil.processPackagingElements((Artifact)artifact, elementType, moduleElement -> {
            modules.remove(moduleElement.findModule((PackagingElementResolvingContext)context));
            return true;
        }, (PackagingElementResolvingContext)context, (boolean)true);
        return new ArrayList(modules);
    }

    private static List<? extends Library> getNotAddedLibraries(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, List<? extends Library> librariesList) {
        if (context == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(13);
        }
        if (artifact == null) {
            ModulesAndLibrariesSourceItemsProvider.$$$reportNull$$$0(14);
        }
        HashSet roots = new HashSet();
        ArtifactUtil.processPackagingElements((Artifact)artifact, (PackagingElementType)PackagingElementFactoryImpl.FILE_COPY_ELEMENT_TYPE, fileCopyPackagingElement -> {
            VirtualFile root = fileCopyPackagingElement.getLibraryRoot();
            if (root != null) {
                roots.add(root);
            }
            return true;
        }, (PackagingElementResolvingContext)context, (boolean)true);
        ArrayList<Library> result = new ArrayList<Library>();
        for (Library library : librariesList) {
            if (roots.containsAll(Arrays.asList(library.getFiles(OrderRootType.CLASSES)))) continue;
            result.add(library);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorContext";
                break;
            }
            case 1: 
            case 4: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupPath";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/ModulesAndLibrariesSourceItemsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceItems";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createAvailableItems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceItems";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createAvailableItems";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createModuleItems";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableModules";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNotAddedLibraries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 9 -> new IllegalStateException(string);
        };
    }
}

