/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutIntoDefaultLocationActionBase;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementOutputKind;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.artifacts.PackagingElementProcessor;
import com.intellij.packaging.impl.elements.FileCopyPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExtractIntoDefaultLocationAction
extends PutIntoDefaultLocationActionBase {
    public ExtractIntoDefaultLocationAction(SourceItemsTree sourceItemsTree, ArtifactEditorEx artifactEditor) {
        super(sourceItemsTree, artifactEditor);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ExtractIntoDefaultLocationAction.$$$reportNull$$$0(0);
        }
        String pathForClasses = this.myArtifactEditor.getArtifact().getArtifactType().getDefaultPathFor(PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES);
        Presentation presentation = e.getPresentation();
        if (this.onlyJarsSelected() && pathForClasses != null) {
            presentation.setText(JavaUiBundle.message("action.text.extract.source.item.into.0", ExtractIntoDefaultLocationAction.getTargetLocationText(Collections.singleton(pathForClasses))));
            presentation.setVisible(true);
        } else {
            presentation.setVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ExtractIntoDefaultLocationAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    private boolean onlyJarsSelected() {
        for (PackagingSourceItem item : this.mySourceItemsTree.getSelectedItems()) {
            if (!item.isProvideElements() || item.getKindOfProducedElements().containsJarFiles() && !item.getKindOfProducedElements().containsDirectoriesWithClasses()) continue;
            return false;
        }
        return true;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String pathForClasses;
        if (e == null) {
            ExtractIntoDefaultLocationAction.$$$reportNull$$$0(2);
        }
        if ((pathForClasses = this.myArtifactEditor.getArtifact().getArtifactType().getDefaultPathFor(PackagingElementOutputKind.DIRECTORIES_WITH_CLASSES)) != null) {
            final ArrayList extracted = new ArrayList();
            for (PackagingSourceItem item : this.mySourceItemsTree.getSelectedItems()) {
                ArtifactEditorContext context = this.myArtifactEditor.getContext();
                List elements = item.createElements(context);
                ArtifactUtil.processElementsWithSubstitutions((List)elements, (PackagingElementResolvingContext)context, (ArtifactType)context.getArtifactType(), (PackagingElementPath)PackagingElementPath.EMPTY, (PackagingElementProcessor)new PackagingElementProcessor<PackagingElement<?>>(this){

                    public boolean process(@NotNull PackagingElement<?> element, @NotNull PackagingElementPath path) {
                        VirtualFile jarRoot;
                        VirtualFile file;
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (path == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (element instanceof FileCopyPackagingElement && (file = ((FileCopyPackagingElement)element).findFile()) != null && (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(file)) != null) {
                            extracted.add(PackagingElementFactory.getInstance().createExtractedDirectory(jarRoot));
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "element";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "path";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/actions/ExtractIntoDefaultLocationAction$1";
                        objectArray[2] = "process";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
            this.myArtifactEditor.getLayoutTreeComponent().putElements(pathForClasses, extracted);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/actions/ExtractIntoDefaultLocationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/actions/ExtractIntoDefaultLocationAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

