/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ArtifactEditorFindUsagesActionBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ArtifactSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.treeStructure.Tree;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class SourceItemFindUsagesAction
extends ArtifactEditorFindUsagesActionBase {
    private final SourceItemsTree myTree;

    public SourceItemFindUsagesAction(SourceItemsTree tree, ArtifactsStructureConfigurableContext artifactContext) {
        super((Tree)tree, artifactContext);
        this.myTree = tree;
    }

    @Override
    protected ProjectStructureElement getSelectedElement() {
        List<SourceItemNode> nodes = this.myTree.getSelectedSourceItemNodes();
        if (nodes.size() != 1) {
            return null;
        }
        SourceItemNode node = nodes.get(0);
        if (node == null) {
            return null;
        }
        PackagingSourceItem sourceItem = node.getSourceItem();
        if (sourceItem == null) {
            return null;
        }
        StructureConfigurableContext context = this.getContext();
        PackagingSourceItem packagingSourceItem = sourceItem;
        Objects.requireNonNull(packagingSourceItem);
        PackagingSourceItem packagingSourceItem2 = packagingSourceItem;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleOutputSourceItem.class, LibrarySourceItem.class, ArtifactSourceItem.class}, (Object)packagingSourceItem2, n)) {
            case 0 -> {
                ModuleOutputSourceItem item = (ModuleOutputSourceItem)packagingSourceItem2;
                yield new ModuleProjectStructureElement(context, item.getModule());
            }
            case 1 -> {
                LibrarySourceItem item = (LibrarySourceItem)packagingSourceItem2;
                yield new LibraryProjectStructureElement(context, item.getLibrary());
            }
            case 2 -> {
                ArtifactSourceItem item = (ArtifactSourceItem)packagingSourceItem2;
                yield this.myArtifactContext.getOrCreateArtifactElement(item.getArtifact());
            }
            default -> null;
        };
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            SourceItemFindUsagesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/sourceItems/actions/SourceItemFindUsagesAction", "getActionUpdateThread"));
    }
}

