/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddLibraryDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddModuleDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AddNewModuleLibraryAction;
import com.intellij.openapi.roots.ui.configuration.classpath.AnalyzeModuleDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelInClasspathAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableModel;
import com.intellij.openapi.roots.ui.configuration.classpath.InlineModuleDependencyAction;
import com.intellij.openapi.roots.ui.configuration.classpath.InvalidJdkItem;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.EditExistingLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertModuleLibraryToRepositoryLibraryAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.OrderPanelListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.TextTransferable;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClasspathPanelImpl
extends JPanel
implements ClasspathPanel {
    private static final Logger LOG = Logger.getInstance(ClasspathPanelImpl.class);
    private final JBTable myEntryTable;
    private final ClasspathTableModel myModel;
    private final EventDispatcher<OrderPanelListener> myListeners = EventDispatcher.create(OrderPanelListener.class);
    private List<AddItemPopupAction<?>> myPopupActions = null;
    private final AnAction myEditButton;
    private final ModuleConfigurationState myState;
    private AnAction myRemoveButton;
    private int myInsideChange = 0;

    public ClasspathPanelImpl(ModuleConfigurationState state) {
        super(new BorderLayout());
        this.myState = state;
        this.myModel = new ClasspathTableModel(state, this.getStructureConfigurableContext());
        this.myEntryTable = new JBTable((TableModel)((Object)this.myModel)){

            protected TableRowSorter<TableModel> createRowSorter(TableModel model) {
                return new JBTable.DefaultColumnInfoBasedRowSorter(this, model){

                    public void toggleSortOrder(int column) {
                        if (this.isSortable(column)) {
                            RowSorter.SortKey oldKey = (RowSorter.SortKey)ContainerUtil.getFirstItem((List)this.getSortKeys());
                            SortOrder oldOrder = oldKey == null || oldKey.getColumn() != column ? SortOrder.UNSORTED : oldKey.getSortOrder();
                            this.setSortKeys(Collections.singletonList(new RowSorter.SortKey(column, ClasspathPanelImpl.getNextSortOrder(oldOrder))));
                        }
                    }
                };
            }
        };
        this.myEntryTable.setShowGrid(false);
        this.myEntryTable.setDragEnabled(false);
        this.myEntryTable.setIntercellSpacing(new Dimension(0, 0));
        this.myEntryTable.setDefaultRenderer(ClasspathTableItem.class, (TableCellRenderer)((Object)new TableItemRenderer(this.getStructureConfigurableContext())));
        this.myEntryTable.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new ExportFlagRenderer()));
        ComboBox scopeEditor = new ComboBox((ComboBoxModel)new EnumComboBoxModel(DependencyScope.class));
        this.myEntryTable.setDefaultEditor(DependencyScope.class, (TableCellEditor)new DefaultCellEditor((JComboBox<?>)scopeEditor));
        this.myEntryTable.setDefaultRenderer(DependencyScope.class, (TableCellRenderer)new ComboBoxTableRenderer<DependencyScope>(DependencyScope.values()){

            protected String getTextFor(@NotNull DependencyScope value) {
                if (value == null) {
                    2.$$$reportNull$$$0(0);
                }
                return value.getDisplayName();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$2", "getTextFor"));
            }
        });
        this.myEntryTable.setTransferHandler(new TransferHandler(){

            @Override
            @Nullable
            protected Transferable createTransferable(JComponent c) {
                OrderEntry entry = ClasspathPanelImpl.this.getSelectedEntry();
                if (entry == null) {
                    return null;
                }
                return new TextTransferable(entry.getPresentableName());
            }

            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }
        });
        this.myEntryTable.getSelectionModel().setSelectionMode(2);
        SpeedSearchBase<JBTable> search = new SpeedSearchBase<JBTable>(this.myEntryTable, null){

            public int getSelectedIndex() {
                return ClasspathPanelImpl.this.getSelectedRow();
            }

            protected int getElementCount() {
                return ClasspathPanelImpl.this.getRowCount();
            }

            protected Object getElementAt(int viewIndex) {
                return ClasspathPanelImpl.this.myModel.getItem(ClasspathPanelImpl.this.myEntryTable.convertRowIndexToModel(viewIndex));
            }

            public String getElementText(Object element) {
                return ClasspathPanelImpl.getCellAppearance((ClasspathTableItem)element, ClasspathPanelImpl.this.getStructureConfigurableContext(), false).getText();
            }

            public void selectElement(Object element, String selectedText) {
                int count = ClasspathPanelImpl.this.getRowCount();
                for (int row = 0; row < count; ++row) {
                    if (!element.equals(ClasspathPanelImpl.this.myModel.getItem(row))) continue;
                    int viewRow = ClasspathPanelImpl.this.myEntryTable.convertRowIndexToView(row);
                    ClasspathPanelImpl.this.myEntryTable.getSelectionModel().setSelectionInterval(viewRow, viewRow);
                    TableUtil.scrollSelectionToVisible((JTable)ClasspathPanelImpl.this.myEntryTable);
                    break;
                }
            }
        };
        search.setupListeners();
        this.setFixedColumnWidth(0, ClasspathTableModel.getExportColumnName());
        this.setFixedColumnWidth(2, DependencyScope.COMPILE.toString() + "     ");
        this.myEntryTable.getTableHeader().getColumnModel().getColumn(1).setPreferredWidth(10000);
        this.myEntryTable.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = ClasspathPanelImpl.this.myEntryTable.getSelectedRows();
                boolean currentlyMarked = true;
                for (int selectedRow : selectedRows) {
                    ClasspathTableItem<?> item = ClasspathPanelImpl.this.getItemAt(selectedRow);
                    if (selectedRow < 0 || !item.isExportable()) {
                        return;
                    }
                    currentlyMarked &= item.isExported();
                }
                for (int selectedRow : selectedRows) {
                    ClasspathPanelImpl.this.getItemAt(selectedRow).setExported(!currentlyMarked);
                }
                ClasspathPanelImpl.this.myModel.fireTableDataChanged();
                TableUtil.selectRows((JTable)ClasspathPanelImpl.this.myEntryTable, (int[])selectedRows);
            }
        }, KeyStroke.getKeyStroke(32, 0), 0);
        this.myEditButton = new DumbAwareAction(JavaUiBundle.message("module.classpath.button.edit", new Object[0]), null, IconUtil.getEditIcon()){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                ClasspathPanelImpl.this.doEdit();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(1);
                }
                ClasspathTableItem<?> selectedItem = ClasspathPanelImpl.this.getSelectedItem();
                e.getPresentation().setEnabled(selectedItem != null && selectedItem.isEditable());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    6.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$6";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$6";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        this.add((Component)this.createTableWithButtons(), "Center");
        if (this.myEntryTable.getRowCount() > 0) {
            this.myEntryTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                ClasspathPanelImpl.this.navigate(true);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$7", "onDoubleClick"));
            }
        }.installOn((Component)this.myEntryTable);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        AnAction navigateAction = new AnAction(JavaUiBundle.message("classpath.panel.navigate.action.text", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                ClasspathPanelImpl.this.navigate(false);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                Presentation presentation = e.getPresentation();
                presentation.setEnabled(false);
                OrderEntry entry = ClasspathPanelImpl.this.getSelectedEntry();
                if (entry != null && entry.isValid() && !(entry instanceof ModuleSourceOrderEntry)) {
                    presentation.setEnabled(true);
                }
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    8.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$8";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$8";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        navigateAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditSource").getShortcutSet(), (JComponent)this.myEntryTable);
        actionGroup.add(this.myEditButton);
        actionGroup.add(this.myRemoveButton);
        actionGroup.add(navigateAction);
        actionGroup.add((AnAction)new InlineModuleDependencyAction(this));
        actionGroup.add((AnAction)new MyFindUsagesAction());
        actionGroup.add((AnAction)new AnalyzeModuleDependencyAction(this));
        this.addChangeLibraryLevelAction(actionGroup, "project");
        this.addChangeLibraryLevelAction(actionGroup, "application");
        this.addChangeLibraryLevelAction(actionGroup, "module");
        actionGroup.add((AnAction)new ConvertModuleLibraryToRepositoryLibraryAction(this, this.getStructureConfigurableContext()));
        PopupHandler.installPopupMenu((JComponent)this.myEntryTable, (ActionGroup)actionGroup, (String)"ClassPathEntriesPopup");
    }

    @NotNull
    private static SortOrder getNextSortOrder(@NotNull SortOrder order) {
        if (order == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(0);
        }
        SortOrder sortOrder = switch (order) {
            default -> throw new MatchException(null, null);
            case SortOrder.ASCENDING -> SortOrder.DESCENDING;
            case SortOrder.DESCENDING -> SortOrder.UNSORTED;
            case SortOrder.UNSORTED -> SortOrder.ASCENDING;
        };
        if (sortOrder == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(1);
        }
        return sortOrder;
    }

    private ClasspathTableItem<?> getItemAt(int selectedRow) {
        return (ClasspathTableItem)this.myModel.getItem(this.myEntryTable.convertRowIndexToModel(selectedRow));
    }

    private void addChangeLibraryLevelAction(DefaultActionGroup actionGroup, String tableLevel) {
        LibraryTablePresentation presentation = LibraryEditingUtil.getLibraryTablePresentation(this.getProject(), tableLevel);
        actionGroup.add((AnAction)new ChangeLibraryLevelInClasspathAction(this, presentation.getDisplayName(true), tableLevel));
    }

    @Override
    @Nullable
    public OrderEntry getSelectedEntry() {
        ClasspathTableItem<?> item = this.getSelectedItem();
        return item != null ? (OrderEntry)item.getEntry() : null;
    }

    @Nullable
    private ClasspathTableItem<?> getSelectedItem() {
        if (this.myEntryTable.getSelectedRowCount() != 1) {
            return null;
        }
        return this.getItemAt(this.getSelectedRow());
    }

    @Override
    public int getRowCount() {
        return this.myModel.getRowCount();
    }

    @Override
    public int getSelectedRow() {
        return this.myEntryTable.getSelectedRow();
    }

    private void setFixedColumnWidth(int columnIndex, String sampleText) {
        TableColumn column = this.myEntryTable.getTableHeader().getColumnModel().getColumn(columnIndex);
        FontMetrics fontMetrics = this.myEntryTable.getFontMetrics(this.myEntryTable.getFont());
        int width = fontMetrics.stringWidth(" " + sampleText + " ") + JBUIScale.scale((int)10);
        column.setPreferredWidth(width);
        column.setMinWidth(width);
        column.setResizable(false);
    }

    @Override
    public void navigate(boolean openLibraryEditor) {
        Sdk jdk;
        OrderEntry entry = this.getSelectedEntry();
        ProjectStructureConfigurable rootConfigurable = this.getProjectStructureConfigurable();
        if (entry instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)entry).getModule();
            if (module != null) {
                rootConfigurable.select(module.getName(), null, true);
            }
        } else if (entry instanceof LibraryOrderEntry) {
            if (!openLibraryEditor && !((LibraryOrderEntry)entry).getLibraryLevel().equals("module")) {
                rootConfigurable.select((LibraryOrderEntry)entry, true);
            } else {
                this.doEdit();
            }
        } else if (entry instanceof JdkOrderEntry && (jdk = ((JdkOrderEntry)entry).getJdk()) != null) {
            rootConfigurable.select(jdk, true);
        }
    }

    private JComponent createTableWithButtons() {
        final ClasspathPanelAction removeAction = new ClasspathPanelAction(this){

            @Override
            public void run() {
                ClasspathPanelImpl.this.removeSelectedItems(TableUtil.removeSelectedItems((JTable)ClasspathPanelImpl.this.myEntryTable));
            }
        };
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTable)this.myEntryTable);
        AnActionButtonUpdater moveUpDownUpdater = e -> {
            for (RowSorter.SortKey key : this.myEntryTable.getRowSorter().getSortKeys()) {
                if (key.getSortOrder() == SortOrder.UNSORTED) continue;
                return false;
            }
            return true;
        };
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ClasspathPanelImpl.this.initPopupActions();
                ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<AddItemPopupAction<?>>(this, null, ClasspathPanelImpl.this.myPopupActions){

                    public Icon getIconFor(AddItemPopupAction<?> aValue) {
                        return aValue.getIcon();
                    }

                    public boolean hasSubstep(AddItemPopupAction<?> selectedValue) {
                        return selectedValue.hasSubStep();
                    }

                    public boolean isMnemonicsNavigationEnabled() {
                        return true;
                    }

                    public PopupStep<?> onChosen(AddItemPopupAction<?> selectedValue, boolean finalChoice) {
                        if (selectedValue.hasSubStep()) {
                            return selectedValue.createSubStep();
                        }
                        return this.doFinalStep(() -> selectedValue.execute());
                    }

                    @NotNull
                    public String getTextFor(AddItemPopupAction<?> value) {
                        String string = "&" + value.getIndex() + "  " + value.getTitle();
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$13$1", "getTextFor"));
                    }
                });
                RelativePoint point = button.getPreferredPopupPoint();
                popup.show(point);
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                removeAction.actionPerformed(null);
            }
        }).setRemoveActionUpdater(e -> {
            int[] selectedRows;
            for (int selectedRow : selectedRows = this.myEntryTable.getSelectedRows()) {
                if (this.getItemAt(selectedRow).isRemovable()) continue;
                return false;
            }
            return selectedRows.length > 0;
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ClasspathPanelImpl.this.moveSelectedRows(-1);
            }
        }).setMoveUpActionUpdater(moveUpDownUpdater).setMoveUpActionName(JavaUiBundle.message("action.text.class.path.move.up", new Object[0])).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ClasspathPanelImpl.this.moveSelectedRows(1);
            }
        }).setMoveDownActionUpdater(moveUpDownUpdater).setMoveDownActionName(JavaUiBundle.message("action.text.class.path.move.down", new Object[0])).addExtraAction(this.myEditButton);
        JPanel panel2 = decorator.createPanel();
        this.myRemoveButton = ToolbarDecorator.findRemoveButton((JComponent)panel2);
        return panel2;
    }

    private void doEdit() {
        OrderEntry entry = this.getSelectedEntry();
        if (!(entry instanceof LibraryOrderEntry)) {
            return;
        }
        Library library = ((LibraryOrderEntry)entry).getLibrary();
        if (library == null) {
            return;
        }
        LibraryTable table = library.getTable();
        String tableLevel = table != null ? table.getTableLevel() : "module";
        LibraryTablePresentation presentation = LibraryEditingUtil.getLibraryTablePresentation(this.getProject(), tableLevel);
        LibraryTableModifiableModelProvider provider = this.getModifiableModelProvider(tableLevel);
        EditExistingLibraryDialog dialog = EditExistingLibraryDialog.createDialog(this, provider, library, this.myState.getProject(), presentation, this.getStructureConfigurableContext());
        dialog.setContextModule(this.getRootModel().getModule());
        if (dialog.showAndGet()) {
            if (table == null) {
                this.rootsChanged();
            }
            this.myEntryTable.repaint();
            this.getProjectStructureConfigurable().getModulesConfig().getTree().repaint();
        }
    }

    private void removeSelectedItems(List<Object[]> removedRows) {
        if (removedRows.isEmpty()) {
            return;
        }
        for (Object[] removedRow : removedRows) {
            ClasspathTableItem item = (ClasspathTableItem)removedRow[1];
            Object orderEntry = item.getEntry();
            if (orderEntry == null) continue;
            this.getRootModel().removeOrderEntry(orderEntry);
        }
        int[] selectedRows = this.myEntryTable.getSelectedRows();
        this.myModel.fireTableDataChanged();
        TableUtil.selectRows((JTable)this.myEntryTable, (int[])selectedRows);
        StructureConfigurableContext context = this.getProjectStructureConfigurable().getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, this.getRootModel().getModule()));
    }

    private ProjectStructureConfigurable getProjectStructureConfigurable() {
        return ((ModulesConfigurator)this.myState.getModulesProvider()).getProjectStructureConfigurable();
    }

    @Override
    @NotNull
    public LibraryTableModifiableModelProvider getModifiableModelProvider(@NotNull String tableLevel) {
        if (tableLevel == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(2);
        }
        if ("module".equals(tableLevel)) {
            final LibraryTable moduleLibraryTable = this.getRootModel().getModuleLibraryTable();
            return new LibraryTableModifiableModelProvider(){

                @Override
                public LibraryTable.ModifiableModel getModifiableModel() {
                    return moduleLibraryTable.getModifiableModel();
                }
            };
        }
        StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider = this.getStructureConfigurableContext().createModifiableModelProvider(tableLevel);
        if (structureLibraryTableModifiableModelProvider == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(3);
        }
        return structureLibraryTableModifiableModelProvider;
    }

    @Override
    public void runClasspathPanelAction(Runnable action) {
        try {
            this.disableModelUpdate();
            action.run();
        }
        finally {
            this.enableModelUpdate();
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myEntryTable, true));
        }
    }

    @Override
    public void addItems(List<? extends ClasspathTableItem<?>> toAdd, int atIndex) {
        int index = atIndex == -1 ? this.getRowCount() : atIndex;
        IntArrayList toSelect = new IntArrayList();
        for (ClasspathTableItem<?> item : toAdd) {
            this.myModel.insertRow(index, item);
            toSelect.add(index);
            ++index;
        }
        TableUtil.selectRows((JTable)this.myEntryTable, (int[])toSelect.toIntArray());
        TableUtil.scrollSelectionToVisible((JTable)this.myEntryTable);
        StructureConfigurableContext context = this.getProjectStructureConfigurable().getContext();
        context.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(context, this.getRootModel().getModule()));
    }

    @Override
    public ModifiableRootModel getRootModel() {
        return this.myState.getModifiableRootModel();
    }

    @Override
    public Project getProject() {
        return this.myState.getProject();
    }

    @Override
    public ModuleConfigurationState getModuleConfigurationState() {
        return this.myState;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void rootsChanged() {
        this.forceInitFromModel();
    }

    private void initPopupActions() {
        if (this.myPopupActions == null) {
            int actionIndex = 1;
            ArrayList actions = new ArrayList();
            StructureConfigurableContext context = this.getStructureConfigurableContext();
            actions.add(new AddNewModuleLibraryAction(this, actionIndex++, context));
            actions.add(new AddLibraryDependencyAction((ClasspathPanel)this, actionIndex++, JavaUiBundle.message("classpath.add.library.action", new Object[0]), context));
            actions.add(new AddModuleDependencyAction(this, actionIndex, context));
            this.myPopupActions = actions;
        }
    }

    private StructureConfigurableContext getStructureConfigurableContext() {
        return this.getProjectStructureConfigurable().getContext();
    }

    private void enableModelUpdate() {
        --this.myInsideChange;
    }

    private void disableModelUpdate() {
        ++this.myInsideChange;
    }

    public void addListener(OrderPanelListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    public void removeListener(OrderPanelListener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    private void moveSelectedRows(int increment) {
        int row;
        LOG.assertTrue(increment == -1 || increment == 1);
        if (this.myEntryTable.isEditing()) {
            this.myEntryTable.getCellEditor().stopCellEditing();
        }
        ListSelectionModel selectionModel = this.myEntryTable.getSelectionModel();
        int n = row = increment < 0 ? 0 : this.getRowCount() - 1;
        while (increment < 0 ? row < this.getRowCount() : row >= 0) {
            if (selectionModel.isSelectedIndex(row)) {
                int newRow = this.moveRow(row, increment);
                selectionModel.removeSelectionInterval(row, row);
                selectionModel.addSelectionInterval(newRow, newRow);
            }
            row += increment < 0 ? 1 : -1;
        }
        Rectangle cellRect = this.myEntryTable.getCellRect(selectionModel.getMinSelectionIndex(), 0, true);
        this.myEntryTable.scrollRectToVisible(cellRect);
        this.myEntryTable.repaint();
    }

    public void selectOrderEntry(@NotNull OrderEntry entry) {
        if (entry == null) {
            ClasspathPanelImpl.$$$reportNull$$$0(4);
        }
        for (int row = 0; row < this.getRowCount(); ++row) {
            Object orderEntry = this.getItemAt(row).getEntry();
            if (orderEntry == null || !entry.getPresentableName().equals(orderEntry.getPresentableName()) || orderEntry instanceof ExportableOrderEntry && entry instanceof ExportableOrderEntry && ((ExportableOrderEntry)entry).getScope() != ((ExportableOrderEntry)orderEntry).getScope()) continue;
            this.myEntryTable.getSelectionModel().setSelectionInterval(row, row);
            TableUtil.scrollSelectionToVisible((JTable)this.myEntryTable);
        }
        IdeFocusManager.getInstance((Project)this.myState.getProject()).requestFocus((Component)this.myEntryTable, true);
    }

    private int moveRow(int row, int increment) {
        int newIndex = Math.abs(row + increment) % this.getRowCount();
        this.myModel.exchangeRows(row, newIndex);
        return newIndex;
    }

    public void stopEditing() {
        TableUtil.stopEditing((JTable)this.myEntryTable);
    }

    public void initFromModel() {
        if (this.myInsideChange == 0) {
            this.forceInitFromModel();
        }
    }

    public void forceInitFromModel() {
        HashSet oldSelection = new HashSet();
        for (int i : this.myEntryTable.getSelectedRows()) {
            ContainerUtil.addIfNotNull(oldSelection, this.getItemAt(i));
        }
        this.myModel.clear();
        this.myModel.init();
        this.myModel.fireTableDataChanged();
        IntArrayList newSelection = new IntArrayList();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!oldSelection.contains(this.getItemAt(i))) continue;
            newSelection.add(i);
        }
        TableUtil.selectRows((JTable)this.myEntryTable, (int[])newSelection.toIntArray());
    }

    static CellAppearanceEx getCellAppearance(ClasspathTableItem<?> item, StructureConfigurableContext context, boolean selected) {
        OrderEntryAppearanceService service = OrderEntryAppearanceService.getInstance();
        if (item instanceof InvalidJdkItem) {
            return service.forJdk(null, false, selected, true);
        }
        Object entry = item.getEntry();
        assert (entry != null) : item;
        return service.forOrderEntry(context.getProject(), entry, selected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableLevel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextSortOrder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModelProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNextSortOrder";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModelProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectOrderEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    private static class TableItemRenderer
    extends ColoredTableCellRenderer {
        private final Border NO_FOCUS_BORDER = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private final StructureConfigurableContext myContext;

        TableItemRenderer(StructureConfigurableContext context) {
            this.myContext = context;
        }

        protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                TableItemRenderer.$$$reportNull$$$0(0);
            }
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(this.NO_FOCUS_BORDER);
            if (value instanceof ClasspathTableItem) {
                ClasspathTableItem tableItem = (ClasspathTableItem)value;
                ClasspathPanelImpl.getCellAppearance(tableItem, this.myContext, selected).customize((SimpleColoredComponent)this);
                this.setToolTipText(tableItem.getTooltipText());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$TableItemRenderer", "customizeCellRenderer"));
        }
    }

    private static class ExportFlagRenderer
    extends BooleanTableCellRenderer {
        private ExportFlagRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, table.isCellEditable(row, column) ? value : null, isSelected, hasFocus, row, column);
        }
    }

    private final class MyFindUsagesAction
    extends FindUsagesInProjectStructureActionBase {
        private MyFindUsagesAction() {
            super((JComponent)ClasspathPanelImpl.this.myEntryTable, ClasspathPanelImpl.this.getProjectStructureConfigurable());
        }

        @Override
        protected boolean isEnabled() {
            return this.getSelectedElement() != null;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyFindUsagesAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        @Override
        protected ProjectStructureElement getSelectedElement() {
            Sdk jdk;
            OrderEntry entry = ClasspathPanelImpl.this.getSelectedEntry();
            if (entry instanceof LibraryOrderEntry) {
                Library library = ((LibraryOrderEntry)entry).getLibrary();
                if (library != null) {
                    return new LibraryProjectStructureElement(this.getContext(), library);
                }
            } else if (entry instanceof ModuleOrderEntry) {
                Module module = ((ModuleOrderEntry)entry).getModule();
                if (module != null) {
                    return new ModuleProjectStructureElement(this.getContext(), module);
                }
            } else if (entry instanceof JdkOrderEntry && (jdk = ((JdkOrderEntry)entry).getJdk()) != null) {
                return new SdkProjectStructureElement(this.getContext(), jdk);
            }
            return null;
        }

        @Override
        protected RelativePoint getPointToShowResults() {
            Rectangle rect = ClasspathPanelImpl.this.myEntryTable.getCellRect(ClasspathPanelImpl.this.getSelectedRow(), 1, false);
            Point location = rect.getLocation();
            location.y += rect.height;
            return new RelativePoint((Component)ClasspathPanelImpl.this.myEntryTable, location);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/classpath/ClasspathPanelImpl$MyFindUsagesAction", "getActionUpdateThread"));
        }
    }
}

