/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.classpath.LibraryItem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import java.lang.runtime.SwitchBootstraps;
import org.jetbrains.annotations.Nullable;

class ClasspathTableItem<T extends OrderEntry> {
    @Nullable
    protected final T myEntry;
    private final boolean myRemovable;

    @Nullable
    public static ClasspathTableItem<?> createItem(OrderEntry orderEntry, StructureConfigurableContext context) {
        OrderEntry orderEntry2 = orderEntry;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JdkOrderEntry.class, LibraryOrderEntry.class, ModuleOrderEntry.class, ModuleSourceOrderEntry.class}, (Object)orderEntry2, n)) {
            case 0 -> {
                JdkOrderEntry entry = (JdkOrderEntry)orderEntry2;
                yield new ClasspathTableItem<LibraryOrderEntry>((LibraryOrderEntry)entry, false);
            }
            case 1 -> {
                LibraryOrderEntry entry = (LibraryOrderEntry)orderEntry2;
                yield ClasspathTableItem.createLibItem(entry, context);
            }
            case 2 -> {
                ModuleOrderEntry entry = (ModuleOrderEntry)orderEntry2;
                yield new ClasspathTableItem<ModuleOrderEntry>(entry, true);
            }
            case 3 -> {
                ModuleSourceOrderEntry entry = (ModuleSourceOrderEntry)orderEntry2;
                yield new ClasspathTableItem<ModuleSourceOrderEntry>(entry, false);
            }
            default -> null;
        };
    }

    public static ClasspathTableItem<LibraryOrderEntry> createLibItem(LibraryOrderEntry orderEntry, StructureConfigurableContext context) {
        return new LibraryItem(orderEntry, context);
    }

    protected ClasspathTableItem(@Nullable T entry, boolean removable) {
        this.myEntry = entry;
        this.myRemovable = removable;
    }

    public final boolean isExportable() {
        return this.myEntry instanceof ExportableOrderEntry;
    }

    public final boolean isExported() {
        return this.myEntry instanceof ExportableOrderEntry && ((ExportableOrderEntry)this.myEntry).isExported();
    }

    public final void setExported(boolean isExported) {
        if (this.myEntry instanceof ExportableOrderEntry) {
            ((ExportableOrderEntry)this.myEntry).setExported(isExported);
        }
    }

    @Nullable
    public final DependencyScope getScope() {
        return this.myEntry instanceof ExportableOrderEntry ? ((ExportableOrderEntry)this.myEntry).getScope() : null;
    }

    public final void setScope(DependencyScope scope) {
        if (this.myEntry instanceof ExportableOrderEntry) {
            ((ExportableOrderEntry)this.myEntry).setScope(scope);
        }
    }

    @Nullable
    public final T getEntry() {
        return this.myEntry;
    }

    public boolean isRemovable() {
        return this.myRemovable;
    }

    public boolean isEditable() {
        return false;
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getTooltipText() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClasspathTableItem item = (ClasspathTableItem)o;
        return Comparing.equal(this.myEntry, item.myEntry);
    }

    public int hashCode() {
        return this.myEntry != null ? this.myEntry.hashCode() : 0;
    }
}

