/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;

class LibraryItem
extends ClasspathTableItem<LibraryOrderEntry> {
    private final StructureConfigurableContext myContext;

    LibraryItem(LibraryOrderEntry orderEntry, StructureConfigurableContext context) {
        super(orderEntry, true);
        this.myContext = context;
    }

    @Override
    public boolean isEditable() {
        return this.myEntry != null && ((LibraryOrderEntry)this.myEntry).isValid();
    }

    @Override
    public String getTooltipText() {
        List invalidUrls;
        if (this.myEntry == null) {
            return null;
        }
        Library library = ((LibraryOrderEntry)this.myEntry).getLibrary();
        if (library == null) {
            return null;
        }
        String name = library.getName();
        if (name != null && !(invalidUrls = ((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES)).isEmpty()) {
            return JavaUiBundle.message("project.roots.tooltip.library.has.broken.paths", name, invalidUrls.size());
        }
        List<@NlsSafe String> descriptions = LibraryPresentationManager.getInstance().getDescriptions(library, this.myContext);
        if (descriptions.isEmpty()) {
            return null;
        }
        HtmlBuilder builder = new HtmlBuilder().appendWithSeparators((HtmlChunk)HtmlChunk.br(), (Iterable)ContainerUtil.map(descriptions, HtmlChunk::text));
        return builder.wrapWithHtmlBody().toString();
    }
}

