/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.DynamicBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.ui.LibraryEditorComponent;
import com.intellij.openapi.roots.libraries.ui.LibraryPropertiesEditor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LibraryPropertiesEditorBase<P extends LibraryProperties, T extends LibraryType<P>>
extends LibraryPropertiesEditor {
    protected final Logger logger;
    private boolean myModified;
    private JPanel myMainPanel;
    private JLabel myDescriptionLabel;
    private JButton myEditButton;
    protected JButton myReloadButton;
    protected final LibraryEditorComponent<P> myEditorComponent;
    protected final T myLibraryType;

    protected LibraryPropertiesEditorBase(LibraryEditorComponent<P> editorComponent, T libraryType, @NlsContexts.Button @Nullable String editButtonText) {
        this.$$$setupUI$$$();
        this.logger = Logger.getInstance(((Object)((Object)this)).getClass());
        this.myEditorComponent = editorComponent;
        this.myLibraryType = libraryType;
        this.updateDescription();
        if (editButtonText != null) {
            this.myEditButton.setText(UIUtil.replaceMnemonicAmpersand((String)editButtonText));
        }
        this.myEditButton.setVisible(!this.myEditorComponent.isNewLibrary());
        this.myEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LibraryPropertiesEditorBase.this.edit();
            }
        });
        this.myMainPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)10, (int)5, (int)10));
    }

    protected JPanel getMainPanel() {
        return this.myMainPanel;
    }

    protected void updateDescription() {
        String description = this.myLibraryType.getDescription(this.myEditorComponent.getProperties());
        this.myDescriptionLabel.setText(description);
        this.myDescriptionLabel.setToolTipText(description);
    }

    protected abstract void edit();

    protected void setModified() {
        this.myModified = true;
        this.updateDescription();
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            LibraryPropertiesEditorBase.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    public boolean isModified() {
        return this.myModified;
    }

    public void reset() {
        this.updateDescription();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryPropertiesEditorBase", "createComponent"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JLabel jLabel;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptionLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaUiBundle", LibraryPropertiesEditorBase.class).getString("label.label"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, new Dimension(200, -1), null, null));
        this.myEditButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/JavaUiBundle", LibraryPropertiesEditorBase.class).getString("button.edit3"));
        jPanel.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myReloadButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/JavaUiBundle", LibraryPropertiesEditorBase.class).getString("button.reload"));
        jButton.setToolTipText("");
        ((Component)jButton).setVisible(false);
        jPanel.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

