/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBaseKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u00142\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140(H\u0002J\u0006\u0010)\u001a\u00020\"J\b\u0010*\u001a\u00020\"H\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u0018\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018R!\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u001dj\b\u0012\u0004\u0012\u00020\u0006`\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006."}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ComparingJarFilesTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "project", "Lcom/intellij/openapi/project/Project;", "downloadedFiles", "", "Ljava/io/File;", "libraryFiles", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/util/List;)V", "cancelled", "", "getCancelled", "()Z", "setCancelled", "(Z)V", "filesAreTheSame", "getFilesAreTheSame", "setFilesAreTheSame", "downloadedFileToCompare", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDownloadedFileToCompare", "()Lcom/intellij/openapi/vfs/VirtualFile;", "setDownloadedFileToCompare", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "libraryFileToCompare", "getLibraryFileToCompare", "setLibraryFileToCompare", "filesToDelete", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getFilesToDelete", "()Ljava/util/ArrayList;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "collectNestedJars", "file", "result", "", "deleteTemporaryFiles", "onCancel", "contentEqual", "file1", "file2", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nConvertToRepositoryLibraryActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToRepositoryLibraryActionBase.kt\ncom/intellij/openapi/roots/ui/configuration/projectRoot/ComparingJarFilesTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,309:1\n1915#2,2:310\n1915#2,2:312\n14060#3,2:314\n1#4:316\n60#5,5:317\n60#5,5:322\n*S KotlinDebug\n*F\n+ 1 ConvertToRepositoryLibraryActionBase.kt\ncom/intellij/openapi/roots/ui/configuration/projectRoot/ComparingJarFilesTask\n*L\n221#1:310,2\n224#1:312,2\n247#1:314,2\n264#1:317,5\n265#1:322,5\n*E\n"})
final class ComparingJarFilesTask
extends Task.Modal {
    @NotNull
    private final List<File> downloadedFiles;
    @NotNull
    private final List<File> libraryFiles;
    private boolean cancelled;
    private boolean filesAreTheSame;
    public VirtualFile downloadedFileToCompare;
    public VirtualFile libraryFileToCompare;
    @NotNull
    private final ArrayList<File> filesToDelete;

    public ComparingJarFilesTask(@NotNull Project project2, @NotNull List<? extends File> downloadedFiles2, @NotNull List<? extends File> libraryFiles) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(downloadedFiles2, (String)"downloadedFiles");
        Intrinsics.checkNotNullParameter(libraryFiles, (String)"libraryFiles");
        super(project2, JavaUiBundle.message("task.title.comparing.jar.files", new Object[0]), true);
        this.downloadedFiles = downloadedFiles2;
        this.libraryFiles = libraryFiles;
        this.filesToDelete = new ArrayList();
    }

    public final boolean getCancelled() {
        return this.cancelled;
    }

    public final void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    public final boolean getFilesAreTheSame() {
        return this.filesAreTheSame;
    }

    public final void setFilesAreTheSame(boolean bl) {
        this.filesAreTheSame = bl;
    }

    @NotNull
    public final VirtualFile getDownloadedFileToCompare() {
        VirtualFile virtualFile = this.downloadedFileToCompare;
        if (virtualFile != null) {
            return virtualFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"downloadedFileToCompare");
        return null;
    }

    public final void setDownloadedFileToCompare(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<set-?>");
        this.downloadedFileToCompare = virtualFile;
    }

    @NotNull
    public final VirtualFile getLibraryFileToCompare() {
        VirtualFile virtualFile = this.libraryFileToCompare;
        if (virtualFile != null) {
            return virtualFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"libraryFileToCompare");
        return null;
    }

    public final void setLibraryFileToCompare(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"<set-?>");
        this.libraryFileToCompare = virtualFile;
    }

    @NotNull
    public final ArrayList<File> getFilesToDelete() {
        return this.filesToDelete;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.filesAreTheSame = this.filesAreTheSame();
        if (!this.filesAreTheSame) {
            VirtualFile[] $this$forEach$iv;
            File libraryIoFileToCompare = null;
            File downloadedIoFileToCompare = null;
            if (this.libraryFiles.size() == 1 && this.downloadedFiles.size() == 1) {
                libraryIoFileToCompare = this.libraryFiles.get(0);
                if (Intrinsics.areEqual((Object)this.downloadedFiles.get(0).getName(), (Object)this.libraryFiles.get(0).getName())) {
                    downloadedIoFileToCompare = this.downloadedFiles.get(0);
                } else {
                    File file = FileUtil.createTempDirectory((String)"downloaded_file", (String)"", (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
                    File downloadedFilesIoDir = file;
                    downloadedIoFileToCompare = new File(downloadedFilesIoDir, this.libraryFiles.get(0).getName());
                    FileUtil.copy((File)this.downloadedFiles.get(0), (File)downloadedIoFileToCompare);
                    ((Collection)this.filesToDelete).add(downloadedFilesIoDir);
                }
            } else {
                boolean bl;
                File it;
                File file = FileUtil.createTempDirectory((String)"library_files", (String)"", (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
                libraryIoFileToCompare = file;
                ((Collection)this.filesToDelete).add(libraryIoFileToCompare);
                $this$forEach$iv = (VirtualFile[])this.libraryFiles;
                boolean $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    it = (File)t;
                    bl = false;
                    FileUtil.copy((File)it, (File)new File(libraryIoFileToCompare, it.getName()));
                }
                File file2 = FileUtil.createTempDirectory((String)"downloaded_files", (String)"", (boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempDirectory(...)");
                downloadedIoFileToCompare = file2;
                $this$forEach$iv = this.downloadedFiles;
                $i$f$forEach = false;
                for (Object t : $this$forEach$iv) {
                    it = (File)t;
                    bl = false;
                    FileUtil.copy((File)it, (File)new File(downloadedIoFileToCompare, it.getName()));
                }
                ((Collection)this.filesToDelete).add(downloadedIoFileToCompare);
            }
            WriteAction.computeAndWait(() -> ComparingJarFilesTask.run$lambda$2(this, libraryIoFileToCompare, downloadedIoFileToCompare));
            $this$forEach$iv = new VirtualFile[]{this.getLibraryFileToCompare(), this.getDownloadedFileToCompare()};
            RefreshQueue.Companion.getInstance().refresh(false, false, null, $this$forEach$iv);
            ArrayList jarFilesToRefresh = new ArrayList();
            WriteAction.computeAndWait(() -> ComparingJarFilesTask.run$lambda$3(this, jarFilesToRefresh));
            RefreshQueue.Companion.getInstance().refresh(false, true, null, (Collection)jarFilesToRefresh);
        }
    }

    private final void collectNestedJars(VirtualFile file, List<VirtualFile> result) {
        block3: {
            block2: {
                if (!file.isDirectory()) break block2;
                VirtualFile[] virtualFileArray = file.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                Object[] $this$forEach$iv = virtualFileArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.collectNestedJars(it, result);
                }
                break block3;
            }
            if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)ArchiveFileType.INSTANCE)) break block3;
            String string = VfsUtil.getUrlForLibraryRoot((File)VfsUtil.virtualToIoFile((VirtualFile)file));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrlForLibraryRoot(...)");
            String jarRootUrl = string;
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(jarRootUrl);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                result.add(it);
            }
        }
    }

    public final void deleteTemporaryFiles() {
        FileUtil.asyncDelete((Collection)this.filesToDelete);
    }

    public void onCancel() {
        this.cancelled = true;
    }

    private final boolean filesAreTheSame() {
        Logger logger;
        Logger $this$debug_u24default$iv = ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Downloaded files: " + CollectionsKt.joinToString$default((Iterable)this.downloadedFiles, null, null, null, (int)0, null, ComparingJarFilesTask::filesAreTheSame$lambda$0$0, (int)31, null), t$iv);
        }
        $this$debug_u24default$iv = ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p();
        t$iv = null;
        $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Library files: " + CollectionsKt.joinToString$default((Iterable)this.libraryFiles, null, null, null, (int)0, null, ComparingJarFilesTask::filesAreTheSame$lambda$1$0, (int)31, null), t$iv);
        }
        if (this.downloadedFiles.size() != this.libraryFiles.size()) {
            return false;
        }
        Hash.Strategy<File> contentHashing2 = new Hash.Strategy<File>(this){
            final /* synthetic */ ComparingJarFilesTask this$0;
            {
                this.this$0 = $receiver;
            }

            public int hashCode(File file) {
                File file2 = file;
                return file2 != null ? (int)file2.length() : 0;
            }

            public boolean equals(File o1, File o2) {
                if (o1 == o2) {
                    return true;
                }
                if (o1 == null || o2 == null) {
                    return true;
                }
                boolean equal = ComparingJarFilesTask.access$contentEqual(this.this$0, o1, o2);
                Logger $this$debug_u24default$iv = ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug(" comparing files: " + o1.getAbsolutePath() + (equal ? "==" : "!=") + o2.getAbsolutePath(), t$iv);
                }
                return equal;
            }
        };
        return Intrinsics.areEqual((Object)new ObjectOpenCustomHashSet((Collection)this.downloadedFiles, (Hash.Strategy)contentHashing2), (Object)new ObjectOpenCustomHashSet((Collection)this.libraryFiles, (Hash.Strategy)contentHashing2));
    }

    /*
     * Exception decompiling
     */
    private final boolean contentEqual(File file1, File file2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static final Unit run$lambda$2(ComparingJarFilesTask this$0, File $libraryIoFileToCompare, File $downloadedIoFileToCompare) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile($libraryIoFileToCompare);
        Intrinsics.checkNotNull((Object)virtualFile);
        this$0.setLibraryFileToCompare(virtualFile);
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByIoFile($downloadedIoFileToCompare);
        Intrinsics.checkNotNull((Object)virtualFile2);
        this$0.setDownloadedFileToCompare(virtualFile2);
        return Unit.INSTANCE;
    }

    private static final Unit run$lambda$3(ComparingJarFilesTask this$0, ArrayList $jarFilesToRefresh) {
        this$0.collectNestedJars(this$0.getLibraryFileToCompare(), $jarFilesToRefresh);
        this$0.collectNestedJars(this$0.getDownloadedFileToCompare(), $jarFilesToRefresh);
        return Unit.INSTANCE;
    }

    private static final CharSequence filesAreTheSame$lambda$0$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName() + " (" + it.length() + " bytes)";
    }

    private static final CharSequence filesAreTheSame$lambda$1$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName() + " (" + it.length() + " bytes)";
    }

    public static final /* synthetic */ boolean access$contentEqual(ComparingJarFilesTask $this, File file1, File file2) {
        return $this.contentEqual(file1, file2);
    }
}

