/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ExistingLibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\r0\u0011H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertProjectLibraryToRepositoryLibraryAction;", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase;", "librariesConfigurable", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable;", "context", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "<init>", "(Lcom/intellij/openapi/roots/ui/configuration/projectRoot/BaseLibrariesConfigurable;Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;)V", "getSelectedLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "replaceLibrary", "", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "configureNewLibrary", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditorBase;", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nConvertProjectLibraryToRepositoryLibraryAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertProjectLibraryToRepositoryLibraryAction.kt\ncom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertProjectLibraryToRepositoryLibraryAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1915#2,2:49\n*S KotlinDebug\n*F\n+ 1 ConvertProjectLibraryToRepositoryLibraryAction.kt\ncom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertProjectLibraryToRepositoryLibraryAction\n*L\n42#1:49,2\n*E\n"})
public final class ConvertProjectLibraryToRepositoryLibraryAction
extends ConvertToRepositoryLibraryActionBase {
    @NotNull
    private final BaseLibrariesConfigurable librariesConfigurable;

    public ConvertProjectLibraryToRepositoryLibraryAction(@NotNull BaseLibrariesConfigurable librariesConfigurable, @NotNull StructureConfigurableContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)librariesConfigurable), (String)"librariesConfigurable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.librariesConfigurable = librariesConfigurable;
    }

    @Override
    @Nullable
    protected LibraryEx getSelectedLibrary() {
        ProjectStructureElement projectStructureElement = this.librariesConfigurable.getSelectedElement();
        LibraryProjectStructureElement libraryProjectStructureElement = projectStructureElement instanceof LibraryProjectStructureElement ? (LibraryProjectStructureElement)projectStructureElement : null;
        Library library = libraryProjectStructureElement != null ? libraryProjectStructureElement.getLibrary() : null;
        return library instanceof LibraryEx ? (LibraryEx)library : null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @Override
    protected void replaceLibrary(@NotNull Library library, @NotNull Function1<? super LibraryEditorBase, Unit> configureNewLibrary) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        Intrinsics.checkNotNullParameter(configureNewLibrary, (String)"configureNewLibrary");
        String name = library.getName();
        LibrariesModifiableModel modifiableModel = this.librariesConfigurable.getModelProvider().getModifiableModel();
        Collection<ProjectStructureElementUsage> usages = this.getContext().getDaemonAnalyzer().getUsages(new LibraryProjectStructureElement(this.getContext(), library));
        modifiableModel.removeLibrary(library);
        Library library2 = modifiableModel.createLibrary(name, RepositoryLibraryType.getInstance().getKind(), null);
        Intrinsics.checkNotNullExpressionValue((Object)library2, (String)"createLibrary(...)");
        Library newLibrary = library2;
        Intrinsics.checkNotNull(usages);
        Iterable $this$forEach$iv = usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectStructureElementUsage it = (ProjectStructureElementUsage)element$iv;
            boolean bl = false;
            it.replaceElement(new LibraryProjectStructureElement(this.getContext(), newLibrary));
        }
        ExistingLibraryEditor editor = modifiableModel.getLibraryEditor(newLibrary);
        Intrinsics.checkNotNull((Object)editor);
        configureNewLibrary.invoke((Object)editor);
        this.librariesConfigurable.getProjectStructureConfigurable().selectProjectOrGlobalLibrary(newLibrary, true);
    }
}

