/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ComparingJarFilesTask;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBaseKt;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryJarsDiffDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 $2\u00020\u0001:\u0001$B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\f\u001a\u0004\u0018\u00010\rH$J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J$\u0010 \u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00192\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u000f0\"H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "context", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "<init>", "(Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;)V", "getContext", "()Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSelectedLibrary", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "downloadLibraryAndReplace", "library", "mavenCoordinates", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "changeCoordinatesAndRetry", "detectOrSpecifyMavenCoordinates", "Lcom/intellij/openapi/roots/libraries/Library;", "specifyMavenCoordinates", "detectedCoordinates", "", "replaceByLibrary", "configuration", "Lcom/intellij/openapi/roots/libraries/NewLibraryConfiguration;", "replaceLibrary", "configureNewLibrary", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditorBase;", "Companion", "intellij.java.ui"})
@SourceDebugExtension(value={"SMAP\nConvertToRepositoryLibraryActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToRepositoryLibraryActionBase.kt\ncom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,309:1\n777#2:310\n873#2,2:311\n1586#2:313\n1661#2,3:314\n11705#3:317\n12052#3,3:318\n14060#3,2:321\n*S KotlinDebug\n*F\n+ 1 ConvertToRepositoryLibraryActionBase.kt\ncom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase\n*L\n78#1:310\n78#1:311,2\n78#1:313\n78#1:314,3\n89#1:317\n89#1:318,3\n157#1:321,2\n*E\n"})
public abstract class ConvertToRepositoryLibraryActionBase
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StructureConfigurableContext context;
    @NotNull
    private final Project project;

    public ConvertToRepositoryLibraryActionBase(@NotNull StructureConfigurableContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(JavaUiBundle.messagePointer("action.text.convert.to.repository.library", new Object[0]), JavaUiBundle.messagePointer("action.description.convert.to.repository.library", new Object[0]));
        this.context = context;
        Project project2 = this.context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        this.project = project2;
    }

    @NotNull
    protected final StructureConfigurableContext getContext() {
        return this.context;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Nullable
    protected abstract LibraryEx getSelectedLibrary();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LibraryEx library = this.getSelectedLibrary();
        e.getPresentation().setEnabledAndVisible(library != null && library.getKind() == null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LibraryEx libraryEx = this.getSelectedLibrary();
        if (libraryEx == null) {
            return;
        }
        LibraryEx library = libraryEx;
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.detectOrSpecifyMavenCoordinates((Library)library);
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return;
        }
        JpsMavenRepositoryLibraryDescriptor mavenCoordinates = jpsMavenRepositoryLibraryDescriptor;
        this.downloadLibraryAndReplace(library, mavenCoordinates);
    }

    /*
     * WARNING - void declaration
     */
    private final void downloadLibraryAndReplace(LibraryEx library, JpsMavenRepositoryLibraryDescriptor mavenCoordinates) {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        OrderRoot it;
        void $this$filterTo$iv$iv;
        RepositoryLibraryProperties libraryProperties = new RepositoryLibraryProperties(mavenCoordinates.getGroupId(), mavenCoordinates.getArtifactId(), mavenCoordinates.getVersion(), mavenCoordinates.isIncludeTransitiveDependencies(), mavenCoordinates.getExcludedDependencies());
        boolean hasSources = RepositoryUtils.libraryHasSources((Library)library);
        boolean hasJavadoc = RepositoryUtils.libraryHasJavaDocs((Library)library);
        ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug("Resolving " + mavenCoordinates);
        Collection<OrderRoot> collection = JarRepositoryManager.loadDependenciesModal(this.project, libraryProperties, hasSources, hasJavadoc, null, null);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"loadDependenciesModal(...)");
        Collection<OrderRoot> roots = collection;
        Iterable $this$filter$iv = roots;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (OrderRoot)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)OrderRootType.CLASSES)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (OrderRoot)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(VfsUtilCore.virtualToIoFile((VirtualFile)it.getFile()));
        }
        List downloadedFiles2 = (List)destination$iv$iv;
        if (downloadedFiles2.isEmpty()) {
            if (Messages.showYesNoDialog((String)JavaUiBundle.message("dialog.message.no.files.were.downloaded", new Object[0]), (String)JavaUiBundle.message("dialog.title.no.files.were.downloaded", new Object[0]), null) != 0) {
                return;
            }
            this.changeCoordinatesAndRetry(mavenCoordinates, library);
            return;
        }
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        Object[] $this$map$iv2 = virtualFileArray;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
        boolean $i$f$mapTo2 = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(VfsUtilCore.virtualToIoFile((VirtualFile)it2));
        }
        List libraryFiles = (List)destination$iv$iv2;
        ComparingJarFilesTask task2 = new ComparingJarFilesTask(this.project, downloadedFiles2, libraryFiles);
        task2.queue();
        if (task2.getCancelled()) {
            return;
        }
        if (!task2.getFilesAreTheSame()) {
            VirtualFile virtualFile = task2.getLibraryFileToCompare();
            VirtualFile virtualFile2 = task2.getDownloadedFileToCompare();
            String string = library.getPresentableName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            LibraryJarsDiffDialog dialog = new LibraryJarsDiffDialog(virtualFile, virtualFile2, mavenCoordinates, string, this.project);
            dialog.show();
            task2.deleteTemporaryFiles();
            switch (dialog.getExitCode()) {
                case 1: {
                    return;
                }
                case 2: {
                    this.changeCoordinatesAndRetry(mavenCoordinates, library);
                    return;
                }
            }
        }
        ApplicationManager.getApplication().invokeLater(() -> ConvertToRepositoryLibraryActionBase.downloadLibraryAndReplace$lambda$3(this, library, libraryProperties, roots));
    }

    private final void changeCoordinatesAndRetry(JpsMavenRepositoryLibraryDescriptor mavenCoordinates, LibraryEx library) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.specifyMavenCoordinates(CollectionsKt.listOf((Object)mavenCoordinates));
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return;
        }
        JpsMavenRepositoryLibraryDescriptor coordinates = jpsMavenRepositoryLibraryDescriptor;
        ApplicationManager.getApplication().invokeLater(() -> ConvertToRepositoryLibraryActionBase.changeCoordinatesAndRetry$lambda$0(this, library, coordinates));
    }

    private final JpsMavenRepositoryLibraryDescriptor detectOrSpecifyMavenCoordinates(Library library) {
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        List<JpsMavenRepositoryLibraryDescriptor> detectedCoordinates = Companion.detectMavenCoordinates(virtualFileArray);
        ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug("Maven coordinates for " + library.getPresentableName() + " JARs: " + detectedCoordinates);
        if (detectedCoordinates.size() == 1) {
            return detectedCoordinates.get(0);
        }
        String string = detectedCoordinates.isEmpty() ? JavaUiBundle.message("dialog.message.cannot.detect.maven.coordinates", new Object[0]) : JavaUiBundle.message("dialog.message.multiple.maven.coordinates", new Object[0]);
        Intrinsics.checkNotNull((Object)string);
        String message = string;
        if (Messages.showYesNoDialog((Project)this.project, (String)(message + ". " + JavaUiBundle.message("dialog.message.do.you.want", new Object[0])), (String)JavaUiBundle.message("dialog.title.cannot.detect.maven.coordinates", new Object[0]), null) != 0) {
            return null;
        }
        return this.specifyMavenCoordinates(detectedCoordinates);
    }

    private final JpsMavenRepositoryLibraryDescriptor specifyMavenCoordinates(List<? extends JpsMavenRepositoryLibraryDescriptor> detectedCoordinates) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = (JpsMavenRepositoryLibraryDescriptor)CollectionsKt.firstOrNull(detectedCoordinates);
        RepositoryAttachDialog dialog = new RepositoryAttachDialog(this.project, jpsMavenRepositoryLibraryDescriptor != null ? jpsMavenRepositoryLibraryDescriptor.getMavenId() : null, RepositoryAttachDialog.Mode.SEARCH);
        if (!dialog.showAndGet()) {
            return null;
        }
        return dialog.getSelectedLibraryDescriptor();
    }

    private final void replaceByLibrary(Library library, NewLibraryConfiguration configuration) {
        String[] stringArray = library.getUrls(AnnotationOrderRootType.getInstance());
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getUrls(...)");
        String[] annotationUrls = stringArray;
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getFiles(...)");
        Object[] objectArray = virtualFileArray;
        VirtualFile[] virtualFileArray2 = library.getFiles(OrderRootType.SOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray2, (String)"getFiles(...)");
        Object[] libraryRoots = (VirtualFile[])ArraysKt.plus((Object[])objectArray, (Object[])virtualFileArray2);
        this.context.getModulesConfigurator().getProjectStructureConfigurable().registerObsoleteLibraryRoots(ArraysKt.asList((Object[])libraryRoots));
        this.replaceLibrary(library, (Function1<? super LibraryEditorBase, Unit>)((Function1)arg_0 -> ConvertToRepositoryLibraryActionBase.replaceByLibrary$lambda$0(configuration, annotationUrls, arg_0)));
    }

    protected abstract void replaceLibrary(@NotNull Library var1, @NotNull Function1<? super LibraryEditorBase, Unit> var2);

    private static final void downloadLibraryAndReplace$lambda$3(ConvertToRepositoryLibraryActionBase this$0, LibraryEx $library, RepositoryLibraryProperties $libraryProperties, Collection $roots) {
        Library library = (Library)$library;
        String string = $library.getName();
        if (string == null) {
            string = "";
        }
        String string2 = string;
        RepositoryLibraryType repositoryLibraryType = RepositoryLibraryType.getInstance();
        this$0.replaceByLibrary(library, new NewLibraryConfiguration($libraryProperties, $roots, string2, repositoryLibraryType){
            final /* synthetic */ Collection<OrderRoot> $roots;
            {
                this.$roots = $roots;
                super($super_call_param$1, (LibraryType)$super_call_param$2, (LibraryProperties)$libraryProperties);
            }

            public void addRoots(LibraryEditor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                editor.addRoots(this.$roots);
            }
        });
    }

    private static final void changeCoordinatesAndRetry$lambda$0(ConvertToRepositoryLibraryActionBase this$0, LibraryEx $library, JpsMavenRepositoryLibraryDescriptor $coordinates) {
        this$0.downloadLibraryAndReplace($library, $coordinates);
    }

    private static final Unit replaceByLibrary$lambda$0(NewLibraryConfiguration $configuration, String[] $annotationUrls, LibraryEditorBase editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.setProperties($configuration.getProperties());
        editor.removeAllRoots();
        $configuration.addRoots((LibraryEditor)editor);
        String[] $this$forEach$iv = $annotationUrls;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            editor.addRoot(it, AnnotationOrderRootType.getInstance());
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase$Companion;", "", "<init>", "()V", "detectMavenCoordinates", "", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "libraryRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/List;", "parsePomProperties", "virtualFile", "intellij.java.ui"})
    @SourceDebugExtension(value={"SMAP\nConvertToRepositoryLibraryActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToRepositoryLibraryActionBase.kt\ncom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n10574#2:310\n11007#2,2:311\n10574#2:313\n11007#2,2:314\n12033#2,10:316\n14060#2:326\n14061#2:328\n12043#2:329\n11009#2,3:330\n11009#2,3:347\n1#3:327\n1#3:344\n1#3:350\n1642#4,10:333\n1915#4:343\n1916#4:345\n1652#4:346\n*S KotlinDebug\n*F\n+ 1 ConvertToRepositoryLibraryActionBase.kt\ncom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase$Companion\n*L\n165#1:310\n165#1:311,2\n166#1:313\n166#1:314,2\n167#1:316,10\n167#1:326\n167#1:328\n167#1:329\n166#1:330,3\n165#1:347,3\n167#1:327\n171#1:344\n171#1:333,10\n171#1:343\n171#1:345\n171#1:346\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<JpsMavenRepositoryLibraryDescriptor> detectMavenCoordinates(@NotNull VirtualFile[] libraryRoots) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)libraryRoots, (String)"libraryRoots");
            VirtualFile[] $this$flatMap$iv = libraryRoots;
            boolean $i$f$flatMap = false;
            VirtualFile[] virtualFileArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void $this$mapNotNullTo$iv$iv;
                List list2;
                void element$iv$iv;
                void root = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                VirtualFile[] virtualFileArray2 = root.findFileByRelativePath("META-INF/maven");
                if (virtualFileArray2 != null && (virtualFileArray2 = virtualFileArray2.getChildren()) != null) {
                    void $this$flatMapTo$iv$iv2;
                    VirtualFile[] $this$flatMap$iv2 = virtualFileArray2;
                    boolean $i$f$flatMap2 = false;
                    VirtualFile[] virtualFileArray3 = $this$flatMap$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$flatMapTo2 = false;
                    int n2 = ((void)$this$flatMapTo$iv$iv2).length;
                    for (int j = 0; j < n2; ++j) {
                        List list3;
                        void element$iv$iv2;
                        void groupDir = element$iv$iv2 = $this$flatMapTo$iv$iv2[j];
                        boolean bl2 = false;
                        if (groupDir.getChildren() != null) {
                            void $this$mapNotNullTo$iv$iv2;
                            VirtualFile[] $this$mapNotNull$iv;
                            boolean $i$f$mapNotNull = false;
                            VirtualFile[] virtualFileArray4 = $this$mapNotNull$iv;
                            Collection destination$iv$iv3 = new ArrayList();
                            boolean $i$f$mapNotNullTo = false;
                            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                            boolean $i$f$forEach = false;
                            int n3 = ((void)$this$forEach$iv$iv$iv).length;
                            for (int k = 0; k < n3; ++k) {
                                VirtualFile it$iv$iv;
                                void element$iv$iv$iv;
                                void element$iv$iv3 = element$iv$iv$iv = $this$forEach$iv$iv$iv[k];
                                boolean bl3 = false;
                                void artifactDir = element$iv$iv3;
                                boolean bl4 = false;
                                if (artifactDir.findChild("pom.properties") == null) continue;
                                boolean bl5 = false;
                                destination$iv$iv3.add(it$iv$iv);
                            }
                            list3 = (List)destination$iv$iv3;
                        } else {
                            list3 = CollectionsKt.emptyList();
                        }
                        Iterable list$iv$iv = list3;
                        CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                    }
                    list2 = (List)destination$iv$iv2;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                List pomPropertiesFiles = list2;
                Iterable $this$mapNotNull$iv = pomPropertiesFiles;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv4 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    JpsMavenRepositoryLibraryDescriptor it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv4 = element$iv$iv$iv = iterator.next();
                    boolean bl6 = false;
                    VirtualFile it = (VirtualFile)element$iv$iv4;
                    boolean bl7 = false;
                    if (Companion.parsePomProperties(it) == null) continue;
                    boolean bl8 = false;
                    destination$iv$iv4.add(it$iv$iv);
                }
                Iterable list$iv$iv = (List)destination$iv$iv4;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final JpsMavenRepositoryLibraryDescriptor parsePomProperties(VirtualFile virtualFile) {
            Properties properties = new Properties();
            try {
                Closeable closeable = virtualFile.getInputStream();
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    properties.load(it);
                    it = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                return null;
            }
            String groupId = properties.getProperty("groupId");
            String artifactId = properties.getProperty("artifactId");
            String version = properties.getProperty("version");
            return groupId != null && artifactId != null && version != null ? new JpsMavenRepositoryLibraryDescriptor(groupId, artifactId, version) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

