/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.DynamicBundle;
import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SimpleListCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ProjectFormatPanel {
    private static final String STORAGE_FORMAT_PROPERTY = "default.storage.format";
    private JComboBox<StorageFormat> myStorageFormatCombo;
    private JPanel myWholePanel;

    public ProjectFormatPanel() {
        this.$$$setupUI$$$();
        this.myStorageFormatCombo.insertItemAt(StorageFormat.DIR_BASED, 0);
        this.myStorageFormatCombo.insertItemAt(StorageFormat.FILE_BASED, 1);
        PropertiesComponent instance = PropertiesComponent.getInstance();
        String savedValue = instance.getValue(STORAGE_FORMAT_PROPERTY, StorageFormat.DIR_BASED.getTag());
        this.myStorageFormatCombo.setSelectedItem(StorageFormat.of(savedValue));
        SimpleListCellRenderer renderer = SimpleListCellRenderer.create((String)StorageFormat.FILE_BASED.getTitle(), LocalizationAware::getTitle);
        this.myStorageFormatCombo.setRenderer((ListCellRenderer<StorageFormat>)renderer);
    }

    public JPanel getPanel() {
        return this.myWholePanel;
    }

    @NotNull
    public JComboBox<StorageFormat> getStorageFormatComboBox() {
        JComboBox<StorageFormat> jComboBox = this.myStorageFormatCombo;
        if (jComboBox == null) {
            ProjectFormatPanel.$$$reportNull$$$0(0);
        }
        return jComboBox;
    }

    public void updateData(@NotNull WizardContext context) {
        if (context == null) {
            ProjectFormatPanel.$$$reportNull$$$0(1);
        }
        StorageScheme format = this.isDefault() ? StorageScheme.DEFAULT : StorageScheme.DIRECTORY_BASED;
        context.setProjectStorageFormat(format);
        StorageFormat storageFormat = StorageFormat.of(format);
        PropertiesComponent instance = PropertiesComponent.getInstance();
        instance.setValue(STORAGE_FORMAT_PROPERTY, storageFormat.getTag(), StorageFormat.DIR_BASED.getTag());
    }

    public void setVisible(boolean visible) {
        this.myWholePanel.setVisible(visible);
    }

    public boolean isDefault() {
        StorageFormat selectedItem = (StorageFormat)this.myStorageFormatCombo.getSelectedItem();
        return StorageFormat.isDefault(selectedItem);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/projectImport/ProjectFormatPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageFormatComboBox";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/projectImport/ProjectFormatPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JavaUiBundle", ProjectFormatPanel.class).getString("label.project.format1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JComboBox jComboBox = new JComboBox();
        this.myStorageFormatCombo = jComboBox;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets = new Insets(5, 0, 0, 0);
        jPanel.add(jComboBox, gridBagConstraints2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    public static enum StorageFormat implements LocalizationAware
    {
        DIR_BASED(".idea (directory based)"){

            @Override
            public String getTitle() {
                return JavaUiBundle.message("label.directory.based", ".idea");
            }
        }
        ,
        FILE_BASED(".ipr (file based)"){

            @Override
            public String getTitle() {
                return JavaUiBundle.message("label.ipr.file.based", new Object[0]);
            }
        };

        private final String myTag;

        private StorageFormat(String tag) {
            this.myTag = tag;
        }

        String getTag() {
            return this.myTag;
        }

        @NotNull
        private static StorageFormat of(@NotNull String tag) {
            if (tag == null) {
                StorageFormat.$$$reportNull$$$0(0);
            }
            if (DIR_BASED.getTag().equals(tag)) {
                StorageFormat storageFormat = DIR_BASED;
                if (storageFormat == null) {
                    StorageFormat.$$$reportNull$$$0(1);
                }
                return storageFormat;
            }
            StorageFormat storageFormat = FILE_BASED;
            if (storageFormat == null) {
                StorageFormat.$$$reportNull$$$0(2);
            }
            return storageFormat;
        }

        @NotNull
        private static StorageFormat of(@NotNull StorageScheme id) {
            if (id == null) {
                StorageFormat.$$$reportNull$$$0(3);
            }
            StorageFormat storageFormat = switch (id) {
                default -> throw new MatchException(null, null);
                case StorageScheme.DIRECTORY_BASED -> DIR_BASED;
                case StorageScheme.DEFAULT -> FILE_BASED;
            };
            if (storageFormat == null) {
                StorageFormat.$$$reportNull$$$0(4);
            }
            return storageFormat;
        }

        public static boolean isDefault(StorageFormat storageFormat) {
            return FILE_BASED == storageFormat;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/projectImport/ProjectFormatPanel$StorageFormat";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/projectImport/ProjectFormatPanel$StorageFormat";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 4 -> new IllegalStateException(string);
            };
        }
    }

    private static interface LocalizationAware {
        @NlsContexts.Label
        public String getTitle();
    }
}

