/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.descriptors.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.descriptors.ConfigFileContainer;
import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileInfoSet;
import com.intellij.util.descriptors.ConfigFileListener;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileMetaDataProvider;
import com.intellij.util.descriptors.impl.ConfigFileImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConfigFileContainerImpl
extends SimpleModificationTracker
implements ConfigFileContainer {
    private final Project project;
    private final EventDispatcher<ConfigFileListener> myDispatcher;
    private final MultiMap<ConfigFileMetaData, ConfigFile> configFiles;
    private List<ConfigFile> myCachedConfigFiles;
    private final ConfigFileMetaDataProvider metaDataProvider;
    private final ConfigFileInfoSet configuration;

    public ConfigFileContainerImpl(@NotNull Project project2, @NotNull ConfigFileMetaDataProvider descriptorMetaDataProvider, @NotNull ConfigFileInfoSet configuration) {
        if (project2 == null) {
            ConfigFileContainerImpl.$$$reportNull$$$0(0);
        }
        if (descriptorMetaDataProvider == null) {
            ConfigFileContainerImpl.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            ConfigFileContainerImpl.$$$reportNull$$$0(2);
        }
        this.myDispatcher = EventDispatcher.create(ConfigFileListener.class);
        this.configFiles = new MultiMap();
        this.configuration = configuration;
        this.metaDataProvider = descriptorMetaDataProvider;
        this.project = project2;
        this.configuration.setContainer((ConfigFileContainer)this);
    }

    void fileChanged(VirtualFile file) {
        for (ConfigFile descriptor : this.configFiles.values()) {
            VirtualFile virtualFile = descriptor.getVirtualFile();
            if (virtualFile == null || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)virtualFile, (boolean)false)) continue;
            this.configuration.updateConfigFile(descriptor);
            this.fireDescriptorChanged(descriptor);
        }
    }

    @Nullable
    public ConfigFile getConfigFile(ConfigFileMetaData metaData) {
        return (ConfigFile)ContainerUtil.getFirstItem((Collection)this.configFiles.get((Object)metaData));
    }

    public List<ConfigFile> getConfigFiles() {
        List<Object> result = this.myCachedConfigFiles;
        if (result == null) {
            this.myCachedConfigFiles = result = List.copyOf(this.configFiles.values());
        }
        return result;
    }

    public Project getProject() {
        return this.project;
    }

    public void addListener(ConfigFileListener listener, Disposable parentDisposable) {
        this.myDispatcher.addListener((EventListener)listener, parentDisposable);
    }

    void fireDescriptorChanged(@NotNull ConfigFile descriptor) {
        if (descriptor == null) {
            ConfigFileContainerImpl.$$$reportNull$$$0(3);
        }
        this.incModificationCount();
        ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileChanged(descriptor);
    }

    public ConfigFileInfoSet getConfiguration() {
        return this.configuration;
    }

    public void dispose() {
    }

    public void addListener(ConfigFileListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(ConfigFileListener listener) {
        this.myDispatcher.removeListener((EventListener)listener);
    }

    public ConfigFileMetaDataProvider getMetaDataProvider() {
        return this.metaDataProvider;
    }

    public void updateDescriptors(@NotNull MultiMap<ConfigFileMetaData, ConfigFileInfo> descriptorMap) {
        if (descriptorMap == null) {
            ConfigFileContainerImpl.$$$reportNull$$$0(4);
        }
        HashSet toDelete = this.configFiles.isEmpty() ? Collections.emptySet() : new HashSet(this.configFiles.values());
        HashSet<ConfigFileImpl> added = null;
        for (Map.Entry entry : descriptorMap.entrySet()) {
            ConfigFileMetaData metaData = (ConfigFileMetaData)entry.getKey();
            HashSet newDescriptors = new HashSet((Collection)entry.getValue());
            if (this.configFiles.containsKey((Object)metaData)) {
                for (ConfigFile descriptor : this.configFiles.get((Object)metaData)) {
                    if (!newDescriptors.remove(descriptor.getInfo()) || toDelete.isEmpty()) continue;
                    toDelete.remove(descriptor);
                }
            }
            for (ConfigFileInfo configuration : newDescriptors) {
                ConfigFileImpl configFile = new ConfigFileImpl(this, configuration);
                Disposer.register((Disposable)this, (Disposable)configFile);
                this.configFiles.putValue((Object)metaData, (Object)configFile);
                if (added == null) {
                    added = new HashSet<ConfigFileImpl>();
                }
                added.add(configFile);
            }
        }
        for (ConfigFile configFile : toDelete) {
            this.configFiles.remove((Object)configFile.getMetaData(), (Object)configFile);
            Disposer.dispose((Disposable)configFile);
        }
        this.myCachedConfigFiles = null;
        if (added != null) {
            for (ConfigFile configFile : added) {
                this.incModificationCount();
                ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileAdded(configFile);
            }
        }
        for (ConfigFile configFile : toDelete) {
            this.incModificationCount();
            ((ConfigFileListener)this.myDispatcher.getMulticaster()).configFileRemoved(configFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorMetaDataProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptorMap";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/descriptors/impl/ConfigFileContainerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fireDescriptorChanged";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateDescriptors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

