/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

class RepositoryLibraryResolveErrorNotification
extends Notification {
    private final List<String> myErrors = new ArrayList<String>();

    RepositoryLibraryResolveErrorNotification() {
        super(JarRepositoryManager.getNotificationGroup().getDisplayId(), JavaUiBundle.message("notification.title.repository.library.synchronization", new Object[0]), "", NotificationType.ERROR);
    }

    void addLibraryResolveError(@NotNull RepositoryLibraryProperties lib) {
        if (lib == null) {
            RepositoryLibraryResolveErrorNotification.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.assertEventDispatchThread();
        this.myErrors.add(lib.getMavenId());
        int limit = 10;
        String message = this.myErrors.size() < limit ? JavaUiBundle.message("notification.content.no.files.were.downloaded", StringUtil.join(this.myErrors, (String)", ")) : JavaUiBundle.message("notification.content.no.files.were.downloaded.multiple", StringUtil.join((Collection)ContainerUtil.getFirstItems(this.myErrors, (int)limit), (String)", "), this.myErrors.size() - limit);
        this.setContent(message);
        this.expire();
        Notifications.Bus.notify((Notification)this);
    }

    static synchronized void showOrUpdate(@NotNull RepositoryLibraryProperties libWithError, @NotNull Project project2) {
        RepositoryLibraryResolveErrorNotification notification;
        if (libWithError == null) {
            RepositoryLibraryResolveErrorNotification.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            RepositoryLibraryResolveErrorNotification.$$$reportNull$$$0(2);
        }
        ThreadingAssertions.assertEventDispatchThread();
        RepositoryLibraryResolveErrorNotification[] notifications = (RepositoryLibraryResolveErrorNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(RepositoryLibraryResolveErrorNotification.class, project2);
        RepositoryLibraryResolveErrorNotification repositoryLibraryResolveErrorNotification = notification = notifications.length > 0 ? notifications[0] : null;
        if (notification == null) {
            notification = new RepositoryLibraryResolveErrorNotification();
        }
        notification.addLibraryResolveError(libWithError);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lib";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libWithError";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryResolveErrorNotification";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibraryResolveError";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showOrUpdate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

