/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.buildView.frontend;

import com.intellij.build.BuildContent;
import com.intellij.build.BuildContentId;
import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildId;
import com.intellij.build.BuildNotification;
import com.intellij.build.BuildViewEvent;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.ActivityTracker;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.buildView.BuildDataKeys;
import com.intellij.platform.buildView.BuildViewApi;
import com.intellij.platform.buildView.frontend.BuildTreeView;
import com.intellij.platform.buildView.frontend.FrontendBuildView;
import com.intellij.platform.buildView.frontend.FrontendMultipleBuildsView;
import com.intellij.platform.buildView.frontend.FrontendMultipleBuildsViewKt;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.Side;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.lang.invoke.LambdaMetafactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 B2\u00020\u0001:\u0005BCDEFB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0018H\u0002J\u0016\u0010(\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00140\u00140\u001cH\u0002J\b\u0010)\u001a\u00020*H\u0002J\u0018\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020$H\u0002J\u0006\u0010.\u001a\u00020&J\r\u0010/\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002J\b\u00100\u001a\u00020&H\u0002J\u0012\u00101\u001a\u00020&2\b\u00102\u001a\u0004\u0018\u00010\u0016H\u0002J\u000e\u00103\u001a\u00020&2\u0006\u00104\u001a\u000205J\u0010\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020$H\u0002J\b\u00108\u001a\u00020&H\u0002J\r\u00109\u001a\u00020$H\u0000\u00a2\u0006\u0002\b:J\r\u0010;\u001a\u00020$H\u0000\u00a2\u0006\u0002\b<J\r\u0010=\u001a\u00020$H\u0000\u00a2\u0006\u0002\b>J\u0016\u0010?\u001a\u00020&2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000f0AH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00140\u00140\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010 \u001a\u00060!R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "buildContent", "Lcom/intellij/build/BuildContent;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/build/BuildContent;Lkotlinx/coroutines/CoroutineScope;)V", "buildContentManager", "Lcom/intellij/build/BuildContentManagerImpl;", "id", "Lcom/intellij/build/BuildContentId;", "name", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "buildMap", "", "Lcom/intellij/build/BuildId;", "Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView$FrontendBuildInfo;", "viewMap", "Lcom/intellij/platform/buildView/frontend/FrontendBuildView;", "threeComponentsSplitter", "Lcom/intellij/ui/OnePixelSplitter;", "buildListModel", "Ljavax/swing/DefaultListModel;", "buildList", "Lcom/intellij/ui/components/JBList;", "kotlin.jvm.PlatformType", "content", "Lcom/intellij/ui/content/Content;", "focusWatcher", "Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView$FocusWatcher;", "activeView", "locked", "", "dispose", "", "createSplitter", "createList", "createContentUI", "Ljavax/swing/JComponent;", "createContent", "contentId", "pinned", "lockContent", "getLockedTabName", "updateBuildsListRowHeight", "setActiveView", "view", "handleEvent", "event", "Lcom/intellij/build/BuildViewEvent;", "setBuildListVisible", "visible", "refreshBuildList", "isPinnable", "isPinnable$intellij_platform_buildView_frontend", "isPinned", "isPinned$intellij_platform_buildView_frontend", "togglePinned", "togglePinned$intellij_platform_buildView_frontend", "log", "messageProvider", "Lkotlin/Function0;", "Companion", "FocusWatcher", "MultipleBuildsPanel", "MyCellRenderer", "FrontendBuildInfo", "intellij.platform.buildView.frontend"})
@SourceDebugExtension(value={"SMAP\nFrontendMultipleBuildsView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendMultipleBuildsView.kt\ncom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,476:1\n2469#2,14:477\n1#3:491\n*S KotlinDebug\n*F\n+ 1 FrontendMultipleBuildsView.kt\ncom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView\n*L\n181#1:477,14\n*E\n"})
public final class FrontendMultipleBuildsView
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final BuildContentManagerImpl buildContentManager;
    @NotNull
    private final BuildContentId id;
    @NotNull
    private final String name;
    @NotNull
    private final Map<BuildId, FrontendBuildInfo> buildMap;
    @NotNull
    private final Map<FrontendBuildInfo, FrontendBuildView> viewMap;
    @NotNull
    private final OnePixelSplitter threeComponentsSplitter;
    @NotNull
    private final DefaultListModel<FrontendBuildInfo> buildListModel;
    @NotNull
    private final JBList<FrontendBuildInfo> buildList;
    @NotNull
    private final Content content;
    @NotNull
    private final FocusWatcher focusWatcher;
    @Nullable
    private FrontendBuildView activeView;
    private boolean locked;
    @NotNull
    private static final DataKey<FrontendMultipleBuildsView> DATA_KEY = DataKey.Companion.create("FrontendMultipleBuildsView");

    public FrontendMultipleBuildsView(@NotNull Project project, @NotNull BuildContent buildContent, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildContent, (String)"buildContent");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        BuildContentManager buildContentManager = BuildContentManager.getInstance((Project)this.project);
        Intrinsics.checkNotNull((Object)buildContentManager, (String)"null cannot be cast to non-null type com.intellij.build.BuildContentManagerImpl");
        this.buildContentManager = (BuildContentManagerImpl)buildContentManager;
        this.id = buildContent.getId();
        this.name = buildContent.getName();
        this.buildMap = new LinkedHashMap();
        this.viewMap = new LinkedHashMap();
        this.threeComponentsSplitter = this.createSplitter();
        this.buildListModel = new DefaultListModel();
        this.buildList = this.createList();
        this.content = this.createContent(this.id, buildContent.isPinned());
        this.focusWatcher = new FocusWatcher();
        this.updateBuildsListRowHeight();
        this.focusWatcher.install();
        this.buildContentManager.addContent(this.content);
    }

    public void dispose() {
        this.log((Function0<String>)((Function0)FrontendMultipleBuildsView::dispose$lambda$0));
        this.focusWatcher.uninstall();
    }

    private final OnePixelSplitter createSplitter() {
        OnePixelSplitter onePixelSplitter;
        OnePixelSplitter it = onePixelSplitter = new OnePixelSplitter("MultipleBuildsView.Splitter.Proportion", 0.25f);
        boolean bl = false;
        if (ExperimentalUI.Companion.isNewUI()) {
            ScrollableContentBorder.Companion.setup((JComponent)it, Side.LEFT);
        }
        return onePixelSplitter;
    }

    private final JBList<FrontendBuildInfo> createList() {
        JBList jBList;
        JBList $this$createList_u24lambda_u240 = jBList = new JBList((ListModel)this.buildListModel);
        boolean bl = false;
        $this$createList_u24lambda_u240.installCellRenderer((Function)new MyCellRenderer());
        $this$createList_u24lambda_u240.putClientProperty((Object)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        $this$createList_u24lambda_u240.setSelectionMode(0);
        $this$createList_u24lambda_u240.addListSelectionListener(arg_0 -> FrontendMultipleBuildsView.createList$lambda$0$0($this$createList_u24lambda_u240, this, arg_0));
        return jBList;
    }

    private final JComponent createContentUI() {
        MultipleBuildsPanel consoleComponent = new MultipleBuildsPanel();
        consoleComponent.add((Component)this.threeComponentsSplitter, "Center");
        AnAction anAction = ActionManager.getInstance().getAction("BuildViewToolbar");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("BuildView", actionGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar tb = actionToolbar;
        tb.setTargetComponent((JComponent)consoleComponent);
        if (!ExperimentalUI.Companion.isNewUI()) {
            tb.getComponent().setBorder(JBUI.Borders.merge((Border)tb.getComponent().getBorder(), (Border)JBUI.Borders.customLine((Color)OnePixelDivider.BACKGROUND, (int)0, (int)0, (int)0, (int)1), (boolean)true));
        }
        consoleComponent.add((Component)tb.getComponent(), "West");
        return consoleComponent;
    }

    private final Content createContent(BuildContentId contentId, boolean pinned) {
        this.log((Function0<String>)((Function0)() -> FrontendMultipleBuildsView.createContent$lambda$0(pinned)));
        JComponent jComponent = this.createContentUI();
        String string = this.name;
        ContentImpl content2 = new ContentImpl(this, contentId, jComponent, string){
            final /* synthetic */ FrontendMultipleBuildsView this$0;
            final /* synthetic */ BuildContentId $contentId;
            {
                this.this$0 = $receiver;
                this.$contentId = $contentId;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void dispose() {
                FrontendMultipleBuildsView.access$log(this.this$0, createContent.content.1::dispose$lambda$0);
                super.dispose();
                Disposer.dispose((Disposable)this.this$0);
                BuildersKt.launch$default((CoroutineScope)FrontendMultipleBuildsView.access$getScope$p(this.this$0), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$contentId, null){
                    int label;
                    final /* synthetic */ BuildContentId $contentId;
                    {
                        this.$contentId = $contentId;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = BuildViewApi.Companion.getInstance((Continuation)this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.label = 2;
                                v1 = ((BuildViewApi)v0).disposeBuildContent(this.$contentId, (Continuation)this);
                                if (v1 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl21
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl21:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            private static final String dispose$lambda$0() {
                return "Content disposed";
            }
        };
        if (pinned) {
            content2.setPinned(true);
        }
        content2.addPropertyChangeListener(arg_0 -> FrontendMultipleBuildsView.createContent$lambda$1(this, contentId, arg_0));
        return (Content)content2;
    }

    public final void lockContent() {
        String tabName = this.getLockedTabName();
        this.log((Function0<String>)((Function0)() -> FrontendMultipleBuildsView.lockContent$lambda$0(tabName)));
        this.content.setPinned(true);
        this.content.setPinnable(false);
        if (this.content.getIcon() == null) {
            this.content.setIcon(EmptyIcon.ICON_8);
        }
        this.content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        this.buildContentManager.updateTabDisplayName(this.content, tabName);
        this.locked = true;
    }

    private final String getLockedTabName() {
        Object v0;
        Iterable $this$minByOrNull$iv = this.viewMap.keySet();
        boolean $i$f$minByOrNull2 = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                FrontendBuildInfo it = (FrontendBuildInfo)minElem$iv;
                boolean bl = false;
                long minValue$iv = it.getStartTime();
                do {
                    Object e$iv = iterator$iv.next();
                    FrontendBuildInfo it2 = (FrontendBuildInfo)e$iv;
                    $i$a$-minByOrNull-FrontendMultipleBuildsView$getLockedTabName$buildInfo$1 = false;
                    long v$iv = it2.getStartTime();
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        FrontendBuildInfo buildInfo = v0;
        if (buildInfo != null) {
            char[] $i$f$minByOrNull2 = new char[]{' '};
            String viewName = (String)StringsKt.split$default((CharSequence)this.name, (char[])$i$f$minByOrNull2, (boolean)false, (int)0, (int)6, null).get(0);
            String titleWithoutPrefix = StringsKt.removePrefix((String)buildInfo.getTitle(), (CharSequence)viewName);
            String tabName = viewName + ": " + titleWithoutPrefix;
            if (this.viewMap.size() > 1) {
                Object[] objectArray = new Object[]{tabName, this.viewMap.size() - 1};
                String string = LangBundle.message((String)"tab.title.more", (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
            return tabName;
        }
        return this.name;
    }

    private final void updateBuildsListRowHeight() {
        this.buildList.setFixedCellHeight(JBUI.scale((int)40));
    }

    private final void setActiveView(FrontendBuildView view) {
        if (this.activeView == view) {
            return;
        }
        this.activeView = view;
        ActivityTracker.getInstance().inc();
        if (view == null) {
            this.threeComponentsSplitter.setSecondComponent(null);
            this.content.setPreferredFocusableComponent(null);
        } else {
            this.threeComponentsSplitter.setSecondComponent((JComponent)view);
            this.content.setPreferredFocusableComponent((JComponent)view);
            if (this.focusWatcher.getFocused()) {
                view.requestFocusInWindow();
            }
        }
    }

    public final void handleEvent(@NotNull BuildViewEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BuildViewEvent buildViewEvent = event;
        if (buildViewEvent instanceof BuildViewEvent.BuildStarted) {
            FrontendBuildInfo info = new FrontendBuildInfo((BuildViewEvent.BuildStarted)event);
            this.buildMap.put(((BuildViewEvent.BuildStarted)event).getBuildId(), info);
            this.buildListModel.addElement(info);
            FrontendBuildView buildView = new FrontendBuildView(this.project, this.scope, ((BuildViewEvent.BuildStarted)event).getBuildId(), ((BuildViewEvent.BuildStarted)event).getTreeViewId(), ((BuildViewEvent.BuildStarted)event).getConsoleComponent());
            this.viewMap.put(info, buildView);
            Disposer.register((Disposable)this, (Disposable)buildView);
            if (this.activeView == null) {
                this.log((Function0<String>)((Function0)() -> FrontendMultipleBuildsView.handleEvent$lambda$0(info)));
                this.setActiveView(buildView);
            }
            if (this.buildListModel.getSize() == 2) {
                this.buildList.setSelectedIndex(0);
                this.setBuildListVisible(true);
            }
            this.buildContentManager.startBuildNotified((BuildDescriptor)info, this.content, null);
            this.buildContentManager.setSelectedContent(this.content, ((BuildViewEvent.BuildStarted)event).getRequestFocus(), ((BuildViewEvent.BuildStarted)event).getRequestFocus(), ((BuildViewEvent.BuildStarted)event).getActivateToolWindow(), () -> FrontendMultipleBuildsView.handleEvent$lambda$1(this, event, info));
        } else if (buildViewEvent instanceof BuildViewEvent.BuildSelected) {
            FrontendBuildInfo frontendBuildInfo = this.buildMap.get(((BuildViewEvent.BuildSelected)event).getBuildId());
            if (frontendBuildInfo == null) {
                return;
            }
            FrontendBuildInfo info = frontendBuildInfo;
            this.buildList.setSelectedValue((Object)info, false);
        } else if (buildViewEvent instanceof BuildViewEvent.BuildStatusChanged) {
            FrontendBuildInfo frontendBuildInfo = this.buildMap.get(((BuildViewEvent.BuildStatusChanged)event).getBuildId());
            if (frontendBuildInfo == null) {
                return;
            }
            FrontendBuildInfo info = frontendBuildInfo;
            info.setStatusMessage(((BuildViewEvent.BuildStatusChanged)event).getMessage());
            this.refreshBuildList();
        } else if (buildViewEvent instanceof BuildViewEvent.BuildFinished) {
            FrontendBuildInfo frontendBuildInfo = this.buildMap.get(((BuildViewEvent.BuildFinished)event).getBuildId());
            if (frontendBuildInfo == null) {
                return;
            }
            FrontendBuildInfo info = frontendBuildInfo;
            info.setMessage(((BuildViewEvent.BuildFinished)event).getMessage());
            info.setIcon(IconIdKt.icon((IconId)((BuildViewEvent.BuildFinished)event).getIconId()));
            this.refreshBuildList();
            this.buildContentManager.finishBuildNotified((BuildDescriptor)info, this.content);
            if (((BuildViewEvent.BuildFinished)event).getSelectContent()) {
                this.buildContentManager.setSelectedContent(this.content, false, false, ((BuildViewEvent.BuildFinished)event).getActivateToolWindow(), null);
            }
            BuildNotification buildNotification = ((BuildViewEvent.BuildFinished)event).getNotification();
            if (buildNotification != null) {
                BuildNotification it = buildNotification;
                boolean bl = false;
                SystemNotifications.getInstance().notify(UIBundle.message((String)"tool.window.name.build", (Object[])new Object[0]), it.getTitle(), it.getContent());
            }
        } else if (buildViewEvent instanceof BuildViewEvent.BuildRemoved) {
            FrontendBuildInfo frontendBuildInfo = this.buildMap.remove(((BuildViewEvent.BuildRemoved)event).getBuildId());
            if (frontendBuildInfo == null) {
                return;
            }
            FrontendBuildInfo info = frontendBuildInfo;
            this.buildListModel.removeElement(info);
            FrontendBuildView frontendBuildView = this.viewMap.remove(info);
            Intrinsics.checkNotNull((Object)frontendBuildView);
            FrontendBuildView buildView = frontendBuildView;
            Disposer.dispose((Disposable)buildView);
            if (this.buildListModel.getSize() == 1) {
                this.setBuildListVisible(false);
            }
            if (buildView == this.activeView) {
                this.setActiveView(null);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setBuildListVisible(boolean visible) {
        if (visible) {
            void $this$setBuildListVisible_u24lambda_u241;
            JBScrollPane jBScrollPane;
            this.log((Function0<String>)((Function0)FrontendMultipleBuildsView::setBuildListVisible$lambda$0));
            JBScrollPane jBScrollPane2 = jBScrollPane = new JBScrollPane((Component)this.buildList);
            OnePixelSplitter onePixelSplitter = this.threeComponentsSplitter;
            boolean bl = false;
            $this$setBuildListVisible_u24lambda_u241.setBorder((Border)JBUI.Borders.empty());
            onePixelSplitter.setFirstComponent((JComponent)jBScrollPane);
        } else {
            this.log((Function0<String>)((Function0)FrontendMultipleBuildsView::setBuildListVisible$lambda$2));
            this.threeComponentsSplitter.setFirstComponent(null);
        }
    }

    private final void refreshBuildList() {
        block0: {
            JComponent jComponent = this.threeComponentsSplitter.getFirstComponent();
            if (jComponent == null) break block0;
            JComponent $this$refreshBuildList_u24lambda_u240 = jComponent;
            boolean bl = false;
            $this$refreshBuildList_u24lambda_u240.revalidate();
            $this$refreshBuildList_u24lambda_u240.repaint();
        }
    }

    public final boolean isPinnable$intellij_platform_buildView_frontend() {
        return this.content.isValid() && !this.locked && this.activeView != null;
    }

    public final boolean isPinned$intellij_platform_buildView_frontend() {
        return this.content.isPinned();
    }

    public final boolean togglePinned$intellij_platform_buildView_frontend() {
        boolean pinned;
        boolean bl = pinned = !this.content.isPinned();
        if (pinned) {
            this.content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
        }
        this.content.setPinned(pinned);
        this.log((Function0<String>)((Function0)() -> FrontendMultipleBuildsView.togglePinned$lambda$0(pinned)));
        return pinned;
    }

    private final void log(Function0<String> messageProvider) {
        if (FrontendMultipleBuildsViewKt.access$getLOG$p().isDebugEnabled()) {
            FrontendMultipleBuildsViewKt.access$getLOG$p().debug("[" + this.id + "/" + this.name + "] " + messageProvider.invoke());
        }
    }

    private static final String dispose$lambda$0() {
        return "Disposed";
    }

    private static final String createList$lambda$0$0$0(FrontendBuildInfo $info) {
        return "Selected " + $info;
    }

    private static final void createList$lambda$0$0(JBList $this_apply, FrontendMultipleBuildsView this$0, ListSelectionEvent it) {
        FrontendBuildInfo info = (FrontendBuildInfo)$this_apply.getSelectedValue();
        this$0.log((Function0<String>)((Function0)() -> FrontendMultipleBuildsView.createList$lambda$0$0$0(info)));
        this$0.setActiveView(this$0.viewMap.get(info));
    }

    private static final String createContent$lambda$1$0(boolean $newPinned) {
        return "Pinned status changed to " + $newPinned;
    }

    private static final String createContent$lambda$0(boolean $pinned) {
        return "Creating content, pinned=" + $pinned;
    }

    private static final void createContent$lambda$1(FrontendMultipleBuildsView this$0, BuildContentId $contentId, PropertyChangeEvent e) {
        if (Intrinsics.areEqual((Object)e.getPropertyName(), (Object)"pinned")) {
            Object object = e.getNewValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean newPinned = (Boolean)object;
            this$0.log((Function0<String>)((Function0)() -> FrontendMultipleBuildsView.createContent$lambda$1$0(newPinned)));
            BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($contentId, newPinned, null){
                int label;
                final /* synthetic */ BuildContentId $contentId;
                final /* synthetic */ boolean $newPinned;
                {
                    this.$contentId = $contentId;
                    this.$newPinned = $newPinned;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object $result) {
                    var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            v0 = BuildViewApi.Companion.getInstance((Continuation)this);
                            if (v0 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            this.label = 2;
                            v1 = ((BuildViewApi)v0).setBuildContentPinned(this.$contentId, this.$newPinned, (Continuation)this);
                            if (v1 == var2_2) {
                                return var2_2;
                            }
                            ** GOTO lbl21
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl21:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private static final String lockContent$lambda$0(String $tabName) {
        return "Locking content as '" + $tabName + "'";
    }

    private static final String handleEvent$lambda$0(FrontendBuildInfo $info) {
        return "Selecting " + $info;
    }

    private static final void handleEvent$lambda$1(FrontendMultipleBuildsView this$0, BuildViewEvent $event, FrontendBuildInfo $info) {
        BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $event, $info, null){
            int label;
            final /* synthetic */ FrontendMultipleBuildsView this$0;
            final /* synthetic */ BuildViewEvent $event;
            final /* synthetic */ FrontendBuildInfo $info;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                this.$info = $info;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        FrontendMultipleBuildsView.access$log(this.this$0, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.platform.buildView.frontend.FrontendMultipleBuildsView$FrontendBuildInfo ), ()Ljava/lang/String;)((FrontendBuildInfo)this.$info));
                        this.label = 1;
                        v0 = BuildViewApi.Companion.getInstance((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        this.label = 2;
                        v1 = ((BuildViewApi)v0).notifyTooWindowActivated(((BuildViewEvent.BuildStarted)this.$event).getBuildId(), (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl22
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl22:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final String invokeSuspend$lambda$0(FrontendBuildInfo $info) {
                return "notifyTooWindowActivated(" + $info + ")";
            }
        }), (int)3, null);
    }

    private static final String setBuildListVisible$lambda$0() {
        return "Showing build list";
    }

    private static final String setBuildListVisible$lambda$2() {
        return "Hiding build list";
    }

    private static final String togglePinned$lambda$0(boolean $pinned) {
        return "PinBuildViewAction: " + $pinned;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(FrontendMultipleBuildsView $this) {
        return $this.scope;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView$Companion;", "", "<init>", "()V", "DATA_KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView;", "getDATA_KEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "intellij.platform.buildView.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<FrontendMultipleBuildsView> getDATA_KEY() {
            return DATA_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView$FocusWatcher;", "Ljava/awt/event/AWTEventListener;", "<init>", "(Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView;)V", "focused", "", "getFocused", "()Z", "setFocused", "(Z)V", "install", "", "uninstall", "eventDispatched", "event", "Ljava/awt/AWTEvent;", "intellij.platform.buildView.frontend"})
    private final class FocusWatcher
    implements AWTEventListener {
        private boolean focused;

        public final boolean getFocused() {
            return this.focused;
        }

        public final void setFocused(boolean bl) {
            this.focused = bl;
        }

        public final void install() {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 4L);
        }

        public final void uninstall() {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }

        @Override
        public void eventDispatched(@NotNull AWTEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event.getID() == 1004) {
                boolean oldFocused = this.focused;
                this.focused = SwingUtilities.isDescendingFrom(((ComponentEvent)event).getComponent(), FrontendMultipleBuildsView.this.content.getComponent());
                if (this.focused != oldFocused) {
                    FrontendMultipleBuildsView.this.log((Function0<String>)() -> FocusWatcher.eventDispatched$lambda$0(this));
                }
            }
        }

        private static final String eventDispatched$lambda$0(FocusWatcher this$0) {
            return "Focused status changed to " + this$0.focused;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001c\u001a\u00020\u0007H\u0016J\r\u0010\u001d\u001a\u00070\t\u00a2\u0006\u0002\b\nH\u0016J\b\u0010\u001e\u001a\u00020\tH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\n\u0010 \u001a\u00020\tH\u0096\u0080\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0013\u001a\u00070\t\u00a2\u0006\u0002\b\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0016\"\u0004\b\u001b\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView$FrontendBuildInfo;", "Lcom/intellij/build/BuildDescriptor;", "event", "Lcom/intellij/build/BuildViewEvent$BuildStarted;", "<init>", "(Lcom/intellij/build/BuildViewEvent$BuildStarted;)V", "id", "Lcom/intellij/build/BuildId;", "title", "", "Lcom/intellij/build/events/BuildEventsNls$Title;", "startTime", "", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "setIcon", "(Ljavax/swing/Icon;)V", "message", "Lcom/intellij/build/events/BuildEventsNls$Message;", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "statusMessage", "getStatusMessage", "setStatusMessage", "getId", "getTitle", "getWorkingDir", "getStartTime", "toString", "intellij.platform.buildView.frontend"})
    private static final class FrontendBuildInfo
    implements BuildDescriptor {
        @NotNull
        private final BuildId id;
        @NotNull
        private final String title;
        private final long startTime;
        @NotNull
        private Icon icon;
        @NotNull
        private String message;
        @Nullable
        private String statusMessage;

        public FrontendBuildInfo(@NotNull BuildViewEvent.BuildStarted event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.id = event.getBuildId();
            this.title = event.getTitle();
            this.startTime = event.getStartTime();
            AnimatedIcon animatedIcon = AnimatedIcon.Default.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)animatedIcon, (String)"INSTANCE");
            this.icon = (Icon)animatedIcon;
            this.message = event.getMessage();
        }

        @NotNull
        public final Icon getIcon() {
            return this.icon;
        }

        public final void setIcon(@NotNull Icon icon) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"<set-?>");
            this.icon = icon;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.message = string;
        }

        @Nullable
        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(@Nullable String string) {
            this.statusMessage = string;
        }

        @NotNull
        public BuildId getId() {
            return this.id;
        }

        @NotNull
        public String getTitle() {
            return this.title;
        }

        @NotNull
        public String getWorkingDir() {
            return "";
        }

        public long getStartTime() {
            return this.startTime;
        }

        @NotNull
        public String toString() {
            return "Build[" + this.id + "/" + this.title + "]";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u0018\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\n\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010\u0012\u001a\f0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0016J\u0012\u0010\u0016\u001a\f0\u0013\u00a2\u0006\u0002\b\u0014\u00a2\u0006\u0002\b\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView$MultipleBuildsPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/ide/OccurenceNavigator;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "<init>", "(Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView;)V", "getOccurenceNavigator", "Lkotlin/Pair;", "", "Lkotlin/Function0;", "Lcom/intellij/ide/OccurenceNavigator$OccurenceInfo;", "next", "", "go", "hasNextOccurence", "hasPreviousOccurence", "goNextOccurence", "goPreviousOccurence", "getNextOccurenceActionName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPreviousOccurenceActionName", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "updateUI", "", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.platform.buildView.frontend"})
    private final class MultipleBuildsPanel
    extends JPanel
    implements OccurenceNavigator,
    UiDataProvider {
        public MultipleBuildsPanel() {
            super(new BorderLayout());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final Pair<Integer, Function0<OccurenceNavigator.OccurenceInfo>> getOccurenceNavigator(boolean next) {
            Pair pair;
            Pair pair2;
            if (FrontendMultipleBuildsView.this.buildListModel.size() == 0) {
                return null;
            }
            int index = Math.max(FrontendMultipleBuildsView.this.buildList.getSelectedIndex(), 0);
            IntProgression range = next ? (IntProgression)RangesKt.until((int)index, (int)FrontendMultipleBuildsView.this.buildListModel.size()) : RangesKt.downTo((int)index, (int)0);
            Iterable iterable = (Iterable)range;
            FrontendMultipleBuildsView frontendMultipleBuildsView = FrontendMultipleBuildsView.this;
            Iterator iterator = iterable.iterator();
            do {
                if (!iterator.hasNext()) return null;
                int i = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                FrontendBuildInfo buildInfo = (FrontendBuildInfo)frontendMultipleBuildsView.buildListModel.getElementAt(i);
                FrontendBuildView buildView = (FrontendBuildView)frontendMultipleBuildsView.viewMap.get(buildInfo);
                if (buildView == null) {
                    pair = null;
                    continue;
                }
                if (i != index) {
                    BuildTreeView eventView = buildView.getTreeView$intellij_platform_buildView_frontend();
                    if (eventView == null) {
                        pair = null;
                        continue;
                    }
                    eventView.clearTreeSelection$intellij_platform_buildView_frontend();
                }
                if (next) {
                    if (buildView.hasNextOccurence()) {
                        pair = TuplesKt.to((Object)i, (Object)new Function0<OccurenceNavigator.OccurenceInfo>((Object)buildView){

                            public final OccurenceNavigator.OccurenceInfo invoke() {
                                return ((FrontendBuildView)this.receiver).goNextOccurence();
                            }
                        });
                        continue;
                    }
                } else {
                    if (buildView.hasPreviousOccurence()) {
                        pair = TuplesKt.to((Object)i, (Object)new Function0<OccurenceNavigator.OccurenceInfo>((Object)buildView){

                            public final OccurenceNavigator.OccurenceInfo invoke() {
                                return ((FrontendBuildView)this.receiver).goPreviousOccurence();
                            }
                        });
                        continue;
                    }
                    if (i != index && buildView.hasNextOccurence()) {
                        pair = TuplesKt.to((Object)i, (Object)new Function0<OccurenceNavigator.OccurenceInfo>((Object)buildView){

                            public final OccurenceNavigator.OccurenceInfo invoke() {
                                return ((FrontendBuildView)this.receiver).goNextOccurence();
                            }
                        });
                        continue;
                    }
                }
                pair = null;
            } while ((pair2 = pair) == null);
            Pair pair3 = pair2;
            return pair3;
        }

        private final OccurenceNavigator.OccurenceInfo go(boolean next) {
            Pair<Integer, Function0<OccurenceNavigator.OccurenceInfo>> navigator = this.getOccurenceNavigator(next);
            if (navigator != null) {
                FrontendMultipleBuildsView.this.buildList.setSelectedIndex(((Number)navigator.getFirst()).intValue());
                return (OccurenceNavigator.OccurenceInfo)((Function0)navigator.getSecond()).invoke();
            }
            return null;
        }

        public boolean hasNextOccurence() {
            return this.getOccurenceNavigator(true) != null;
        }

        public boolean hasPreviousOccurence() {
            return this.getOccurenceNavigator(false) != null;
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.go(true);
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.go(false);
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = IdeBundle.message((String)"action.next.problem", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = IdeBundle.message((String)"action.previous.problem", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            FrontendMultipleBuildsView.this.updateBuildsListRowHeight();
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                sink.set(Companion.getDATA_KEY(), (Object)FrontendMultipleBuildsView.this);
                FrontendBuildView frontendBuildView = FrontendMultipleBuildsView.this.activeView;
                if (frontendBuildView == null) break block0;
                FrontendBuildView it = frontendBuildView;
                boolean bl = false;
                sink.set(BuildDataKeys.INSTANCE.getBUILD_ID(), (Object)it.getBuildId());
                sink.set(FrontendBuildView.Companion.getDATA_KEY(), (Object)it);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView$MyCellRenderer;", "Ljava/util/function/Function;", "Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView$FrontendBuildInfo;", "Ljavax/swing/JComponent;", "<init>", "()V", "ansiEscapeDecoder", "Lcom/intellij/execution/process/AnsiEscapeDecoder;", "apply", "obj", "intellij.platform.buildView.frontend"})
    private static final class MyCellRenderer
    implements Function<FrontendBuildInfo, JComponent> {
        @NotNull
        private final AnsiEscapeDecoder ansiEscapeDecoder = new AnsiEscapeDecoder();

        @Override
        @NotNull
        public JComponent apply(@NotNull FrontendBuildInfo obj) {
            JPanel panel;
            block0: {
                SimpleColoredComponent simpleColoredComponent;
                SimpleColoredComponent simpleColoredComponent2;
                Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
                panel = new JPanel(new BorderLayout());
                SimpleColoredComponent $this$apply_u24lambda_u240 = simpleColoredComponent2 = new SimpleColoredComponent();
                boolean bl = false;
                $this$apply_u24lambda_u240.setIcon(obj.getIcon());
                $this$apply_u24lambda_u240.append(obj.getTitle() + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                $this$apply_u24lambda_u240.append(obj.getMessage(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                SimpleColoredComponent mainComponent = simpleColoredComponent2;
                panel.add((Component)mainComponent, "North");
                String string = obj.getStatusMessage();
                if (string == null) break block0;
                String statusMessage = string;
                boolean bl2 = false;
                SimpleColoredComponent $this$apply_u24lambda_u241_u240 = simpleColoredComponent = new SimpleColoredComponent();
                boolean bl3 = false;
                $this$apply_u24lambda_u241_u240.setIcon(EmptyIcon.ICON_16);
                this.ansiEscapeDecoder.escapeText(statusMessage, ProcessOutputTypes.STDOUT, (arg_0, arg_1) -> MyCellRenderer.apply$lambda$1$0$0($this$apply_u24lambda_u241_u240, arg_0, arg_1));
                SimpleColoredComponent statusComponent = simpleColoredComponent;
                panel.add((Component)statusComponent, "South");
            }
            return panel;
        }

        private static final void apply$lambda$1$0$0(SimpleColoredComponent $this_apply, String text, Key key) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)key, (String)"<unused var>");
            $this_apply.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }
}

