/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.LoweringContext;
import org.jetbrains.kotlin.backend.common.lower.IrBuildingTransformer;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrGeneratorContextInterface;
import org.jetbrains.kotlin.ir.builders.PrimitivesKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrStatementContainer;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContext;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\f\u0010\u000b\u001a\u00020\f*\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\f\u0010\u0016\u001a\u00020\u0010*\u00020\u0010H\u0002J\f\u0010\u0017\u001a\u00020\u0013*\u00020\fH\u0002J\f\u0010\u0018\u001a\u00020\u0013*\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u001f2\u0006\u0010 \u001a\u00020\u001cH\u0002J\u0011\u0010!\u001a\u00070\u001e\u00a2\u0006\u0002\b\"*\u00020\u001eH\u0002J\f\u0010#\u001a\u00020\u0013*\u00020$H\u0002J\u001c\u0010%\u001a\u00020\u0013*\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0002J\u0018\u0010*\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0+*\u00020,H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010&2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/backend/common/lower/IrBuildingTransformer;", "backendContext", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "transformVoid", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "lowerInstanceOf", "argument", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "lowerCast", "isCompatibleArrayType", "", "actualType", "expectedType", "getArrayElementLowerType", "isDefinitelyNotNull", "isDefinitelyNotNullVal", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "visitTypeOperator", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "computeNotNullAssertionText", "", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "typeOperatorCall", "trimForRuntimeAssertion", "Lorg/jetbrains/annotations/NotNull;", "isDelegated", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "validSourcePosition", "", "startOffset", "", "endOffset", "extents", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/IrElement;", "sourceViewFor", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "throwTypeCastException", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "checkExpressionValueIsNotNull", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nTypeOperatorLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering\n+ 2 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 3 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n19#2,26:294\n19#2,17:320\n409#2,13:337\n36#2,9:352\n434#2,13:361\n19#2,26:376\n19#2,17:402\n434#2,13:419\n36#2,9:434\n133#3,2:350\n133#3,2:374\n133#3,2:432\n1#4:443\n*S KotlinDebug\n*F\n+ 1 TypeOperatorLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/TypeOperatorLowering\n*L\n62#1:294,26\n87#1:320,17\n94#1:337,13\n87#1:352,9\n155#1:361,13\n178#1:376,26\n206#1:402,17\n207#1:419,13\n206#1:434,9\n94#1:350,2\n155#1:374,2\n207#1:432,2\n*E\n"})
public final class TypeOperatorLowering
extends IrBuildingTransformer
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext backendContext;
    @NotNull
    private final IrSimpleFunctionSymbol throwTypeCastException;
    @NotNull
    private final IrSimpleFunctionSymbol checkExpressionValueIsNotNull;

    public TypeOperatorLowering(@NotNull JvmBackendContext backendContext) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        super((LoweringContext)backendContext);
        this.backendContext = backendContext;
        this.throwTypeCastException = this.backendContext.getSymbols().getThrowTypeCastException();
        this.checkExpressionValueIsNotNull = this.backendContext.getConfig().getUnifiedNullChecks() ? this.backendContext.getSymbols().getCheckNotNullExpressionValue() : this.backendContext.getSymbols().getCheckExpressionValueIsNotNull();
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.transformChildrenVoid((IrElement)irFile);
    }

    private final IrExpression transformVoid(IrExpression $this$transformVoid) {
        return $this$transformVoid.transform((IrTransformer)this, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerInstanceOf(IrExpression argument, IrType type) {
        IrExpression irExpression;
        IrBuilderWithScope $this$lowerInstanceOf_u24lambda_u240 = this.getBuilder();
        boolean bl = false;
        if (IrTypeUtilsKt.isReifiedTypeParameter((IrType)type)) {
            irExpression = (IrExpression)ExpressionHelpersKt.irIs((IrBuilder)((IrBuilder)$this$lowerInstanceOf_u24lambda_u240), (IrExpression)argument, (IrType)type);
        } else if (IrTypeUtilsKt.isNullable((IrType)argument.getType()) && IrTypeUtilsKt.isNullable((IrType)type)) {
            void $this$irLetS_u24default$iv;
            void value$iv;
            IrBuilderWithScope irBuilderWithScope = $this$lowerInstanceOf_u24lambda_u240;
            IrExpression irExpression2 = argument;
            IrType irType$iv = $this$lowerInstanceOf_u24lambda_u240.getContext().getIrBuiltIns().getAnyNType();
            IrStatementOrigin origin$iv = null;
            String nameHint$iv = null;
            boolean $i$f$irLetS = false;
            IrVariable irTemporary$iv = null;
            IrValueSymbol valueSymbol$iv = null;
            if (value$iv instanceof IrGetValue && IrUtilsKt.isImmutable((IrValueDeclaration)((IrGetValue)value$iv).getSymbol().getOwner())) {
                irTemporary$iv = null;
                valueSymbol$iv = ((IrGetValue)value$iv).getSymbol();
            } else {
                irTemporary$iv = Scope.createTemporaryVariable$default((Scope)$this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv, nameHint$iv, (boolean)false, null, (IrType)irType$iv, (int)0, (int)0, (boolean)false, (int)236, null);
                valueSymbol$iv = (IrValueSymbol)irTemporary$iv.getSymbol();
            }
            IrValueSymbol valueSymbol = valueSymbol$iv;
            boolean bl2 = false;
            IrExpression irResult$iv = (IrExpression)PrimitivesKt.oror$default((IrGeneratorContextInterface)((IrGeneratorContextInterface)$this$lowerInstanceOf_u24lambda_u240.getContext()), (IrExpression)ExpressionHelpersKt.irEqualsNull((IrBuilder)((IrBuilder)$this$lowerInstanceOf_u24lambda_u240), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$lowerInstanceOf_u24lambda_u240), (IrValueDeclaration)valueSymbol.getOwner()))), (IrExpression)((IrExpression)ExpressionHelpersKt.irIs((IrBuilder)((IrBuilder)$this$lowerInstanceOf_u24lambda_u240), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$lowerInstanceOf_u24lambda_u240), (IrValueDeclaration)valueSymbol.getOwner())), (IrType)IrTypesKt.makeNotNull((IrType)type))), null, (int)4, null);
            if (irTemporary$iv == null) {
                irExpression = irResult$iv;
            } else {
                IrBlockImpl irBlock$iv = BuildersKt.IrBlockImpl((int)$this$irLetS_u24default$iv.getStartOffset(), (int)$this$irLetS_u24default$iv.getEndOffset(), (IrType)irResult$iv.getType(), origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                boolean bl3 = irResult$iv instanceof IrStatementContainer ? irBlock$iv.getStatements().addAll(((IrStatementContainer)irResult$iv).getStatements()) : irBlock$iv.getStatements().add(irResult$iv);
                irExpression = (IrExpression)irBlock$iv;
            }
        } else {
            irExpression = IrTypeUtilsKt.isNullable((IrType)argument.getType()) && !IrTypeUtilsKt.isNullable((IrType)type) && Intrinsics.areEqual((Object)IrTypeErasureUtilsKt.getErasedUpperBound((IrType)argument.getType()), (Object)IrTypeErasureUtilsKt.getErasedUpperBound((IrType)type)) ? ExpressionHelpersKt.irNotEquals((IrBuilder)((IrBuilder)$this$lowerInstanceOf_u24lambda_u240), (IrExpression)argument, (IrExpression)((IrExpression)ExpressionHelpersKt.irNull((IrBuilder)((IrBuilder)$this$lowerInstanceOf_u24lambda_u240)))) : (IrExpression)ExpressionHelpersKt.irIs((IrBuilder)((IrBuilder)$this$lowerInstanceOf_u24lambda_u240), (IrExpression)argument, (IrType)IrTypesKt.makeNotNull((IrType)type));
        }
        return irExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression lowerCast(IrExpression argument, IrType type) {
        IrExpression irExpression;
        if (IrTypeUtilsKt.isReifiedTypeParameter((IrType)type)) {
            irExpression = (IrExpression)ExpressionHelpersKt.irAs((IrBuilder)((IrBuilder)this.getBuilder()), (IrExpression)argument, (IrType)type);
        } else if (JvmIrTypeUtilsKt.isInlineClassType(argument.getType()) && IrTypeUtilsKt.isSubtypeOfClass((IrType)argument.getType(), (IrClassSymbol)IrTypeErasureUtilsKt.getErasedUpperBound((IrType)type).getSymbol())) {
            irExpression = argument;
        } else if (this.isCompatibleArrayType(argument.getType(), type)) {
            irExpression = argument;
        } else if (IrTypeUtilsKt.isNullable((IrType)type) || this.isDefinitelyNotNull(argument)) {
            irExpression = (IrExpression)ExpressionHelpersKt.irAs((IrBuilder)((IrBuilder)this.getBuilder()), (IrExpression)argument, (IrType)type);
        } else {
            IrExpression irExpression2;
            void $this$irLetS_u24default$iv;
            void value$iv;
            IrBuilderWithScope $this$lowerCast_u24lambda_u240 = this.getBuilder();
            boolean bl = false;
            IrBuilderWithScope irBuilderWithScope = $this$lowerCast_u24lambda_u240;
            IrExpression irExpression3 = argument;
            IrType irType$iv = $this$lowerCast_u24lambda_u240.getContext().getIrBuiltIns().getAnyNType();
            IrStatementOrigin origin$iv = null;
            String nameHint$iv = null;
            boolean $i$f$irLetS = false;
            IrVariable irTemporary$iv = null;
            IrValueSymbol valueSymbol$iv = null;
            if (value$iv instanceof IrGetValue && IrUtilsKt.isImmutable((IrValueDeclaration)((IrGetValue)value$iv).getSymbol().getOwner())) {
                irTemporary$iv = null;
                valueSymbol$iv = ((IrGetValue)value$iv).getSymbol();
            } else {
                irTemporary$iv = Scope.createTemporaryVariable$default((Scope)$this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv, nameHint$iv, (boolean)false, null, (IrType)irType$iv, (int)0, (int)0, (boolean)false, (int)236, null);
                valueSymbol$iv = (IrValueSymbol)irTemporary$iv.getSymbol();
            }
            IrValueSymbol tmp = valueSymbol$iv;
            boolean bl2 = false;
            IrConstImpl message = ExpressionHelpersKt.irString((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240), (String)("null cannot be cast to non-null type " + RenderIrElementKt.render$default((IrType)type, null, (int)1, null)));
            if (this.backendContext.getConfig().getUnifiedNullChecks()) {
                void $this$lowerCast_u24lambda_u240_u240_u240_u240;
                IrCall irCall;
                void this_$iv$iv;
                void $this$irBlock_u24default$iv;
                IrBuilderWithScope irBuilderWithScope2 = $this$lowerCast_u24lambda_u240;
                IrType resultType$iv = type;
                int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv2 = null;
                boolean $i$f$irBlock = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv2, resultType$iv, false, 64, null);
                boolean $i$f$block = false;
                void $this$lowerCast_u24lambda_u240_u240_u240 = this_$iv$iv;
                boolean bl3 = false;
                IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240_u240_u240), (IrSimpleFunctionSymbol)this.backendContext.getSymbols().getCheckNotNullWithMessage());
                void var28_31 = $this$lowerCast_u24lambda_u240_u240_u240;
                boolean bl4 = false;
                $this$lowerCast_u24lambda_u240_u240_u240_u240.getArguments().set(0, (Object)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240_u240_u240), (IrValueDeclaration)tmp.getOwner()));
                $this$lowerCast_u24lambda_u240_u240_u240_u240.getArguments().set(1, (Object)message);
                var28_31.unaryPlus((IrStatement)irCall);
                $this$lowerCast_u24lambda_u240_u240_u240.unaryPlus((IrStatement)ExpressionHelpersKt.irAs((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240_u240_u240), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240_u240_u240), (IrValueDeclaration)tmp.getOwner())), (IrType)IrTypesKt.makeNullable((IrType)type)));
                irExpression2 = (IrExpression)this_$iv$iv.doBuild();
            } else {
                void $this$lowerCast_u24lambda_u240_u240_u241;
                IrCall irCall;
                IrCall startOffset$iv = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240), (IrSimpleFunctionSymbol)this.throwTypeCastException);
                IrExpression irExpression4 = (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240), (IrValueDeclaration)tmp.getOwner());
                IrType irType = type;
                IrBuilder irBuilder = (IrBuilder)$this$lowerCast_u24lambda_u240;
                boolean bl5 = false;
                $this$lowerCast_u24lambda_u240_u240_u241.getArguments().set(0, (Object)message);
                Unit unit = Unit.INSTANCE;
                irExpression2 = (IrExpression)ExpressionHelpersKt.irIfNull((IrBuilder)irBuilder, (IrType)irType, (IrExpression)irExpression4, (IrExpression)((IrExpression)irCall), (IrExpression)((IrExpression)ExpressionHelpersKt.irAs((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240), (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$lowerCast_u24lambda_u240), (IrValueDeclaration)tmp.getOwner())), (IrType)IrTypesKt.makeNullable((IrType)type))));
            }
            IrExpression irResult$iv = irExpression2;
            if (irTemporary$iv == null) {
                irExpression = irResult$iv;
            } else {
                IrBlockImpl irBlock$iv = BuildersKt.IrBlockImpl((int)$this$irLetS_u24default$iv.getStartOffset(), (int)$this$irLetS_u24default$iv.getEndOffset(), (IrType)irResult$iv.getType(), origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                boolean bl6 = irResult$iv instanceof IrStatementContainer ? irBlock$iv.getStatements().addAll(((IrStatementContainer)irResult$iv).getStatements()) : irBlock$iv.getStatements().add(irResult$iv);
                irExpression = (IrExpression)irBlock$iv;
            }
        }
        return irExpression;
    }

    private final boolean isCompatibleArrayType(IrType actualType, IrType expectedType) {
        IrType actual = actualType;
        IrType expected = expectedType;
        while ((IrTypePredicatesKt.isArray((IrType)actual) || IrTypePredicatesKt.isNullableArray((IrType)actual)) && (IrTypePredicatesKt.isArray((IrType)expected) || IrTypePredicatesKt.isNullableArray((IrType)expected))) {
            actual = this.getArrayElementLowerType(actual);
            expected = this.getArrayElementLowerType(expected);
        }
        if (Intrinsics.areEqual((Object)actual, (Object)actualType) || Intrinsics.areEqual((Object)expected, (Object)expectedType)) {
            return false;
        }
        return IrTypeUtilsKt.isSubtypeOfClass((IrType)actual, (IrClassSymbol)IrTypeErasureUtilsKt.getErasedUpperBound((IrType)expected).getSymbol());
    }

    /*
     * Enabled aggressive block sorting
     */
    private final IrType getArrayElementLowerType(IrType $this$getArrayElementLowerType) {
        IrType irType;
        if (IrTypeUtilsKt.isBoxedArray((IrType)$this$getArrayElementLowerType) && $this$getArrayElementLowerType instanceof IrSimpleType) {
            Object object = CollectionsKt.singleOrNull((List)((IrSimpleType)$this$getArrayElementLowerType).getArguments());
            IrTypeProjection irTypeProjection = object instanceof IrTypeProjection ? (IrTypeProjection)object : null;
            if ((irTypeProjection != null ? irTypeProjection.getVariance() : null) == Variance.IN_VARIANCE) {
                irType = this.backendContext.getIrBuiltIns().getAnyNType();
                return irType;
            }
        }
        irType = IrTypeUtilsKt.getArrayElementType((IrType)$this$getArrayElementLowerType, (IrBuiltIns)this.backendContext.getIrBuiltIns());
        return irType;
    }

    private final boolean isDefinitelyNotNull(IrExpression $this$isDefinitelyNotNull) {
        IrExpression irExpression = $this$isDefinitelyNotNull;
        return irExpression instanceof IrGetValue ? this.isDefinitelyNotNullVal(((IrGetValue)$this$isDefinitelyNotNull).getSymbol().getOwner()) : (irExpression instanceof IrGetClass || irExpression instanceof IrConstructorCall ? true : (irExpression instanceof IrCall ? Intrinsics.areEqual((Object)((IrCall)$this$isDefinitelyNotNull).getSymbol(), (Object)this.backendContext.getIrBuiltIns().getCheckNotNullSymbol()) : false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isDefinitelyNotNullVal(IrValueDeclaration $this$isDefinitelyNotNullVal) {
        if (!($this$isDefinitelyNotNullVal instanceof IrVariable)) return false;
        IrVariable irVariable = (IrVariable)$this$isDefinitelyNotNullVal;
        if (irVariable == null) {
            return false;
        }
        IrVariable irVariable2 = irVariable;
        if (irVariable2.isVar()) return false;
        IrExpression irExpression = irVariable2.getInitializer();
        if (irExpression == null) return false;
        if (!this.isDefinitelyNotNull(irExpression)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrBuilderWithScope $this$visitTypeOperator_u24lambda_u240 = this.getBuilder();
        boolean bl = false;
        LowerUtilsKt.at((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240), (IrElement)((IrElement)expression2));
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                IrType expressionExtendedType;
                void this_$iv$iv;
                void $this$irComposite_u24default$iv;
                IrBuilderWithScope irBuilderWithScope = $this$visitTypeOperator_u24lambda_u240;
                IrType resultType$iv = expression2.getType();
                int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv = null;
                boolean $i$f$irComposite = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, true);
                boolean $i$f$block = false;
                void $this$visitTypeOperator_u24lambda_u240_u240 = this_$iv$iv;
                boolean bl2 = false;
                $this$visitTypeOperator_u24lambda_u240_u240.unaryPlus((IrStatement)this.transformVoid(expression2.getArgument()));
                IrType irType = expressionExtendedType = this.backendContext.getConfig().getUseFir() ? expression2.getType() : IrTypesKt.makeNullable((IrType)expression2.getType());
                if (!IrTypeUtilsKt.isSubtypeOf((IrType)expression2.getArgument().getType(), (IrType)expressionExtendedType, (IrTypeSystemContext)this.backendContext.getTypeSystem())) {
                    $this$visitTypeOperator_u24lambda_u240_u240.unaryPlus((IrStatement)BuildersKt.IrCompositeImpl$default((int)-1, (int)-1, (IrType)expression2.getType(), null, (int)8, null));
                }
                irExpression = (IrExpression)this_$iv$iv.doBuild();
                break;
            }
            case 2: {
                irExpression = (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240), (IrExpression)this.transformVoid(expression2.getArgument()), (IrType)expression2.getTypeOperand());
                break;
            }
            case 3: {
                irExpression = this.lowerCast(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand());
                break;
            }
            case 4: {
                void origin$iv;
                void $this$irLetS_u24default$iv;
                void value$iv2;
                if (IrTypeUtilsKt.isReifiedTypeParameter((IrType)expression2.getTypeOperand())) {
                    this.transformChildrenVoid((IrElement)expression2);
                    irExpression = (IrExpression)expression2;
                    break;
                }
                IrBuilderWithScope $this$irComposite_u24default$iv = $this$visitTypeOperator_u24lambda_u240;
                IrExpression startOffset$iv = this.transformVoid(expression2.getArgument());
                IrStatementOrigin endOffset$iv = (IrStatementOrigin)IrStatementOrigin.Companion.getSAFE_CALL();
                IrType resultType$iv = $this$visitTypeOperator_u24lambda_u240.getContext().getIrBuiltIns().getAnyNType();
                String nameHint$iv = null;
                boolean $i$f$irLetS = false;
                IrVariable irTemporary$iv = null;
                IrValueSymbol valueSymbol$iv = null;
                if (value$iv2 instanceof IrGetValue && IrUtilsKt.isImmutable((IrValueDeclaration)((IrGetValue)value$iv2).getSymbol().getOwner())) {
                    irTemporary$iv = null;
                    valueSymbol$iv = ((IrGetValue)value$iv2).getSymbol();
                } else {
                    void irType$iv;
                    irTemporary$iv = Scope.createTemporaryVariable$default((Scope)$this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv2, nameHint$iv, (boolean)false, null, (IrType)irType$iv, (int)0, (int)0, (boolean)false, (int)236, null);
                    valueSymbol$iv = (IrValueSymbol)irTemporary$iv.getSymbol();
                }
                IrValueSymbol valueSymbol = valueSymbol$iv;
                boolean bl3 = false;
                IrExpression thenPart = JvmIrTypeUtilsKt.isInlineClassType(valueSymbol.getOwner().getType()) ? this.lowerCast((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240), (IrValueDeclaration)valueSymbol.getOwner()), expression2.getTypeOperand()) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240), (IrValueDeclaration)valueSymbol.getOwner());
                IrExpression irResult$iv = (IrExpression)ExpressionHelpersKt.irIfThenElse$default((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240), (IrType)expression2.getType(), (IrExpression)this.lowerInstanceOf((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240), (IrValueDeclaration)valueSymbol.getOwner()), IrTypesKt.makeNotNull((IrType)expression2.getTypeOperand())), (IrExpression)thenPart, (IrExpression)((IrExpression)ExpressionHelpersKt.irNull((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240), (IrType)expression2.getType())), null, (int)16, null);
                if (irTemporary$iv == null) {
                    irExpression = irResult$iv;
                    break;
                }
                IrBlockImpl irBlock$iv = BuildersKt.IrBlockImpl((int)$this$irLetS_u24default$iv.getStartOffset(), (int)$this$irLetS_u24default$iv.getEndOffset(), (IrType)irResult$iv.getType(), (IrStatementOrigin)origin$iv);
                irBlock$iv.getStatements().add(irTemporary$iv);
                boolean bl4 = irResult$iv instanceof IrStatementContainer ? irBlock$iv.getStatements().addAll(((IrStatementContainer)irResult$iv).getStatements()) : irBlock$iv.getStatements().add(irResult$iv);
                irExpression = (IrExpression)irBlock$iv;
                break;
            }
            case 5: {
                irExpression = this.lowerInstanceOf(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand());
                break;
            }
            case 6: {
                irExpression = LowerUtilsKt.irNot((IrBuilderWithScope)$this$visitTypeOperator_u24lambda_u240, (IrExpression)this.lowerInstanceOf(this.transformVoid(expression2.getArgument()), expression2.getTypeOperand()));
                break;
            }
            case 7: {
                void this_$iv$iv;
                void $this$irComposite_u24default$iv;
                void $this$irLetS_u24default$iv;
                void value$iv;
                String text = this.computeNotNullAssertionText($this$visitTypeOperator_u24lambda_u240, expression2);
                IrBuilderWithScope value$iv2 = $this$visitTypeOperator_u24lambda_u240;
                IrExpression origin$iv = this.transformVoid(expression2.getArgument());
                IrType irType$iv = $this$visitTypeOperator_u24lambda_u240.getContext().getIrBuiltIns().getAnyNType();
                IrStatementOrigin origin$iv2 = null;
                String nameHint$iv = null;
                boolean $i$f$irLetS = false;
                IrVariable irTemporary$iv = null;
                IrValueSymbol valueSymbol$iv = null;
                if (value$iv instanceof IrGetValue && IrUtilsKt.isImmutable((IrValueDeclaration)((IrGetValue)value$iv).getSymbol().getOwner())) {
                    irTemporary$iv = null;
                    valueSymbol$iv = ((IrGetValue)value$iv).getSymbol();
                } else {
                    irTemporary$iv = Scope.createTemporaryVariable$default((Scope)$this$irLetS_u24default$iv.getScope(), (IrExpression)value$iv, nameHint$iv, (boolean)false, null, (IrType)irType$iv, (int)0, (int)0, (boolean)false, (int)236, null);
                    valueSymbol$iv = (IrValueSymbol)irTemporary$iv.getSymbol();
                }
                IrValueSymbol valueSymbol = valueSymbol$iv;
                boolean bl5 = false;
                IrBuilderWithScope irResult$iv = $this$visitTypeOperator_u24lambda_u240;
                IrType resultType$iv = expression2.getType();
                int startOffset$iv = $this$irComposite_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irComposite_u24default$iv.getEndOffset();
                IrStatementOrigin origin$iv3 = null;
                boolean $i$f$irComposite = false;
                IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irComposite_u24default$iv.getContext(), $this$irComposite_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv3, resultType$iv, true);
                boolean $i$f$block = false;
                void $this$visitTypeOperator_u24lambda_u240_u242_u240 = this_$iv$iv;
                boolean bl6 = false;
                if (text != null) {
                    void $this$visitTypeOperator_u24lambda_u240_u242_u240_u240;
                    IrCall irCall;
                    IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240), (IrSimpleFunctionSymbol)this.checkExpressionValueIsNotNull);
                    void var27_52 = $this$visitTypeOperator_u24lambda_u240_u242_u240;
                    boolean bl7 = false;
                    $this$visitTypeOperator_u24lambda_u240_u242_u240_u240.getArguments().set(0, (Object)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240), (IrValueDeclaration)valueSymbol.getOwner()));
                    $this$visitTypeOperator_u24lambda_u240_u242_u240_u240.getArguments().set(1, (Object)ExpressionHelpersKt.irString((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240), (String)this.trimForRuntimeAssertion(text)));
                    var27_52.unaryPlus((IrStatement)irCall);
                } else {
                    void $this$visitTypeOperator_u24lambda_u240_u242_u240_u241;
                    IrCall irCall;
                    IrCall $this$visitTypeOperator_u24lambda_u240_u242_u240_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240), (IrSimpleFunctionSymbol)this.backendContext.getSymbols().getCheckNotNull());
                    void var27_53 = $this$visitTypeOperator_u24lambda_u240_u242_u240;
                    boolean bl8 = false;
                    $this$visitTypeOperator_u24lambda_u240_u242_u240_u241.getArguments().set(0, (Object)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240), (IrValueDeclaration)valueSymbol.getOwner()));
                    var27_53.unaryPlus((IrStatement)irCall);
                }
                $this$visitTypeOperator_u24lambda_u240_u242_u240.unaryPlus((IrStatement)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$visitTypeOperator_u24lambda_u240_u242_u240), (IrValueDeclaration)valueSymbol.getOwner()));
                IrExpression irResult$iv2 = (IrExpression)this_$iv$iv.doBuild();
                if (irTemporary$iv == null) {
                    irExpression = irResult$iv2;
                    break;
                }
                IrBlockImpl irBlock$iv = BuildersKt.IrBlockImpl((int)$this$irLetS_u24default$iv.getStartOffset(), (int)$this$irLetS_u24default$iv.getEndOffset(), (IrType)irResult$iv2.getType(), origin$iv2);
                irBlock$iv.getStatements().add(irTemporary$iv);
                boolean bl9 = irResult$iv2 instanceof IrStatementContainer ? irBlock$iv.getStatements().addAll(((IrStatementContainer)irResult$iv2).getStatements()) : irBlock$iv.getStatements().add(irResult$iv2);
                irExpression = (IrExpression)irBlock$iv;
                break;
            }
            default: {
                this.transformChildrenVoid((IrElement)expression2);
                irExpression = (IrExpression)expression2;
            }
        }
        return irExpression;
    }

    private final String computeNotNullAssertionText(IrBuilderWithScope $this$computeNotNullAssertionText, IrTypeOperatorCall typeOperatorCall) {
        String string;
        CharSequence charSequence;
        IrDeclaration declarationParent;
        if (this.backendContext.getConfig().getNoSourceCodeInNotNullAssertionExceptions()) {
            String string2;
            IrExpression argument = typeOperatorCall.getArgument();
            if (argument instanceof IrCall) {
                string2 = ((IrSimpleFunction)((IrCall)argument).getSymbol().getOwner()).getName().asString() + "(...)";
            } else if (argument instanceof IrGetField) {
                String string3;
                IrField field = (IrField)((IrGetField)argument).getSymbol().getOwner();
                String it = string3 = field.getName().asString();
                boolean bl = false;
                string2 = !field.getOrigin().isSynthetic() ? string3 : null;
            } else {
                string2 = null;
            }
            return string2;
        }
        IrSymbolOwner owner = $this$computeNotNullAssertionText.getScope().getScopeOwnerSymbol().getOwner();
        if (owner instanceof IrFunction && this.isDelegated((IrFunction)owner)) {
            return ((IrFunction)owner).getName().asString() + "(...)";
        }
        IrDeclarationParent irDeclarationParent = ExpressionHelpersKt.getParent((IrBuilderWithScope)$this$computeNotNullAssertionText);
        IrDeclaration irDeclaration = declarationParent = irDeclarationParent instanceof IrDeclaration ? (IrDeclaration)irDeclarationParent : null;
        if (irDeclaration != null) {
            IrDeclaration p0 = irDeclaration;
            boolean bl = false;
            charSequence = this.sourceViewFor(p0);
        } else {
            charSequence = null;
        }
        CharSequence sourceView = charSequence;
        Pair<Integer, Integer> pair = this.extents((IrElement)typeOperatorCall);
        int startOffset = ((Number)pair.component1()).intValue();
        int endOffset = ((Number)pair.component2()).intValue();
        CharSequence charSequence2 = sourceView;
        boolean bl = charSequence2 != null ? this.validSourcePosition(charSequence2, startOffset, endOffset) : false;
        if (bl) {
            string = ((Object)sourceView.subSequence(startOffset, endOffset)).toString();
        } else {
            string = declarationParent instanceof IrDeclarationWithName ? (IrDeclarationWithName)declarationParent : null;
            if (string == null || (string = string.getName()) == null || (string = string.asString()) == null) {
                string = "Unknown Declaration";
            }
        }
        return string;
    }

    private final String trimForRuntimeAssertion(String $this$trimForRuntimeAssertion) {
        String string = StringUtil.trimMiddle((String)$this$trimForRuntimeAssertion, (int)50);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimMiddle(...)");
        return string;
    }

    private final boolean isDelegated(IrFunction $this$isDelegated) {
        return Intrinsics.areEqual((Object)$this$isDelegated.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_PROPERTY_ACCESSOR()) || Intrinsics.areEqual((Object)$this$isDelegated.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDELEGATED_MEMBER());
    }

    private final boolean validSourcePosition(CharSequence $this$validSourcePosition, int startOffset, int endOffset) {
        return (0 <= startOffset ? startOffset < endOffset : false) && endOffset < $this$validSourcePosition.length();
    }

    private final Pair<Integer, Integer> extents(IrElement $this$extents) {
        Ref.IntRef startOffset = new Ref.IntRef();
        startOffset.element = Integer.MAX_VALUE;
        Ref.IntRef endOffset = new Ref.IntRef();
        IrVisitorsKt.acceptVoid((IrElement)$this$extents, (IrVisitorVoid)new IrVisitorVoid(startOffset, endOffset){
            final /* synthetic */ Ref.IntRef $startOffset;
            final /* synthetic */ Ref.IntRef $endOffset;
            {
                this.$startOffset = $startOffset;
                this.$endOffset = $endOffset;
            }

            public void visitElement(IrElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
                int n = element.getStartOffset();
                boolean bl = 0 <= n ? n < this.$startOffset.element : false;
                if (bl) {
                    this.$startOffset.element = element.getStartOffset();
                }
                if (this.$endOffset.element < element.getEndOffset()) {
                    this.$endOffset.element = element.getEndOffset();
                }
            }
        });
        return TuplesKt.to((Object)startOffset.element, (Object)endOffset.element);
    }

    private final CharSequence sourceViewFor(IrDeclaration declaration) {
        KtFile ktFile = JvmIrUtilsKt.getKtFile(JvmIrUtilsKt.getFileParent(declaration));
        return ktFile != null && (ktFile = ktFile.getViewProvider()) != null ? ktFile.getContents() : null;
    }

    @Metadata(mv={2, 4, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_INTEGER_COERCION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.CAST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.SAFE_CAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.INSTANCEOF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.NOT_INSTANCEOF.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_NOTNULL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

