/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.inline.CapturedParamInfo;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.inline.ParameterInfo;
import org.jetbrains.kotlin.codegen.inline.Parameters;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapperBase;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002$%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J@\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016J&\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper;", "", "params", "Lorg/jetbrains/kotlin/codegen/inline/Parameters;", "additionalShift", "", "<init>", "(Lorg/jetbrains/kotlin/codegen/inline/Parameters;I)V", "actualParamsSize", "remapValues", "", "Lorg/jetbrains/kotlin/codegen/StackValue;", "[Lorg/jetbrains/kotlin/codegen/StackValue;", "doRemap", "Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo;", "index", "remap", "visitIincInsn", "", "var", "increment", "mv", "Lorg/jetbrains/org/objectweb/asm/MethodVisitor;", "visitLocalVariable", "name", "", "desc", "signature", "start", "Lorg/jetbrains/org/objectweb/asm/Label;", "end", "visitVarInsn", "opcode", "Lorg/jetbrains/org/objectweb/asm/commons/InstructionAdapter;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapperBase;", "RemapStatus", "RemapInfo", "backend"})
@SourceDebugExtension(value={"SMAP\nLocalVarRemapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalVarRemapper.kt\norg/jetbrains/kotlin/codegen/inline/LocalVarRemapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1#2:134\n*E\n"})
public final class LocalVarRemapper {
    @NotNull
    private final Parameters params;
    private final int additionalShift;
    private final int actualParamsSize;
    @NotNull
    private final StackValue[] remapValues;

    public LocalVarRemapper(@NotNull Parameters params, int additionalShift) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        this.params = params;
        this.additionalShift = additionalShift;
        this.remapValues = new StackValue[this.params.getArgsSizeOnStack()];
        int realSize = 0;
        for (ParameterInfo info : this.params) {
            int shift = this.params.getDeclarationSlot(info);
            if (!info.isSkippedOrRemapped()) {
                this.remapValues[shift] = new StackValue.Local(realSize, AsmTypes.OBJECT_TYPE, null);
                realSize += info.getType().getSize();
                continue;
            }
            StackValue stackValue = this.remapValues[shift] = info.isRemapped() ? info.getRemapValue() : null;
            if (!CapturedParamInfo.Companion.isSynthetic(info)) continue;
            realSize += info.getType().getSize();
        }
        this.actualParamsSize = realSize;
    }

    private final RemapInfo doRemap(int index) {
        int remappedIndex = 0;
        if (index < this.params.getArgsSizeOnStack()) {
            ParameterInfo info = this.params.getParameterByDeclarationSlot(index);
            StackValue remapped = this.remapValues[index];
            if (info.isSkipped() || remapped == null) {
                return new RemapInfo(info, null, null, 6, null);
            }
            if (info.isRemapped()) {
                return new RemapInfo(info, remapped, RemapStatus.REMAPPED);
            }
            remappedIndex = ((StackValue.Local)remapped).index;
        } else {
            remappedIndex = this.actualParamsSize - this.params.getArgsSizeOnStack() + index;
        }
        return new RemapInfo(null, new StackValue.Local(remappedIndex + this.additionalShift, AsmTypes.OBJECT_TYPE, null), RemapStatus.SHIFT);
    }

    @NotNull
    public final RemapInfo remap(int index) {
        RemapInfo info = this.doRemap(index);
        if (RemapStatus.FAIL == info.status) {
            boolean bl;
            boolean bl2 = bl = info.parameterInfo != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Parameter info for " + index + " variable should be not null";
                throw new AssertionError((Object)string);
            }
            StringBuilder stringBuilder = new StringBuilder().append("Trying to access skipped parameter: ");
            ParameterInfo parameterInfo = info.parameterInfo;
            Intrinsics.checkNotNull((Object)parameterInfo);
            throw new RuntimeException(stringBuilder.append(parameterInfo.getType()).append(" at ").append(index).toString());
        }
        return info;
    }

    public final void visitIincInsn(int var, int increment, @NotNull MethodVisitor mv2) {
        Intrinsics.checkNotNullParameter((Object)mv2, (String)"mv");
        RemapInfo remap = this.remap(var);
        if (!(remap.value instanceof StackValue.Local)) {
            throw new AssertionError((Object)("Remapped value should be a local: " + remap.value));
        }
        mv2.visitIincInsn(((StackValue.Local)remap.value).index, increment);
    }

    public final void visitLocalVariable(@NotNull String name, @NotNull String desc, @Nullable String signature, @NotNull Label start, @NotNull Label end, int index, @NotNull MethodVisitor mv2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        Intrinsics.checkNotNullParameter((Object)mv2, (String)"mv");
        RemapInfo info = this.doRemap(index);
        if (RemapStatus.SHIFT == info.status) {
            StackValue stackValue = info.value;
            Intrinsics.checkNotNull((Object)stackValue, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.codegen.StackValue.Local");
            mv2.visitLocalVariable(name, desc, signature, start, end, ((StackValue.Local)stackValue).index);
        }
    }

    public final void visitVarInsn(int opcode, int var, @NotNull InstructionAdapter mv2, @NotNull KotlinTypeMapperBase typeMapper2) {
        Intrinsics.checkNotNullParameter((Object)mv2, (String)"mv");
        Intrinsics.checkNotNullParameter((Object)typeMapper2, (String)"typeMapper");
        RemapInfo remapInfo = this.remap(var);
        StackValue value = remapInfo.value;
        if (value instanceof StackValue.Local) {
            boolean isStore = InlineCodegenUtilsKt.isStoreInstruction(opcode);
            int localOpcode = remapInfo.parameterInfo != null ? ((StackValue.Local)value).type.getOpcode(isStore ? 54 : 21) : opcode;
            mv2.visitVarInsn(localOpcode, ((StackValue.Local)value).index);
            if (remapInfo.parameterInfo != null && !isStore) {
                StackValue.coerce(((StackValue.Local)value).type, remapInfo.parameterInfo.getType(), mv2);
            }
        } else {
            boolean bl;
            boolean bl2 = bl = remapInfo.parameterInfo != null;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Non local value should have parameter info";
                throw new AssertionError((Object)string);
            }
            StackValue stackValue = value;
            Intrinsics.checkNotNull((Object)stackValue);
            ParameterInfo parameterInfo = remapInfo.parameterInfo;
            Intrinsics.checkNotNull((Object)parameterInfo);
            stackValue.put(parameterInfo.getType(), null, mv2, typeMapper2);
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u0092\u0002\u0002\b\n\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u0092\u0002\u0002\b\n\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u0092\u0002\u0002\b\n\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapInfo;", "", "parameterInfo", "Lorg/jetbrains/kotlin/codegen/inline/ParameterInfo;", "value", "Lorg/jetbrains/kotlin/codegen/StackValue;", "status", "Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapStatus;", "<init>", "(Lorg/jetbrains/kotlin/codegen/inline/ParameterInfo;Lorg/jetbrains/kotlin/codegen/StackValue;Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapStatus;)V", "Lkotlin/jvm/JvmField;", "backend"})
    public static final class RemapInfo {
        @JvmField
        @Nullable
        public final ParameterInfo parameterInfo;
        @JvmField
        @Nullable
        public final StackValue value;
        @JvmField
        @NotNull
        public final RemapStatus status;

        public RemapInfo(@Nullable ParameterInfo parameterInfo, @Nullable StackValue value, @NotNull RemapStatus status2) {
            Intrinsics.checkNotNullParameter((Object)((Object)status2), (String)"status");
            this.parameterInfo = parameterInfo;
            this.value = value;
            this.status = status2;
        }

        public /* synthetic */ RemapInfo(ParameterInfo parameterInfo, StackValue stackValue, RemapStatus remapStatus, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                stackValue = null;
            }
            if ((n & 4) != 0) {
                remapStatus = RemapStatus.FAIL;
            }
            this(parameterInfo, stackValue, remapStatus);
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/codegen/inline/LocalVarRemapper$RemapStatus;", "", "<init>", "(Ljava/lang/String;I)V", "SHIFT", "REMAPPED", "FAIL", "backend"})
    public static final class RemapStatus
    extends Enum<RemapStatus> {
        public static final /* enum */ RemapStatus SHIFT = new RemapStatus();
        public static final /* enum */ RemapStatus REMAPPED = new RemapStatus();
        public static final /* enum */ RemapStatus FAIL = new RemapStatus();
        private static final /* synthetic */ RemapStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static RemapStatus[] values() {
            return (RemapStatus[])$VALUES.clone();
        }

        public static RemapStatus valueOf(String value) {
            return Enum.valueOf(RemapStatus.class, value);
        }

        @NotNull
        public static EnumEntries<RemapStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = remapStatusArray = new RemapStatus[]{RemapStatus.SHIFT, RemapStatus.REMAPPED, RemapStatus.FAIL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

