/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.container;

import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.container.ClashResolutionDescriptor;
import org.jetbrains.kotlin.container.ComponentContainer;
import org.jetbrains.kotlin.container.ComponentDescriptor;
import org.jetbrains.kotlin.container.PlatformExtensionsClashResolver;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u0010\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0000J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0010\u0010\u0015\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u000bj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/container/ComponentRegistry;", "", "<init>", "()V", "buildRegistrationMap", "Lcom/intellij/util/containers/MultiMap;", "Ljava/lang/reflect/Type;", "Lorg/jetbrains/kotlin/container/ComponentDescriptor;", "descriptors", "", "registrationMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "addAll", "", "tryGetEntry", "request", "other", "resolveClashesIfAny", "container", "Lorg/jetbrains/kotlin/container/ComponentContainer;", "clashResolvers", "", "Lorg/jetbrains/kotlin/container/PlatformExtensionsClashResolver;"})
public final class ComponentRegistry {
    @NotNull
    private final HashMap<Type, Object> registrationMap = new HashMap();

    @NotNull
    public final MultiMap<Type, ComponentDescriptor> buildRegistrationMap(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        MultiMap registrationMap = new MultiMap();
        for (ComponentDescriptor componentDescriptor : descriptors) {
            for (Type registration : componentDescriptor.getRegistrations()) {
                registrationMap.putValue((Object)registration, (Object)componentDescriptor);
            }
        }
        return registrationMap;
    }

    public final void addAll(@NotNull Collection<? extends ComponentDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        MultiMap<Type, ComponentDescriptor> newRegistrationMap = this.buildRegistrationMap(descriptors);
        for (Map.Entry entry : newRegistrationMap.entrySet()) {
            Object object;
            Object object2;
            Object oldEntries = this.registrationMap.get(entry.getKey());
            if (oldEntries != null || ((Collection)entry.getValue()).size() > 1) {
                List list = new ArrayList();
                if (oldEntries instanceof Collection) {
                    list.addAll((Collection)oldEntries);
                } else if (oldEntries != null) {
                    list.add((ComponentDescriptor)oldEntries);
                }
                Object v = entry.getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                list.addAll((Collection)v);
                object2 = this.registrationMap;
                object = entry.getKey();
                Object object3 = (ComponentDescriptor)CollectionsKt.singleOrNull((List)list);
                if (object3 == null) {
                    object3 = list;
                }
                ComponentDescriptor componentDescriptor = object3;
                object2.put((Object)object, (ComponentDescriptor)componentDescriptor);
                continue;
            }
            Map map = this.registrationMap;
            object2 = entry.getKey();
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            object = CollectionsKt.single((Iterable)((Iterable)v));
            map.put(object2, object);
        }
    }

    @NotNull
    public final Collection<ComponentDescriptor> tryGetEntry(@NotNull Type request) {
        Collection collection;
        Object value;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Object object = value = this.registrationMap.get(request);
        if (object instanceof Collection) {
            Object object2 = value;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Collection<org.jetbrains.kotlin.container.ComponentDescriptor>");
            collection = (Collection)object2;
        } else if (object == null) {
            collection = CollectionsKt.emptyList();
        } else {
            Object object3 = value;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.container.ComponentDescriptor");
            collection = CollectionsKt.listOf((Object)((ComponentDescriptor)object3));
        }
        return collection;
    }

    public final void addAll(@NotNull ComponentRegistry other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.registrationMap.isEmpty()) {
            throw new IllegalStateException("Can only copy entries from another component registry into an empty component registry");
        }
        ((Map)this.registrationMap).putAll((Map)other.registrationMap);
    }

    public final void resolveClashesIfAny(@NotNull ComponentContainer container, @NotNull List<? extends PlatformExtensionsClashResolver<?>> clashResolvers) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(clashResolvers, (String)"clashResolvers");
        for (PlatformExtensionsClashResolver<?> resolver : clashResolvers) {
            Collection clashedComponents;
            Object object = this.registrationMap.get(resolver.getApplicableTo());
            Collection collection = object instanceof Collection ? (Collection)object : null;
            if (collection == null || (clashedComponents = collection).size() <= 1) continue;
            ClashResolutionDescriptor substituteDescriptor = new ClashResolutionDescriptor(container, resolver, CollectionsKt.toList((Iterable)clashedComponents));
            ((Map)this.registrationMap).put(resolver.getApplicableTo(), substituteDescriptor);
        }
    }
}

