/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.JsScopesCollector;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\f\u0010\u001d\u001a\u00020\u001e*\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0007`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00070\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/KotlinLocalsUsageCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "scopeInfo", "Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;", "findValueDeclarationWithName", "Lkotlin/Function1;", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;Lkotlin/jvm/functions/Function1;)V", "functionStack", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "processedNames", "", "kotlinLocalsUsedInJs", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lkotlin/collections/LinkedHashMap;", "usedLocals", "", "getUsedLocals", "()Ljava/util/Map;", "visitFunction", "", "x", "visitNameRef", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "isDeclaredInsideJsCode", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCodeOutliningLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/KotlinLocalsUsageCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,409:1\n1#2:410\n*E\n"})
final class KotlinLocalsUsageCollector
extends RecursiveJsVisitor {
    @NotNull
    private final JsScopesCollector scopeInfo;
    @NotNull
    private final Function1<String, IrValueDeclaration> findValueDeclarationWithName;
    @NotNull
    private final List<JsFunction> functionStack;
    @NotNull
    private final Set<String> processedNames;
    @NotNull
    private final LinkedHashMap<JsName, IrValueDeclaration> kotlinLocalsUsedInJs;

    public KotlinLocalsUsageCollector(@NotNull JsScopesCollector scopeInfo, @NotNull Function1<? super String, ? extends IrValueDeclaration> findValueDeclarationWithName) {
        Intrinsics.checkNotNullParameter((Object)scopeInfo, (String)"scopeInfo");
        Intrinsics.checkNotNullParameter(findValueDeclarationWithName, (String)"findValueDeclarationWithName");
        this.scopeInfo = scopeInfo;
        this.findValueDeclarationWithName = findValueDeclarationWithName;
        Object[] objectArray = new JsFunction[]{null};
        this.functionStack = CollectionsKt.mutableListOf((Object[])objectArray);
        this.processedNames = new LinkedHashSet();
        this.kotlinLocalsUsedInJs = new LinkedHashMap();
    }

    @NotNull
    public final Map<JsName, IrValueDeclaration> getUsedLocals() {
        return this.kotlinLocalsUsedInJs;
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        UtilsKt.push(this.functionStack, (Object)x);
        super.visitFunction(x);
        UtilsKt.pop(this.functionStack);
    }

    @Override
    public void visitNameRef(@NotNull JsNameRef nameRef) {
        block2: {
            JsName jsName;
            Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
            super.visitNameRef(nameRef);
            JsName it = jsName = nameRef.getName();
            boolean bl = false;
            JsName jsName2 = nameRef.getQualifier() == null ? jsName : null;
            if (jsName2 == null) {
                return;
            }
            JsName name = jsName2;
            String string = name.getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
            if (!this.processedNames.add(string) || this.isDeclaredInsideJsCode(name)) break block2;
            String string2 = name.getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdent(...)");
            IrValueDeclaration irValueDeclaration = (IrValueDeclaration)this.findValueDeclarationWithName.invoke((Object)string2);
            if (irValueDeclaration != null) {
                it = irValueDeclaration;
                boolean bl2 = false;
                ((Map)this.kotlinLocalsUsedInJs).put(name, it);
            }
        }
    }

    private final boolean isDeclaredInsideJsCode(JsName $this$isDeclaredInsideJsCode) {
        JsFunction jsFunction = (JsFunction)UtilsKt.peek(this.functionStack);
        String string = $this$isDeclaredInsideJsCode.getIdent();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
        return this.scopeInfo.varWithNameExistsInScopeOf(jsFunction, string);
    }
}

