/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContext;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "Lorg/jetbrains/kotlin/js/backend/ast/SourceInfoAwareJsNode;", "<init>", "()V", "KeyValue", "Spread", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer$KeyValue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer$Spread;", "js.ast"})
public abstract class JsPropertyInitializer
extends SourceInfoAwareJsNode {
    private JsPropertyInitializer() {
    }

    public /* synthetic */ JsPropertyInitializer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u001c\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0000H\u0016J\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer$KeyValue;", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "labelExpr", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "valueExpr", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)V", "value", "getLabelExpr", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getValueExpr", "accept", "", "v", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "acceptChildren", "visitor", "traverse", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContext;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "deepCopy", "toString", "", "js.ast"})
    public static final class KeyValue
    extends JsPropertyInitializer {
        @NotNull
        private JsExpression labelExpr;
        @NotNull
        private JsExpression valueExpr;

        public KeyValue(@NotNull JsExpression labelExpr, @NotNull JsExpression valueExpr) {
            Intrinsics.checkNotNullParameter((Object)labelExpr, (String)"labelExpr");
            Intrinsics.checkNotNullParameter((Object)valueExpr, (String)"valueExpr");
            super(null);
            this.labelExpr = labelExpr;
            this.valueExpr = valueExpr;
        }

        @NotNull
        public final JsExpression getLabelExpr() {
            return this.labelExpr;
        }

        @NotNull
        public final JsExpression getValueExpr() {
            return this.valueExpr;
        }

        @Override
        public void accept(@NotNull JsVisitor v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v.visitKeyValuePropertyInitializer(this);
        }

        @Override
        public void acceptChildren(@NotNull JsVisitor visitor2) {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            visitor2.accept((JsNode)this.labelExpr);
            visitor2.accept((JsNode)this.valueExpr);
        }

        public void traverse(@NotNull JsVisitorWithContext v, @NotNull JsContext<?> ctx) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            if (v.visit(this, ctx)) {
                JsNode jsNode = v.accept((JsNode)this.labelExpr);
                Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"accept(...)");
                this.labelExpr = (JsExpression)jsNode;
                JsNode jsNode2 = v.accept((JsNode)this.valueExpr);
                Intrinsics.checkNotNullExpressionValue((Object)jsNode2, (String)"accept(...)");
                this.valueExpr = (JsExpression)jsNode2;
            }
            v.endVisit(this, ctx);
        }

        @Override
        @NotNull
        public KeyValue deepCopy() {
            JsExpression jsExpression = this.labelExpr.deepCopy();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"deepCopy(...)");
            JsExpression jsExpression2 = this.valueExpr.deepCopy();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression2, (String)"deepCopy(...)");
            HasMetadata hasMetadata = new KeyValue(jsExpression, jsExpression2).withMetadataFrom(this);
            Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"withMetadataFrom(...)");
            return (KeyValue)hasMetadata;
        }

        @Override
        @NotNull
        public String toString() {
            return this.labelExpr + ": " + this.valueExpr;
        }
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001c\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0000H\u0016J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer$Spread;", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "expression", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;)V", "value", "getExpression", "()Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "accept", "", "v", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitor;", "acceptChildren", "visitor", "traverse", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContext;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "deepCopy", "toString", "", "js.ast"})
    public static final class Spread
    extends JsPropertyInitializer {
        @NotNull
        private JsExpression expression;

        public Spread(@NotNull JsExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            super(null);
            this.expression = expression2;
        }

        @NotNull
        public final JsExpression getExpression() {
            return this.expression;
        }

        @Override
        public void accept(@NotNull JsVisitor v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            v.visitSpreadPropertyInitializer(this);
        }

        @Override
        public void acceptChildren(@NotNull JsVisitor visitor2) {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            visitor2.accept((JsNode)this.expression);
        }

        public void traverse(@NotNull JsVisitorWithContext v, @NotNull JsContext<?> ctx) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
            if (v.visit(this, ctx)) {
                JsNode jsNode = v.accept((JsNode)this.expression);
                Intrinsics.checkNotNullExpressionValue((Object)jsNode, (String)"accept(...)");
                this.expression = (JsExpression)jsNode;
            }
            v.endVisit(this, ctx);
        }

        @Override
        @NotNull
        public Spread deepCopy() {
            JsExpression jsExpression = this.expression.deepCopy();
            Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"deepCopy(...)");
            HasMetadata hasMetadata = new Spread(jsExpression).withMetadataFrom(this);
            Intrinsics.checkNotNullExpressionValue((Object)hasMetadata, (String)"withMetadataFrom(...)");
            return (Spread)hasMetadata;
        }

        @Override
        @NotNull
        public String toString() {
            return "..." + this.expression;
        }
    }
}

