/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.js.PredefinedAnnotation;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsExternalChecker;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.JsStandardClassIds;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.WasmPlatformKt;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDeclarationWithInitializer;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\f\u0010\u001a\u001a\u00020\u0003*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0003*\u00020\u001bH\u0002J\u0014\u0010\u001d\u001a\u00020\u0003*\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u001f\u001a\u00020\u0003*\u00020 2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExternalChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "allowCompanionInInterface", "", "allowUnsignedTypes", "<init>", "(ZZ)V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkBody", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDelegation", "checkAnonymousInitializer", "checkEnumEntry", "checkConstructorPropertyParam", "isDirectlyExternal", "isPrivateMemberOfExternalClass", "isNonAbstractMemberOfInterface", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isNullableProperty", "hasValidExternalBody", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "isDefinedExternallyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Companion", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsExternalChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsExternalChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n1#2:288\n1#2:303\n1807#3,3:289\n1642#3,10:292\n1915#3:302\n1916#3:304\n1652#3:305\n*S KotlinDebug\n*F\n+ 1 JsExternalChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsExternalChecker\n*L\n186#1:303\n105#1:289,3\n186#1:292,10\n186#1:302\n186#1:304\n186#1:305\n*E\n"})
public final class JsExternalChecker
implements DeclarationChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean allowCompanionInInterface;
    private final boolean allowUnsignedTypes;
    @NotNull
    private static final FqNameUnsafe DEFINED_EXTERNALLY_PROPERTY_NAME = JsStandardClassIds.Callables.JsDefinedExternally.asSingleFqName().toUnsafe();

    public JsExternalChecker(boolean allowCompanionInInterface, boolean allowUnsignedTypes) {
        this.allowCompanionInInterface = allowCompanionInInterface;
        this.allowUnsignedTypes = allowUnsignedTypes;
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!AnnotationsUtils.isNativeObject(descriptor)) {
            return;
        }
        BindingTrace trace = context.getTrace();
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor) && this.isDirectlyExternal(declaration, descriptor) && !(descriptor instanceof PropertyAccessorDescriptor)) {
            trace.report(ErrorsJs.NESTED_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration)));
        }
        if (descriptor instanceof ClassDescriptor) {
            String classKind;
            String string = ((ClassDescriptor)descriptor).isData() ? "data class" : (((ClassDescriptor)descriptor).isInner() ? "inner class" : (((ClassDescriptor)descriptor).isInline() ? "inline class" : (((ClassDescriptor)descriptor).isValue() ? "value class" : (((ClassDescriptor)descriptor).isFun() ? "fun interface" : (classKind = DescriptorUtils.isAnnotationClass(descriptor) ? "annotation class" : null)))));
            if (classKind != null) {
                trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration), classKind));
            }
            if (DescriptorUtils.isEnumClass(descriptor)) {
                TargetPlatform targetPlatform = context.getModuleDescriptor().getPlatform();
                if (!(targetPlatform != null ? WasmPlatformKt.isWasm((TargetPlatform)targetPlatform) : false)) {
                    trace.report(ErrorsJs.ENUM_CLASS_IN_EXTERNAL_DECLARATION_WARNING.on((KtElement)((PsiElement)declaration)));
                }
            }
        }
        if (descriptor instanceof PropertyAccessorDescriptor && this.isDirectlyExternal(declaration, descriptor)) {
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration), "property accessor"));
        } else if (!(descriptor instanceof ConstructorDescriptor) && !(descriptor instanceof FieldDescriptor) && this.isPrivateMemberOfExternalClass(descriptor)) {
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration), "private member of class"));
        }
        DeclarationDescriptor it = descriptor.getContainingDeclaration();
        boolean bl = false;
        boolean containingDeclarationsIsInterface = it instanceof ClassDescriptor && ((ClassDescriptor)it).getKind() == ClassKind.INTERFACE;
        if (descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() != ClassKind.INTERFACE && (!this.allowCompanionInInterface || !((ClassDescriptor)descriptor).isCompanionObject()) && containingDeclarationsIsInterface) {
            trace.report(ErrorsJs.NESTED_CLASS_IN_EXTERNAL_INTERFACE.on((KtExpression)((PsiElement)declaration)));
        }
        if (this.allowCompanionInInterface && DescriptorUtilsKt.isCompanionObject(descriptor) && containingDeclarationsIsInterface && !Intrinsics.areEqual((Object)descriptor.getName(), (Object)SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT)) {
            trace.report(ErrorsJs.NAMED_COMPANION_IN_EXTERNAL_INTERFACE.on((KtElement)((PsiElement)declaration)));
        }
        if (!(descriptor instanceof PropertyAccessorDescriptor) && DescriptorUtilsKt.isExtension(descriptor)) {
            it = descriptor;
            String target = it instanceof FunctionDescriptor ? "extension function" : (it instanceof PropertyDescriptor ? "extension property" : "extension member");
            trace.report(ErrorsJs.WRONG_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)declaration), target));
        }
        if (descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() != ClassKind.ANNOTATION_CLASS) {
            boolean bl2;
            block22: {
                Set superClasses = CollectionsKt.toMutableSet((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object)DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor)), (Iterable)DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor)));
                if (((ClassDescriptor)descriptor).getKind() == ClassKind.ENUM_CLASS || ((ClassDescriptor)descriptor).getKind() == ClassKind.ENUM_ENTRY) {
                    CollectionsKt.removeAll((Iterable)superClasses, JsExternalChecker::check$lambda$1);
                }
                Iterable $this$any$iv = superClasses;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ClassDescriptor it2 = (ClassDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!(!AnnotationsUtils.isNativeObject(it2) && !Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe(it2), (Object)StandardNames.FqNames.throwable))) continue;
                        bl2 = true;
                        break block22;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                trace.report(ErrorsJs.EXTERNAL_TYPE_EXTENDS_NON_EXTERNAL_TYPE.on((KtElement)((PsiElement)declaration)));
            }
        }
        if (descriptor instanceof FunctionDescriptor && ((FunctionDescriptor)descriptor).isInline()) {
            trace.report(ErrorsJs.INLINE_EXTERNAL_DECLARATION.on((KtDeclaration)((PsiElement)declaration)));
        }
        DiagnosticFactory0<KtElement> valueClassInExternalDiagnostic = context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowValueClassesInExternals) ? ErrorsJs.INLINE_CLASS_IN_EXTERNAL_DECLARATION_WARNING : ErrorsJs.INLINE_CLASS_IN_EXTERNAL_DECLARATION;
        Intrinsics.checkNotNull(valueClassInExternalDiagnostic);
        JsExternalChecker.check$reportOnParametersAndReturnTypesIf(descriptor, declaration, trace, valueClassInExternalDiagnostic, (Function1<? super KotlinType, Boolean>)((Function1)arg_0 -> JsExternalChecker.check$lambda$4(this, arg_0)));
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsEnableExtensionFunctionInExternals)) {
            DiagnosticFactory0<KtElement> diagnosticFactory0 = ErrorsJs.EXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"EXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION");
            JsExternalChecker.check$reportOnParametersAndReturnTypesIf(descriptor, declaration, trace, diagnosticFactory0, (Function1<? super KotlinType, Boolean>)((Function1)check.4.INSTANCE));
        }
        if (descriptor instanceof CallableMemberDescriptor && this.isNonAbstractMemberOfInterface((CallableMemberDescriptor)descriptor) && !this.isNullableProperty((CallableMemberDescriptor)descriptor)) {
            trace.report(ErrorsJs.NON_ABSTRACT_MEMBER_OF_EXTERNAL_INTERFACE.on((KtExpression)((PsiElement)declaration)));
        }
        DiagnosticSink diagnosticSink = trace;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        this.checkBody(declaration, descriptor, diagnosticSink, bindingContext);
        this.checkDelegation(declaration, descriptor, trace);
        this.checkAnonymousInitializer(declaration, trace);
        this.checkEnumEntry(declaration, trace);
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsExternalPropertyParameters)) {
            this.checkConstructorPropertyParam(declaration, descriptor, trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBody(KtDeclaration declaration, DeclarationDescriptor descriptor, DiagnosticSink diagnosticHolder, BindingContext bindingContext) {
        if (declaration instanceof KtProperty && descriptor instanceof PropertyAccessorDescriptor) {
            return;
        }
        if (declaration instanceof KtDeclarationWithBody && !this.hasValidExternalBody((KtDeclarationWithBody)declaration, bindingContext)) {
            KtExpression ktExpression = ((KtDeclarationWithBody)declaration).getBodyExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            diagnosticHolder.report(ErrorsJs.WRONG_BODY_OF_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)ktExpression)));
        } else if (declaration instanceof KtDeclarationWithInitializer) {
            KtExpression ktExpression = ((KtDeclarationWithInitializer)declaration).getInitializer();
            boolean bl = ktExpression != null ? !this.isDefinedExternallyExpression(ktExpression, bindingContext) : false;
            if (bl) {
                KtExpression ktExpression2 = ((KtDeclarationWithInitializer)declaration).getInitializer();
                Intrinsics.checkNotNull((Object)ktExpression2);
                diagnosticHolder.report(ErrorsJs.WRONG_INITIALIZER_OF_EXTERNAL_DECLARATION.on((KtExpression)((PsiElement)ktExpression2)));
            }
        }
        if (declaration instanceof KtCallableDeclaration) {
            void $this$mapNotNullTo$iv$iv;
            List list = ((KtCallableDeclaration)declaration).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            Iterable $this$mapNotNull$iv = list;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                KtExpression it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl2 = false;
                if (it.getDefaultValue() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            for (KtExpression defaultValue : (List)destination$iv$iv) {
                if (this.isDefinedExternallyExpression(defaultValue, bindingContext)) continue;
                diagnosticHolder.report(ErrorsJs.WRONG_DEFAULT_VALUE_FOR_EXTERNAL_FUN_PARAMETER.on((KtExpression)((PsiElement)defaultValue)));
            }
        }
    }

    private final void checkDelegation(KtDeclaration declaration, DeclarationDescriptor descriptor, DiagnosticSink diagnosticHolder) {
        block5: {
            block6: {
                block4: {
                    if (!(descriptor instanceof MemberDescriptor) || !DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor)) {
                        return;
                    }
                    if (!(declaration instanceof KtClassOrObject)) break block4;
                    for (KtSuperTypeListEntry superTypeEntry : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
                        KtSuperTypeListEntry ktSuperTypeListEntry = superTypeEntry;
                        if (ktSuperTypeListEntry instanceof KtSuperTypeCallEntry) {
                            KtValueArgumentList ktValueArgumentList = ((KtSuperTypeCallEntry)superTypeEntry).getValueArgumentList();
                            Intrinsics.checkNotNull((Object)ktValueArgumentList);
                            diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATED_CONSTRUCTOR_CALL.on((KtElement)((PsiElement)ktValueArgumentList)));
                            continue;
                        }
                        if (!(ktSuperTypeListEntry instanceof KtDelegatedSuperTypeEntry)) continue;
                        diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATION.on((KtElement)((PsiElement)superTypeEntry)));
                    }
                    break block5;
                }
                if (!(declaration instanceof KtSecondaryConstructor)) break block6;
                KtConstructorDelegationCall delegationCall = ((KtSecondaryConstructor)declaration).getDelegationCall();
                if (delegationCall.isImplicit()) break block5;
                diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATED_CONSTRUCTOR_CALL.on((KtElement)((PsiElement)delegationCall)));
                break block5;
            }
            if (!(declaration instanceof KtProperty) || descriptor instanceof PropertyAccessorDescriptor) break block5;
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration).getDelegate();
            if (ktPropertyDelegate != null) {
                KtPropertyDelegate delegate = ktPropertyDelegate;
                boolean bl = false;
                diagnosticHolder.report(ErrorsJs.EXTERNAL_DELEGATION.on((KtElement)((PsiElement)delegate)));
            }
        }
    }

    private final void checkAnonymousInitializer(KtDeclaration declaration, DiagnosticSink diagnosticHolder) {
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        for (KtAnonymousInitializer anonymousInitializer : ((KtClassOrObject)declaration).getAnonymousInitializers()) {
            diagnosticHolder.report(ErrorsJs.EXTERNAL_ANONYMOUS_INITIALIZER.on((KtAnonymousInitializer)((PsiElement)anonymousInitializer)));
        }
    }

    private final void checkEnumEntry(KtDeclaration declaration, DiagnosticSink diagnosticHolder) {
        block1: {
            if (!(declaration instanceof KtEnumEntry)) {
                return;
            }
            KtClassBody ktClassBody = ((KtEnumEntry)declaration).getBody();
            if (ktClassBody == null) break block1;
            KtClassBody it = ktClassBody;
            boolean bl = false;
            diagnosticHolder.report(ErrorsJs.EXTERNAL_ENUM_ENTRY_WITH_BODY.on((KtClassBody)((PsiElement)it)));
        }
    }

    private final void checkConstructorPropertyParam(KtDeclaration declaration, DeclarationDescriptor descriptor, DiagnosticSink diagnosticHolder) {
        if (!(descriptor instanceof PropertyDescriptor) || !(declaration instanceof KtParameter)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = ((PropertyDescriptor)descriptor).getContainingDeclaration();
        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        ClassDescriptor containingClass = (ClassDescriptor)declarationDescriptor;
        if (containingClass.isData() || DescriptorUtils.isAnnotationClass(containingClass)) {
            return;
        }
        diagnosticHolder.report(ErrorsJs.EXTERNAL_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)declaration)));
    }

    private final boolean isDirectlyExternal(KtDeclaration declaration, DeclarationDescriptor descriptor) {
        if (declaration instanceof KtProperty && descriptor instanceof PropertyAccessorDescriptor) {
            return false;
        }
        return declaration.hasModifier(KtTokens.EXTERNAL_KEYWORD) || AnnotationsUtils.hasAnnotation(descriptor, PredefinedAnnotation.NATIVE);
    }

    private final boolean isPrivateMemberOfExternalClass(DeclarationDescriptor descriptor) {
        if (descriptor instanceof PropertyAccessorDescriptor && Intrinsics.areEqual((Object)((PropertyAccessorDescriptor)descriptor).getVisibility(), (Object)((PropertyAccessorDescriptor)descriptor).getCorrespondingProperty().getVisibility())) {
            return false;
        }
        if (!(descriptor instanceof MemberDescriptor) || !Intrinsics.areEqual((Object)((MemberDescriptor)descriptor).getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = ((MemberDescriptor)descriptor).getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingDeclaration = classDescriptor;
        return AnnotationsUtils.isNativeObject(containingDeclaration);
    }

    private final boolean isNonAbstractMemberOfInterface(CallableMemberDescriptor $this$isNonAbstractMemberOfInterface) {
        return $this$isNonAbstractMemberOfInterface.getModality() != Modality.ABSTRACT && DescriptorUtils.isInterface($this$isNonAbstractMemberOfInterface.getContainingDeclaration()) && !($this$isNonAbstractMemberOfInterface instanceof PropertyAccessorDescriptor);
    }

    private final boolean isNullableProperty(CallableMemberDescriptor $this$isNullableProperty) {
        return $this$isNullableProperty instanceof PropertyDescriptor && TypeUtils.isNullableType(((PropertyDescriptor)$this$isNullableProperty).getType());
    }

    private final boolean hasValidExternalBody(KtDeclarationWithBody $this$hasValidExternalBody, BindingContext bindingContext) {
        boolean bl;
        if (!$this$hasValidExternalBody.hasBody()) {
            return true;
        }
        KtExpression ktExpression = $this$hasValidExternalBody.getBodyExpression();
        Intrinsics.checkNotNull((Object)ktExpression);
        KtExpression body = ktExpression;
        if (!$this$hasValidExternalBody.hasBlockBody()) {
            bl = this.isDefinedExternallyExpression(body, bindingContext);
        } else if (body instanceof KtBlockExpression) {
            List list = ((KtBlockExpression)body).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStatements(...)");
            KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list);
            if (ktExpression2 == null) {
                return false;
            }
            KtExpression statement = ktExpression2;
            bl = this.isDefinedExternallyExpression(statement, bindingContext);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isDefinedExternallyExpression(KtExpression $this$isDefinedExternallyExpression, BindingContext bindingContext) {
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)$this$isDefinedExternallyExpression, bindingContext);
        CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        PropertyDescriptor propertyDescriptor = callableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)callableDescriptor : null;
        if (propertyDescriptor == null) {
            return false;
        }
        PropertyDescriptor descriptor = propertyDescriptor;
        DeclarationDescriptor declarationDescriptor = descriptor.getContainingDeclaration();
        PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
        if (packageFragmentDescriptor == null) {
            return false;
        }
        PackageFragmentDescriptor container = packageFragmentDescriptor;
        FqNameUnsafe it = DEFINED_EXTERNALLY_PROPERTY_NAME;
        boolean bl = false;
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(container), (Object)it.parent()) && Intrinsics.areEqual((Object)descriptor.getName(), (Object)it.shortName());
    }

    private static final void check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super KotlinType, Boolean> $condition, BindingTrace trace, DiagnosticFactory0<KtElement> $diagnosticFactory, KotlinType type, KtElement elementToReport) {
        if (((Boolean)$condition.invoke((Object)type)).booleanValue()) {
            trace.report($diagnosticFactory.on((KtElement)((PsiElement)elementToReport)));
        }
    }

    private static final boolean check$lambda$1(ClassDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameUnsafe(it), (Object)StandardNames.FqNames._enum);
    }

    private static final void check$reportOnParametersAndReturnTypesIf(DeclarationDescriptor $descriptor, KtDeclaration $declaration, BindingTrace trace, DiagnosticFactory0<KtElement> diagnosticFactory, Function1<? super KotlinType, Boolean> condition) {
        block3: {
            KtModifierListOwner elementToReport;
            if (!($descriptor instanceof CallableMemberDescriptor) || $descriptor instanceof PropertyAccessorDescriptor && ((PropertyAccessorDescriptor)$descriptor).isDefault()) break block3;
            for (ValueParameterDescriptor p : ((CallableMemberDescriptor)$descriptor).getValueParameters()) {
                SourceElement sourceElement = p.getSource();
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
                PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)sourceElement);
                KtParameter ktParameter = psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
                KtDeclaration ktParam = ktParameter != null ? (KtDeclaration)ktParameter : $declaration;
                KotlinType kotlinType = p.getVarargElementType();
                if (kotlinType == null) {
                    KotlinType kotlinType2 = p.getType();
                    kotlinType = kotlinType2;
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
                }
                JsExternalChecker.check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, trace, diagnosticFactory, kotlinType, (KtElement)ktParam);
            }
            KtDeclaration ktDeclaration = $declaration;
            KtModifierListOwner ktModifierListOwner = elementToReport = ktDeclaration instanceof KtCallableDeclaration ? (KtModifierListOwner)((KtCallableDeclaration)$declaration).getTypeReference() : (ktDeclaration instanceof KtPropertyAccessor ? (KtModifierListOwner)((KtPropertyAccessor)$declaration).getTypeReference() : (KtModifierListOwner)$declaration);
            if (ktModifierListOwner != null) {
                KtModifierListOwner it = ktModifierListOwner;
                boolean bl = false;
                KotlinType kotlinType = ((CallableMemberDescriptor)$descriptor).getReturnType();
                Intrinsics.checkNotNull((Object)kotlinType);
                JsExternalChecker.check$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, trace, diagnosticFactory, kotlinType, (KtElement)it);
            }
        }
    }

    private static final boolean check$lambda$4(JsExternalChecker this$0, KotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return InlineClassesUtilsKt.isInlineClassType(it) && (!TypeUtilsKt.isUnsignedNumberType(it) || !this$0.allowUnsignedTypes);
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsExternalChecker$Companion;", "", "<init>", "()V", "DEFINED_EXTERNALLY_PROPERTY_NAME", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getDEFINED_EXTERNALLY_PROPERTY_NAME", "()Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "js.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqNameUnsafe getDEFINED_EXTERNALLY_PROPERTY_NAME() {
            return DEFINED_EXTERNALLY_PROPERTY_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

