/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.wasm.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Iterator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.wasm.resolve.diagnostics.ErrorsWasm;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0013\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017\u00b2\u0006\n\u0010\u0018\u001a\u00020\u0019X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/kotlin/wasm/resolve/diagnostics/WasmImportAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "wasmImportFqName", "Lorg/jetbrains/kotlin/name/FqName;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isParameterTypeSupported", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isReturnTypeSupported", "checkSignatureIsPrimitive", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "wasm.frontend", "valueParameterDeclaration", "Lcom/intellij/psi/PsiElement;"})
public final class WasmImportAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final WasmImportAnnotationChecker INSTANCE = new WasmImportAnnotationChecker();
    @NotNull
    private static final FqName wasmImportFqName = new FqName("kotlin.wasm.WasmImport");

    private WasmImportAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        PsiElement wasmImportPsi;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AnnotationDescriptor annotationDescriptor = descriptor.getAnnotations().findAnnotation(wasmImportFqName);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor wasmImport = annotationDescriptor;
        BindingTrace trace = context.getTrace();
        PsiElement psiElement = PsiSourceElementKt.getPsi((SourceElement)wasmImport.getSource());
        if (psiElement == null) {
            psiElement = wasmImportPsi = (PsiElement)declaration;
        }
        if (!DescriptorUtils.isTopLevelDeclaration(descriptor)) {
            trace.report(ErrorsWasm.NESTED_WASM_IMPORT.on(wasmImportPsi));
        }
        if (descriptor instanceof FunctionDescriptor) {
            if (!DescriptorUtilsKt.isEffectivelyExternal((MemberDescriptor)descriptor)) {
                trace.report(ErrorsWasm.WASM_IMPORT_ON_NON_EXTERNAL_DECLARATION.on(wasmImportPsi));
            }
            this.checkSignatureIsPrimitive((FunctionDescriptor)descriptor, trace, declaration);
        }
    }

    private final boolean isParameterTypeSupported(KotlinType type) {
        return TypeUtilsKt.isPrimitiveNumberType(type) || TypeUtilsKt.isUnsignedNumberType(type) || TypeUtilsKt.isBoolean(type);
    }

    private final boolean isReturnTypeSupported(KotlinType type) {
        return this.isParameterTypeSupported(type) || TypeUtilsKt.isUnit(type);
    }

    public final void checkSignatureIsPrimitive(@NotNull FunctionDescriptor descriptor, @NotNull BindingTrace trace, @NotNull KtDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Iterator<ValueParameterDescriptor> iterator2 = descriptor.getValueParameters().iterator();
        while (iterator2.hasNext()) {
            ValueParameterDescriptor parameter;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            Lazy valueParameterDeclaration$delegate = LazyKt.lazy(() -> WasmImportAnnotationChecker.checkSignatureIsPrimitive$lambda$0(parameter));
            if (parameter.declaresDefaultValue()) {
                trace.report(ErrorsWasm.WASM_IMPORT_EXPORT_PARAMETER_DEFAULT_VALUE.on(WasmImportAnnotationChecker.checkSignatureIsPrimitive$lambda$1((Lazy<? extends PsiElement>)valueParameterDeclaration$delegate)));
            }
            if (ArgumentsUtilsKt.isVararg(parameter)) {
                trace.report(ErrorsWasm.WASM_IMPORT_EXPORT_VARARG_PARAMETER.on(WasmImportAnnotationChecker.checkSignatureIsPrimitive$lambda$1((Lazy<? extends PsiElement>)valueParameterDeclaration$delegate)));
            }
            KotlinType kotlinType = parameter.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (this.isParameterTypeSupported(kotlinType)) continue;
            trace.report(ErrorsWasm.WASM_IMPORT_EXPORT_UNSUPPORTED_PARAMETER_TYPE.on(WasmImportAnnotationChecker.checkSignatureIsPrimitive$lambda$1((Lazy<? extends PsiElement>)valueParameterDeclaration$delegate), parameter.getType()));
        }
        KotlinType returnType = descriptor.getReturnType();
        if (returnType != null && !this.isReturnTypeSupported(returnType)) {
            trace.report(ErrorsWasm.WASM_IMPORT_EXPORT_UNSUPPORTED_RETURN_TYPE.on((PsiElement)declaration, returnType));
        }
    }

    private static final PsiElement checkSignatureIsPrimitive$lambda$1(Lazy<? extends PsiElement> $valueParameterDeclaration$delegate) {
        Lazy<? extends PsiElement> lazy = $valueParameterDeclaration$delegate;
        return (PsiElement)lazy.getValue();
    }

    private static final PsiElement checkSignatureIsPrimitive$lambda$0(ValueParameterDescriptor $parameter) {
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration($parameter);
        Intrinsics.checkNotNull((Object)psiElement);
        return psiElement;
    }
}

