/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.ExpandStateHandler;
import com.intellij.designer.componentTree.TreeContentProvider;
import com.intellij.designer.componentTree.TreeDropListener;
import com.intellij.designer.componentTree.TreeEditableArea;
import com.intellij.designer.designSurface.ComponentGlassLayer;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;

public final class ComponentTreeBuilder
implements ComponentSelectionListener,
Disposable {
    private final ComponentTree myTree;
    private final StructureTreeModel<TreeContentProvider> myStructureTreeModel;
    private final EditableArea mySurfaceArea;
    private final TreeEditableArea myTreeArea;
    private final ComponentGlassLayer myGlassLayer;
    private final ExpandStateHandler myExpandStateHandler;

    public ComponentTreeBuilder(ComponentTree tree, DesignerEditorPanel designer) {
        this.myTree = tree;
        this.myStructureTreeModel = new StructureTreeModel((AbstractTreeStructure)new TreeContentProvider(designer), (Disposable)this);
        tree.setModel((TreeModel)new AsyncTreeModel(this.myStructureTreeModel, (Disposable)this));
        this.mySurfaceArea = designer.getSurfaceArea();
        this.myTreeArea = new TreeEditableArea(tree, this.myStructureTreeModel, designer.getActionPanel());
        this.myGlassLayer = new ComponentGlassLayer((JComponent)((Object)tree), designer.getToolProvider(), this.myTreeArea);
        this.myExpandStateHandler = new ExpandStateHandler(tree, designer);
        tree.setArea(this.myTreeArea);
        designer.handleTreeArea(this.myTreeArea);
        TreeDropListener.installOn(tree, this.myTreeArea, designer.getToolProvider());
        this.selectFromSurface();
        this.expandFromState();
        this.addListeners();
        this.myExpandStateHandler.hookListener();
    }

    public TreeEditableArea getTreeArea() {
        return this.myTreeArea;
    }

    public void dispose() {
        this.removeListeners();
        this.myTreeArea.unhookSelection();
        this.myGlassLayer.dispose();
        this.myExpandStateHandler.unhookListener();
    }

    private void addListeners() {
        this.mySurfaceArea.addSelectionListener(this);
        this.myTreeArea.addSelectionListener(this);
    }

    private void removeListeners() {
        this.mySurfaceArea.removeSelectionListener(this);
        this.myTreeArea.removeSelectionListener(this);
    }

    @Override
    public void selectionChanged(EditableArea area) {
        block7: {
            try {
                this.removeListeners();
                if (this.mySurfaceArea == area) {
                    try {
                        this.myTreeArea.setCanvasSelection(true);
                        this.myTreeArea.setSelection(this.mySurfaceArea.getSelection());
                        break block7;
                    }
                    finally {
                        this.myTreeArea.setCanvasSelection(false);
                    }
                }
                this.mySurfaceArea.setSelection(this.myTreeArea.getSelection());
                this.mySurfaceArea.scrollToSelection();
            }
            finally {
                this.addListeners();
            }
        }
    }

    public void selectFromSurface() {
        this.myTreeArea.setSelection(this.mySurfaceArea.getSelection());
    }

    public void expandFromState() {
        for (Object element : this.myExpandStateHandler.getExpanded()) {
            this.myStructureTreeModel.expand(element, (JTree)((Object)this.myTree), path -> {});
        }
    }

    public void queueUpdate() {
        this.myStructureTreeModel.invalidateAsync();
    }
}

