/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackTreeLayer;
import com.intellij.designer.model.RadComponent;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComponentEditableArea
implements EditableArea {
    private final JComponent myComponent;
    private final EventListenerList myListenerList = new EventListenerList();
    private List<RadComponent> mySelection = new ArrayList<RadComponent>();

    public ComponentEditableArea(JComponent component) {
        this.myComponent = component;
    }

    @Override
    public void addSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.add(ComponentSelectionListener.class, listener);
    }

    @Override
    public void removeSelectionListener(ComponentSelectionListener listener) {
        this.myListenerList.remove(ComponentSelectionListener.class, listener);
    }

    protected void fireSelectionChanged() {
        for (ComponentSelectionListener listener : (ComponentSelectionListener[])this.myListenerList.getListeners(ComponentSelectionListener.class)) {
            listener.selectionChanged(this);
        }
    }

    @Override
    @NotNull
    public List<RadComponent> getSelection() {
        List<RadComponent> list = this.mySelection;
        if (list == null) {
            ComponentEditableArea.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    public boolean isSelected(@NotNull RadComponent component) {
        if (component == null) {
            ComponentEditableArea.$$$reportNull$$$0(1);
        }
        return this.mySelection.contains((Object)component);
    }

    @Override
    public void select(@NotNull RadComponent component) {
        if (component == null) {
            ComponentEditableArea.$$$reportNull$$$0(2);
        }
        this.mySelection = new ArrayList<RadComponent>();
        this.mySelection.add(component);
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(@NotNull RadComponent component) {
        if (component == null) {
            ComponentEditableArea.$$$reportNull$$$0(3);
        }
        this.mySelection.remove((Object)component);
        this.fireSelectionChanged();
    }

    @Override
    public void appendSelection(@NotNull RadComponent component) {
        if (component == null) {
            ComponentEditableArea.$$$reportNull$$$0(4);
        }
        this.mySelection.remove((Object)component);
        this.mySelection.add(component);
        this.fireSelectionChanged();
    }

    @Override
    public void setSelection(@NotNull List<RadComponent> components) {
        if (components == null) {
            ComponentEditableArea.$$$reportNull$$$0(5);
        }
        this.mySelection = new ArrayList<RadComponent>(components);
        this.fireSelectionChanged();
    }

    @Override
    public void deselect(@NotNull Collection<RadComponent> components) {
        if (components == null) {
            ComponentEditableArea.$$$reportNull$$$0(6);
        }
        this.mySelection.removeAll(components);
        this.fireSelectionChanged();
    }

    @Override
    public void deselectAll() {
        this.mySelection = new ArrayList<RadComponent>();
        this.fireSelectionChanged();
    }

    @Override
    public void scrollToSelection() {
    }

    @Override
    public void setCursor(@Nullable Cursor cursor) {
        this.myComponent.setCursor(cursor);
    }

    @Override
    public void setDescription(@Nullable String text) {
        ActionMenu.showDescriptionInStatusBar((boolean)true, (Component)this.myComponent, (String)text);
    }

    @Override
    @NotNull
    public JComponent getNativeComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            ComponentEditableArea.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @Override
    public boolean isTree() {
        return false;
    }

    @Override
    @Nullable
    public FeedbackTreeLayer getFeedbackTreeLayer() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/designSurface/ComponentEditableArea";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/designSurface/ComponentEditableArea";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNativeComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deselect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendSelection";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

