/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.componentTree.TreeDropListener;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class GlassLayer
extends JComponent
implements UiDataProvider {
    private static final long EVENT_FLAGS = 56L;
    private final ToolProvider myToolProvider;
    private final EditableArea myArea;

    public GlassLayer(ToolProvider provider, EditableArea area) {
        this.myToolProvider = provider;
        this.myArea = area;
        this.enableEvents(56L);
        TreeDropListener.installOn(this, area, provider, PaletteItem.class);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.enableEvents(56L);
        } else {
            this.disableEvents(56L);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent event) {
        this.myToolProvider.processKeyEvent(event, this.myArea);
        if (!event.isConsumed()) {
            super.processKeyEvent(event);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent event) {
        if (event.getID() == 501) {
            this.requestFocusInWindow();
        }
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent event) {
        this.myToolProvider.processMouseEvent(event, this.myArea);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            GlassLayer.$$$reportNull$$$0(0);
        }
        sink.set(EditableArea.DATA_KEY, (Object)this.myArea);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/designer/designSurface/GlassLayer", "uiDataSnapshot"));
    }
}

